/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import jetbrains.mps.baseLanguage.tuples.runtime.MultiTuple;
import jetbrains.mps.baseLanguage.tuples.runtime.Tuples;

public final class FilterUtils {
    public static Tuples._2<String, String> filter(String text, String email) {
        int end;
        String[] strings = text.split("\\r?\\n");
        if (text == null || text.length() == 0 || strings.length == 0) {
            return MultiTuple.from((Object)"", (Object)"");
        }
        int firstLine = 0;
        int lastLine = strings.length;
        int signatureStart = -1;
        int quoteStart = -1;
        int quoteEnd = -1;
        for (int i2 = strings.length - 1; i2 >= 0; --i2) {
            String string = strings[i2].trim();
            if (!string.matches("\\-+")) continue;
            signatureStart = i2;
        }
        int n = end = signatureStart >= 0 ? signatureStart : strings.length;
        if (FilterUtils.isThunderbirdStyleReply(strings, end, email)) {
            firstLine = FilterUtils.skipThunderbirdQuote(strings, end);
            quoteStart = 0;
            quoteEnd = firstLine;
        }
        for (int i3 = firstLine; i3 < strings.length; ++i3) {
            if (!FilterUtils.isGmailStyleReply(strings, i3, end, email)) continue;
            lastLine = i3;
            quoteStart = i3;
            quoteEnd = FilterUtils.skipEmptyLines(strings, strings.length);
            break;
        }
        lastLine = FilterUtils.skipEmptyLines(strings, lastLine);
        Tuples._2 result = MultiTuple.from((Object)"", (Object)"");
        if (firstLine > 0 || lastLine < strings.length) {
            StringBuilder builder = new StringBuilder();
            FilterUtils.appendRange(builder, strings, firstLine, lastLine);
            result._0((Object)builder.toString());
            if (quoteStart != -1) {
                builder = new StringBuilder();
                FilterUtils.appendRange(builder, strings, quoteStart, quoteEnd);
                result._1((Object)builder.toString());
            }
        } else {
            result._0((Object)text);
        }
        return result;
    }

    private static boolean mildCheckLine(String[] strings, int line, String str) {
        return line < strings.length && strings[line].contains(str);
    }

    private static boolean isReplyLine(String[] strings, int start, String email) {
        String string = strings[start];
        if (start + 1 < strings.length && string.contains("<")) {
            string = string.concat(strings[start + 1]);
        }
        return string.contains("<" + email + ">") || strings[start].endsWith(":");
    }

    private static boolean isFromSubjectReply(String[] strings, int start, String fromLocal, String subjectLocal) {
        boolean from = FilterUtils.mildCheckLine(strings, start, fromLocal);
        boolean subject = false;
        for (int i2 = 1; i2 < 10; ++i2) {
            subject = subject || FilterUtils.mildCheckLine(strings, start + i2, subjectLocal);
        }
        return from && subject;
    }

    private static boolean isTheRestStrictQuotes(String[] strings, int start, int end) {
        boolean result = true;
        for (int i2 = start + 1; i2 < end; ++i2) {
            String string = strings[i2];
            if (string.trim().length() <= 0 || string.startsWith(">") || string.startsWith("\t") || string.startsWith("    ")) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean isTheRestMildQuotes(String[] strings, int start, int end) {
        boolean result = false;
        for (int i2 = start + 1; i2 < end; ++i2) {
            String string = strings[i2].trim();
            if (string.length() <= 0) continue;
            if (!string.startsWith(">")) break;
            result = true;
            break;
        }
        return result;
    }

    private static int skipThunderbirdQuote(String[] strings, int end) {
        int start;
        for (start = 1; start < end && (strings[start].startsWith(">") || strings[start].trim().length() == 0); ++start) {
        }
        return start;
    }

    private static boolean isGmailStyleReply(String[] strings, int start, int end, String email) {
        return FilterUtils.isReplyLine(strings, start, email) && FilterUtils.isTheRestStrictQuotes(strings, start + 1, end) || FilterUtils.isFromSubjectReply(strings, start, "From", "Subject") || FilterUtils.isFromSubjectReply(strings, start, "Von", "Betreff") || FilterUtils.isFromSubjectReply(strings, start, "\u041e\u0442", "\u0422\u0435\u043c\u0430");
    }

    private static boolean isThunderbirdStyleReply(String[] strings, int end, String email) {
        return FilterUtils.isReplyLine(strings, 0, email) && FilterUtils.isTheRestMildQuotes(strings, 0, end);
    }

    private static void appendRange(StringBuilder builder, String[] strings, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            String string = strings[i2];
            builder.append(string);
            builder.append("\n");
        }
    }

    private static int skipEmptyLines(String[] strings, int lastLine) {
        String string;
        int result = lastLine;
        int i2 = lastLine - 1;
        while (i2 >= 0 && ((string = strings[i2].trim()).equals("") || string.equals("=20"))) {
            result = i2--;
        }
        return result;
    }
}

