/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.net.ssl.SSLContext;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.ssl.SSLContextFactory;
import jetbrains.youtrack.mailbox.fetch.MailboxConnection$password$1;
import jetbrains.youtrack.mailbox.fetch.MailboxConnection$password$2;
import jetbrains.youtrack.mailbox.persistence.XdMailbox;
import jetbrains.youtrack.mailbox.service.BeansKt;
import jetbrains.youtrack.mailbox.service.MailboxWatchDog;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\u0004\u0012\u00020\u000e0\u0012J2\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J)\u0010\u001e\u001a\u00020\u000e2!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u000e0\u0012J\u000e\u0010#\u001a\u00020\u000e*\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Ljetbrains/youtrack/mailbox/fetch/MailboxConnection;", "", "mailbox", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "(Ljetbrains/youtrack/mailbox/persistence/XdMailbox;)V", "password", "", "getPassword", "()Ljava/lang/String;", "port", "", "getPort", "()I", "check", "", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getStore", "Ljavax/mail/Store;", "protocol", "connectionTimeout", "socketTimeout", "sslKey", "Ljetbrains/exodus/entitystore/Entity;", "exchange", "", "open", "process", "Lkotlin/ParameterName;", "name", "store", "closeSafe", "Companion", "youtrack-mailbox"})
public final class MailboxConnection {
    private final XdMailbox mailbox;
    public static final Companion Companion = new Companion(null);

    private final int getPort() {
        return this.mailbox.getPort() > 0 ? this.mailbox.getPort() : this.mailbox.getProtocol().getDefaultPort();
    }

    private final String getPassword() {
        String string = this.mailbox.getPassword();
        if (string == null) {
            Comparable value$iv;
            KProperty1 $receiver$iv;
            KProperty1 kProperty1 = (KProperty1)MailboxConnection$password$1.INSTANCE;
            Comparable comparable = (Comparable)((Object)this.mailbox.getHost());
            XdEntityType xdEntityType = (XdEntityType)XdMailbox.Companion;
            NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdMailbox.class)), (Comparable)value$iv);
            $receiver$iv = (KProperty1)MailboxConnection$password$2.INSTANCE;
            value$iv = (Comparable)((Object)this.mailbox.getLogin());
            NodeBase nodeBase2 = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdMailbox.class)), (Comparable)value$iv);
            XdMailbox xdMailbox = (XdMailbox)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)NodeBaseOperationsKt.and((NodeBase)nodeBase, (NodeBase)nodeBase2)));
            string = xdMailbox != null ? xdMailbox.getPassword() : null;
        }
        return string;
    }

    public final void check(@NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        String protocol = this.mailbox.getProtocol().getProtocolName();
        int connectionTimeout = this.mailbox.getConnectionTimeOut();
        int socketTimeout = this.mailbox.getSocketTimeOut();
        Entity sslKey = AssociationSemantics.getToOne((Entity)this.mailbox.getEntity(), (String)"sslKey");
        boolean exchange = this.mailbox.getExchangeCompatibilityMode();
        String login = this.mailbox.getLogin();
        String password2 = this.getPassword();
        String host = this.mailbox.getHost();
        int port = this.getPort();
        jetbrains.charisma.persistent.BeansKt.getQuartzThreadExecutor().execute(new Runnable(this, protocol, connectionTimeout, socketTimeout, sslKey, exchange, host, port, login, password2, onSuccess, onError){
            final /* synthetic */ MailboxConnection this$0;
            final /* synthetic */ String $protocol;
            final /* synthetic */ int $connectionTimeout;
            final /* synthetic */ int $socketTimeout;
            final /* synthetic */ Entity $sslKey;
            final /* synthetic */ boolean $exchange;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ String $login;
            final /* synthetic */ String $password;
            final /* synthetic */ Function0 $onSuccess;
            final /* synthetic */ Function1 $onError;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                Store store = null;
                try {
                    store = MailboxConnection.access$getStore(this.this$0, this.$protocol, this.$connectionTimeout, this.$socketTimeout, this.$sslKey, this.$exchange);
                    store.connect(this.$host, this.$port, this.$login, this.$password);
                    this.$onSuccess.invoke();
                }
                catch (MessagingException e) {
                    this.$onError.invoke((Object)((Object)e));
                }
                catch (Exception e) {
                    this.$onError.invoke((Object)e);
                    MailboxConnection.Companion.getLogger().warn("Mailbox connection check failed: ", (Throwable)e);
                }
                finally {
                    Store store2 = store;
                    if (store2 != null) {
                        MailboxConnection.access$closeSafe(this.this$0, store2);
                    }
                }
            }
            {
                this.this$0 = mailboxConnection;
                this.$protocol = string;
                this.$connectionTimeout = n;
                this.$socketTimeout = n2;
                this.$sslKey = entity;
                this.$exchange = bl;
                this.$host = string2;
                this.$port = n3;
                this.$login = string3;
                this.$password = string4;
                this.$onSuccess = function0;
                this.$onError = function1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(@NotNull Function1<? super Store, Unit> process2) {
        Intrinsics.checkParameterIsNotNull(process2, (String)"process");
        Store store = null;
        try {
            store = this.getStore(this.mailbox.getProtocol().getProtocolName(), this.mailbox.getConnectionTimeOut(), this.mailbox.getSocketTimeOut(), AssociationSemantics.getToOne((Entity)this.mailbox.getEntity(), (String)"sslKey"), this.mailbox.getExchangeCompatibilityMode());
            store.connect(this.mailbox.getHost(), this.getPort(), this.mailbox.getLogin(), this.getPassword());
            process2.invoke((Object)store);
        }
        finally {
            Store store2 = store;
            if (store2 != null) {
                this.closeSafe(store2);
            }
        }
    }

    private final void closeSafe(@Nullable Store $receiver) {
        try {
            Store store = $receiver;
            if (store != null) {
                store.close();
            }
        }
        catch (MessagingException e) {
            Companion.getLogger().error(this.mailbox.getDebugString() + " Can't close store", (Throwable)e);
        }
    }

    private final Store getStore(String protocol, int connectionTimeout, int socketTimeout, Entity sslKey, boolean exchange) {
        Properties properties = new Properties(System.getProperties());
        Map map = properties;
        String string = "mail." + protocol + ".connectiontimeout";
        Object object = String.valueOf(connectionTimeout * 1000);
        map.put(string, object);
        map = properties;
        string = "mail." + protocol + ".timeout";
        object = String.valueOf(socketTimeout * 1000);
        map.put(string, object);
        map = properties;
        string = "mail." + protocol + ".starttls.enable";
        object = true;
        map.put(string, object);
        map = properties;
        string = "mail." + protocol + ".ssl.socketFactory";
        Object object2 = ServiceLocator.getBean((String)"sslContextFactory");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.core.ssl.SSLContextFactory");
        }
        SSLContext sSLContext = ((SSLContextFactory)object2).createContext(sslKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"(ServiceLocator.getBean(\u2026ry).createContext(sslKey)");
        object = sSLContext.getSocketFactory();
        map.put(string, object);
        if (exchange) {
            map = properties;
            string = "mail." + protocol + ".auth.plain.disable";
            object = true;
            map.put(string, object);
            map = properties;
            string = "mail." + protocol + ".auth.ntlm.disable";
            object = true;
            map.put(string, object);
            map = properties;
            string = "mail." + protocol + ".auth.gssapi.disable";
            object = true;
            map.put(string, object);
        }
        map = properties;
        string = "mail." + protocol + ".fetchsize";
        object = 0x100000;
        map.put(string, object);
        map = properties;
        string = "mail.mime.charset";
        object = "utf-8";
        map.put(string, object);
        Store store = Session.getInstance((Properties)properties, null).getStore(protocol);
        MailboxWatchDog mailboxWatchDog = BeansKt.getMailboxWatchDog();
        Store store2 = store;
        Intrinsics.checkExpressionValueIsNotNull((Object)store2, (String)"store");
        mailboxWatchDog.watchFor(store2, this.mailbox);
        return store;
    }

    public MailboxConnection(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        this.mailbox = mailbox2;
    }

    public static final /* synthetic */ Store access$getStore(MailboxConnection $this, String protocol, int connectionTimeout, int socketTimeout, Entity sslKey, boolean exchange) {
        return $this.getStore(protocol, connectionTimeout, socketTimeout, sslKey, exchange);
    }

    public static final /* synthetic */ void access$closeSafe(MailboxConnection $this, Store $receiver) {
        $this.closeSafe($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/mailbox/fetch/MailboxConnection$Companion;", "Lmu/KLogging;", "()V", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

