/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.youtrack.mailbox.fetch.FetchedMessage;
import jetbrains.youtrack.mailbox.fetch.MessageIdUtils;
import jetbrains.youtrack.mailbox.fetch.MessagePartsVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessagePartsUtil {
    protected static Log log = LogFactory.getLog(MessagePartsUtil.class);

    public static void traverseParts(Message _this, MessagePartsVisitor visitor) throws MessagingException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Traverse message " + MessageIdUtils.getMessageId(_this) + ", visitor: " + visitor.getClass().getSimpleName()));
        }
        IListSequence stack = ListSequence.fromList(new ArrayList());
        ListSequence.fromList((List)stack).addElement((Object)_this);
        while (ListSequence.fromList((List)stack).isNotEmpty()) {
            Part part = (Part)ListSequence.fromList((List)stack).removeLastElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Visit part with mime-type: " + part.getContentType()));
            }
            try {
                if (part.isMimeType(FetchedMessage.MIME_TEXT)) {
                    String disposition = part.getDisposition();
                    if ("attachment".equalsIgnoreCase(disposition)) {
                        visitor.visitAttachment(part);
                        continue;
                    }
                    if (part.isMimeType(FetchedMessage.TEXT_HTML)) {
                        visitor.visitHtmlText((String)part.getContent());
                        continue;
                    }
                    if (part.isMimeType(FetchedMessage.TEXT_PLAIN)) {
                        visitor.visitPlainText((String)part.getContent());
                        continue;
                    }
                    visitor.visitAttachment(part);
                    continue;
                }
                if (part.isMimeType(FetchedMessage.MIME_MULTIPART)) {
                    int i2;
                    Multipart multipart = (Multipart)part.getContent();
                    BodyPart attachmentSubrart = null;
                    for (i2 = multipart.getCount() - 1; i2 >= 0; --i2) {
                        BodyPart subPart = multipart.getBodyPart(i2);
                        if (!"attachment".equalsIgnoreCase(subPart.getDisposition())) continue;
                        attachmentSubrart = subPart;
                    }
                    if (part.isMimeType(FetchedMessage.MIME_MULTIPART_ALTERNATIVE) && attachmentSubrart != null) {
                        ListSequence.fromList((List)stack).addElement(attachmentSubrart);
                        continue;
                    }
                    for (i2 = multipart.getCount() - 1; i2 >= 0; --i2) {
                        ListSequence.fromList((List)stack).addElement((Object)multipart.getBodyPart(i2));
                    }
                    continue;
                }
                if (part.isMimeType(FetchedMessage.MESSAGE_RFC822)) {
                    ListSequence.fromList((List)stack).addElement((Object)((Part)part.getContent()));
                    continue;
                }
                visitor.visitAttachment(part);
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"Ignored corrupted message part", (Throwable)e);
            }
        }
    }
}

