/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.fetch;

import javax.mail.Part;
import jetbrains.youtrack.mailbox.fetch.MessagePartsVisitor;
import org.jetbrains.annotations.NotNull;

public class TextBodyPartsVisitor
implements MessagePartsVisitor {
    private StringBuilder htmlDescription = new StringBuilder();
    private StringBuilder plainTextDescription = new StringBuilder();
    private Boolean hasAttachment = false;

    @Override
    public boolean visitPlainText(String content) {
        this.plainTextDescription.append(content);
        return false;
    }

    @Override
    public boolean visitHtmlText(String content) {
        this.htmlDescription.append(content);
        return false;
    }

    @Override
    public boolean visitAttachment(Part part) {
        this.hasAttachment = true;
        return true;
    }

    @NotNull
    public String getHtmlDescription() {
        return this.htmlDescription.toString().trim();
    }

    @NotNull
    public String getPlainTextDescription() {
        return this.plainTextDescription.toString().trim();
    }

    public Boolean hasAttachment() {
        return this.hasAttachment;
    }

    public boolean hasHtml() {
        return !this.htmlDescription.toString().isEmpty();
    }
}

