/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.persistent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;

public class MailboxLifecycle {
    private ConcurrentMap<Entity, State> mailboxes = new ConcurrentHashMap<Entity, State>();

    public boolean startIfNotRunning(Entity mailbox2) {
        return this.mailboxes.putIfAbsent(mailbox2, State.FETCHING) == null;
    }

    public boolean cancel(Entity mailbox2) {
        return this.mailboxes.replace(mailbox2, State.FETCHING, State.CANCELING);
    }

    public void finish(Entity mailbox2) {
        this.mailboxes.remove(mailbox2);
    }

    public boolean isCanceling(Entity mailbox2) {
        return MailboxLifecycle.eq_k5jxqz_a0a0d(this.mailboxes.get(mailbox2), (Object)State.CANCELING);
    }

    public boolean isRunning(Entity mailbox2) {
        return this.mailboxes.containsKey(mailbox2);
    }

    public String getStatus(Entity mailbox2) {
        State state = (State)((Object)this.mailboxes.get(mailbox2));
        return state != null ? state.getPresentation() : null;
    }

    private static boolean eq_k5jxqz_a0a0d(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    public static enum State {
        FETCHING("mailbox.fetching"),
        CANCELING("mailbox.canceling");

        private String localizationId;

        private State(String localizationId) {
            this.localizationId = localizationId;
        }

        public String getPresentation() {
            return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(this.localizationId, new Object[0]);
        }
    }
}

