/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.sendMail;

import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.LocalScoped;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.youtrack.mailbox.sendMail.BeansKt;
import jetbrains.youtrack.mailbox.sendMail.EmailSender;
import jetbrains.youtrack.mailbox.sendMail.SendingEmailController;
import jetbrains.youtrack.mailbox.sendMail.SendingEmailController$trySendMail$admin$1;
import jetbrains.youtrack.persistent.XdUser;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0007H\u0007JN\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/mailbox/sendMail/SendingEmailController;", "", "()V", "hostedSmtpHost", "", "kotlin.jvm.PlatformType", "<set-?>", "", "mailCounter", "getMailCounter", "()I", "mailCounterRestartInterval", "Ljava/lang/Integer;", "mailLimit", "nextCounterRestart", "", "notificationsForAdminsAreSent", "", "resetNextCounterRestart", "", "setMailLimit", "trySendMail", "relatedIssue", "Ljetbrains/exodus/entitystore/Entity;", "fromPersonal", "fromEmail", "email", "cc", "replyTo", "subject", "body", "Companion", "youtrack-mailbox"})
public final class SendingEmailController {
    private Integer mailLimit = Integer.decode(System.getProperty("jetbrains.youtrack.mailLimit", "0"));
    private Integer mailCounterRestartInterval = Integer.decode(System.getProperty("jetbrains.youtrack.mailCounterRestartInterval", "86400000"));
    private long nextCounterRestart;
    private boolean notificationsForAdminsAreSent;
    private final String hostedSmtpHost;
    private int mailCounter;
    @NotNull
    public static final String ADMIN_MESSAGE_REASON = "Workflow failure: You've exceeded daily limit for sent emails";
    private static final String MAIL_LIMIT = "jetbrains.youtrack.mailLimit";
    private static final String MAIL_COUNTER_RESTART_INTERVAL = "jetbrains.youtrack.mailCounterRestartInterval";
    private static final int DEFAULT_RESTART_INTERVAL = 86400000;
    public static final Companion Companion = new Companion(null);

    public final int getMailCounter() {
        return this.mailCounter;
    }

    @Deprecated(message="FOR TESTS ONLY!!!")
    public final void setMailLimit(int mailLimit) {
        this.mailLimit = mailLimit;
        this.mailCounterRestartInterval = 86400000;
        long l = System.currentTimeMillis();
        Integer n = this.mailCounterRestartInterval;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"mailCounterRestartInterval");
        this.nextCounterRestart = l + (long)n.intValue();
        this.notificationsForAdminsAreSent = false;
    }

    public final void resetNextCounterRestart() {
        this.nextCounterRestart = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    public final void trySendMail(@Nullable Entity relatedIssue, @Nullable String fromPersonal, @NotNull String fromEmail, @NotNull String email, @Nullable String cc, @Nullable String replyTo, @NotNull String subject, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)fromEmail, (String)"fromEmail");
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Integer n = this.mailLimit;
        if (n != null && n == 0 || Intrinsics.areEqual((Object)jetbrains.charisma.persistent.BeansKt.getXdNotificationsConfig().getSmtpHost(), (Object)this.hostedSmtpHost) ^ true) {
            BeansKt.getEmailSender().sendMail(relatedIssue, fromPersonal, fromEmail, email, cc, replyTo, subject, body);
        } else {
            if (System.currentTimeMillis() > this.nextCounterRestart) {
                long l = System.currentTimeMillis();
                Integer n2 = this.mailCounterRestartInterval;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"mailCounterRestartInterval");
                this.nextCounterRestart = l + (long)n2.intValue();
                this.mailCounter = 0;
                this.notificationsForAdminsAreSent = false;
            }
            Integer n3 = this.mailLimit;
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"mailLimit");
            if (Intrinsics.compare((int)this.mailCounter, (int)n3) < 0) {
                int n4 = this.mailCounter;
                this.mailCounter = n4 + 1;
                BeansKt.getEmailSender().sendMail(relatedIssue, fromPersonal, fromEmail, email, cc, replyTo, subject, body);
            } else if (!this.notificationsForAdminsAreSent) {
                Companion.getLogger().warn(ADMIN_MESSAGE_REASON);
                Entity entity = jetbrains.charisma.service.BeansKt.getUserService().getRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"userService.root");
                XdUser root = (XdUser)XdExtensionsKt.toXd((Entity)entity);
                if (root.getEmail() != null) {
                    EmailSender emailSender = BeansKt.getEmailSender();
                    Integer n5 = this.mailLimit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n5, (String)"mailLimit");
                    emailSender.notifyAdmin(root, n5, this.nextCounterRestart);
                } else {
                    void value$iv;
                    void $receiver$iv;
                    KProperty1 kProperty1 = (KProperty1)SendingEmailController$trySendMail$admin$1.INSTANCE;
                    Object var12_12 = null;
                    XdEntityType xdEntityType = (XdEntityType)XdUser.Companion;
                    NodeBase nodeBase = NodeBaseOperationsKt.ne((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdUser.class)), (Comparable)value$iv);
                    XdUser admin2 = (XdUser)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase)), (Function1)trySendMail.admin.2.INSTANCE));
                    if (admin2 != null) {
                        EmailSender emailSender = BeansKt.getEmailSender();
                        Integer n6 = this.mailLimit;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"mailLimit");
                        emailSender.notifyAdmin(admin2, n6, this.nextCounterRestart);
                    } else {
                        Companion.getLogger().warn("Failed to notify admins on Workflow failure: You've exceeded daily limit for sent emails because their emails are empty");
                    }
                }
                this.notificationsForAdminsAreSent = true;
            }
        }
    }

    public SendingEmailController() {
        long l = System.currentTimeMillis();
        Integer n = this.mailCounterRestartInterval;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"mailCounterRestartInterval");
        this.nextCounterRestart = l + (long)n.intValue();
        this.hostedSmtpHost = ConfigurationParameter.getParameter((String)"smtpHost");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/youtrack/mailbox/sendMail/SendingEmailController$Companion;", "Lmu/KLogging;", "()V", "ADMIN_MESSAGE_REASON", "", "DEFAULT_RESTART_INTERVAL", "", "MAIL_COUNTER_RESTART_INTERVAL", "MAIL_LIMIT", "youtrack-mailbox"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

