/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.mailbox.service;

import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Store;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.scheduling.SchedulingOptions;
import jetbrains.youtrack.mailbox.fetch.EmailFetcher;
import jetbrains.youtrack.mailbox.fetch.LifecycleKt;
import jetbrains.youtrack.mailbox.fetch.MailboxConnectionKt;
import jetbrains.youtrack.mailbox.persistence.XdMailbox;
import jetbrains.youtrack.mailbox.persistence.XdMailboxRule;
import jetbrains.youtrack.mailbox.rest.BeansKt;
import jetbrains.youtrack.mailbox.service.MailboxFetchService;
import jetbrains.youtrack.mailbox.service.MailboxFetchService$process$1$$special$;
import jetbrains.youtrack.mailbox.service.MailboxFetchService$sam$i$jetbrains_mps_baseLanguage_closures_runtime__FunctionTypes__return_P0_E0$0;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Ljetbrains/youtrack/mailbox/service/MailboxFetchService;", "", "()V", "process", "", "mailbox", "Ljetbrains/youtrack/mailbox/persistence/XdMailbox;", "maxFetchCount", "", "processAsync", "youtrack-mailbox"})
public final class MailboxFetchService {
    public final void processAsync(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        jetbrains.charisma.persistent.BeansKt.getQuartzThreadExecutor().execute(new Runnable(this, mailbox2){
            final /* synthetic */ MailboxFetchService this$0;
            final /* synthetic */ XdMailbox $mailbox;

            public final void run() {
                this.this$0.process(this.$mailbox);
            }
            {
                this.this$0 = mailboxFetchService;
                this.$mailbox = xdMailbox;
            }
        });
    }

    public final void process(@NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        this.process(mailbox2.getMaxFetchedCount(), mailbox2);
    }

    public final void process(int maxFetchCount, @NotNull XdMailbox mailbox2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mailbox2), (String)"mailbox");
        LifecycleKt.fetchLock(mailbox2, (Function0<Unit>)((Function0)new Function0<Unit>(mailbox2, maxFetchCount){
            final /* synthetic */ XdMailbox $mailbox;
            final /* synthetic */ int $maxFetchCount;

            public final void invoke() {
                boolean $i$f$transactional = false;
                TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                    final /* synthetic */ process.1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    public final Unit invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        boolean bl = false;
                        List<XdMailboxRule> activeRules = this.this$0.$mailbox.getActiveRules();
                        Collection collection = activeRules;
                        if (!collection.isEmpty()) {
                            this.this$0.$mailbox.setLastFetchStart(System.currentTimeMillis());
                            this.this$0.$mailbox.updateStatus(new LocalizationObject("Mailbox.Start_mail_fetching", new Object[0]), null);
                            try {
                                Function0 isCanceling = (Function0)new Function0<Boolean>(this){
                                    final /* synthetic */ process$1$$special$$inlined$transactional$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    public final boolean invoke() {
                                        return BeansKt.getMailboxLifecycle().isCanceling(this.this$0.this$0.$mailbox.getEntity()) || SchedulingOptions.isCronJobTooLong((Long)this.this$0.this$0.$mailbox.getLastFetchStart());
                                    }
                                };
                                MailboxConnectionKt.openStore(this.this$0.$mailbox, (Function1<? super Store, Unit>)((Function1)new Function1<Store, Unit>(isCanceling, this){
                                    final /* synthetic */ Function0 $isCanceling;
                                    final /* synthetic */ process$1$$special$$inlined$transactional$1 this$0;
                                    {
                                        this.$isCanceling = function0;
                                        this.this$0 = var2_2;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Store store) {
                                        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
                                        Entity entity = this.this$0.this$0.$mailbox.getEntity();
                                        int n = this.this$0.this$0.$maxFetchCount;
                                        Object object = this.$isCanceling;
                                        if (object != null) {
                                            Function0 function0 = object;
                                            object = new MailboxFetchService$sam$i$jetbrains_mps_baseLanguage_closures_runtime__FunctionTypes__return_P0_E0$0(function0);
                                        }
                                        EmailFetcher folderFetcher = new EmailFetcher(entity, store, n, (_FunctionTypes._return_P0_E0<? extends Boolean>)((_FunctionTypes._return_P0_E0)object));
                                        for (XdMailboxRule mapping : this.this$0.this$0.$mailbox.getActiveRules()) {
                                            if (((Boolean)this.$isCanceling.invoke()).booleanValue()) continue;
                                            mapping.process(folderFetcher);
                                        }
                                    }
                                }));
                                this.this$0.$mailbox.updateStatus((Boolean)isCanceling.invoke() != false ? new LocalizationObject("Mailbox.Mail_fetching_canceled", new Object[0]) : new LocalizationObject("Mailbox.Finished_mail_fetching", new Object[0]), null);
                            }
                            catch (MessagingException e) {
                                this.this$0.$mailbox.updateStatus(new LocalizationObject("Mailbox.Failed_to_fetch", new Object[0]), (Exception)((Object)e));
                            }
                            this.this$0.$mailbox.setLastFetchFinish(System.currentTimeMillis());
                        }
                        return Unit.INSTANCE;
                    }
                }), (int)7, null);
            }
            {
                this.$mailbox = xdMailbox;
                this.$maxFetchCount = n;
                super(0);
            }
        }));
    }
}

