/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;

public abstract class Event {
    @NotNull
    private final Semaphore mySemaphore = new Semaphore(2);
    private volatile boolean myFinished = false;

    protected boolean doStart() {
        boolean started;
        boolean bl = started = !this.myFinished && this.mySemaphore.tryAcquire(2);
        if (started && this.myFinished && this.mySemaphore.availablePermits() == 0) {
            this.mySemaphore.release();
            return false;
        }
        return started;
    }

    protected void doFinish() {
        this.myFinished = true;
        this.mySemaphore.release();
    }

    protected boolean isFinished() {
        return this.myFinished;
    }

    public void waitFor() {
        this.mySemaphore.acquireUninterruptibly();
        this.mySemaphore.release();
    }

    public static class LastingEvent
    extends Event {
        public boolean start() {
            return this.doStart();
        }

        public void finish() {
            this.doFinish();
        }

        @Override
        public boolean isFinished() {
            return super.isFinished();
        }
    }

    public static class SimpleEvent
    extends Event {
        public SimpleEvent() {
            this.doStart();
        }

        public void fire() {
            this.doFinish();
        }
    }
}

