/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.util.ProcessUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaUtil {
    @NotNull
    public static final String EXPLICIT_JAVA_ENV = "FJ_JAVA_EXEC";
    @NotNull
    private static final Version VERSION_1_8 = new Version(1, 8);

    @NotNull
    public static String getCurrentJavaHomePath() {
        String string = System.getProperty("java.home");
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getCurrentJavaVersion() {
        String string = System.getProperty("java.version");
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getCurrentJavaRuntimeVersion() {
        String string = System.getProperty("java.runtime.version");
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isCurrentJavaAtLeast18() {
        return JavaUtil.isJavaAtLeast18(JavaUtil.getCurrentJavaVersion());
    }

    public static boolean isJavaAtLeast18(@NotNull String javaVersionStr) {
        Version javaVersion;
        if (javaVersionStr == null) {
            JavaUtil.$$$reportNull$$$0(3);
        }
        return (javaVersion = Version.parse(javaVersionStr)) != null && javaVersion.isAtLeast(VERSION_1_8);
    }

    @NotNull
    public static String getCurrentJavaExecutablePath() {
        String string = JavaUtil.getCurrentJavaExecutablePath(false);
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getCurrentJavaExecutablePath(boolean useJavaw) {
        String string = JavaUtil.getJavaExecutable(JavaUtil.getCurrentJavaHomePath(), useJavaw).getAbsolutePath();
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static File findJStackTool() {
        return JavaUtil.findJavaTool("jstack");
    }

    @Nullable
    public static File findJMapTool() {
        return JavaUtil.findJavaTool("jmap");
    }

    @Nullable
    public static File findJavaTool(@NotNull String toolName) {
        File javaHome;
        File tool;
        if (toolName == null) {
            JavaUtil.$$$reportNull$$$0(6);
        }
        if ((tool = JavaUtil.getJavaTool(javaHome = new File(JavaUtil.getCurrentJavaHomePath()), toolName)).isFile()) {
            return tool;
        }
        if (javaHome.getName().equals("jre") && (javaHome = javaHome.getParentFile()) != null && (tool = JavaUtil.getJavaTool(javaHome, toolName)).isFile()) {
            return tool;
        }
        return null;
    }

    @NotNull
    public static File getJavaExecutable(@NotNull String javaHome, boolean useJavaw) {
        if (javaHome == null) {
            JavaUtil.$$$reportNull$$$0(7);
        }
        File file = JavaUtil.getJavaExecutable(new File(javaHome), useJavaw);
        if (file == null) {
            JavaUtil.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public static File getJavaExecutable(@NotNull File javaHome, boolean useJavaw) {
        if (javaHome == null) {
            JavaUtil.$$$reportNull$$$0(9);
        }
        File file = JavaUtil.getJavaTool(javaHome, useJavaw && SystemInfo.isWindows ? "javaw" : "java");
        if (file == null) {
            JavaUtil.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    private static File getJavaTool(@NotNull File javaHome, @NotNull String toolName) {
        if (javaHome == null) {
            JavaUtil.$$$reportNull$$$0(11);
        }
        if (toolName == null) {
            JavaUtil.$$$reportNull$$$0(12);
        }
        File file = new File(new File(javaHome, "bin"), JavaUtil.getSystemDependentToolName(toolName));
        if (file == null) {
            JavaUtil.$$$reportNull$$$0(13);
        }
        return file;
    }

    public static boolean isJavaExecutable(@NotNull File file) {
        if (file == null) {
            JavaUtil.$$$reportNull$$$0(14);
        }
        if (!file.getName().equals(JavaUtil.getSystemDependentToolName("java")) || !file.isFile()) {
            return false;
        }
        try {
            return ProcessUtil.runSimpleCommand(file.getAbsolutePath(), "-version") == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static JavaVersion detectJavaVersion(@NotNull File javaHome) {
        ProcessUtil.ExecutionResult executionResult;
        File javaExec;
        if (javaHome == null) {
            JavaUtil.$$$reportNull$$$0(15);
        }
        if (!(javaExec = JavaUtil.getJavaExecutable(javaHome, false)).isFile()) {
            return null;
        }
        try {
            executionResult = ProcessUtil.runCommand(10, javaExec.getAbsolutePath(), "-version");
        }
        catch (Exception e) {
            return null;
        }
        JavaVersion version = JavaUtil.findAndParseJavaVersion(executionResult.getStderr());
        if (version == null) {
            version = JavaUtil.findAndParseJavaVersion(executionResult.getStdout());
        }
        return version;
    }

    @Nullable
    private static JavaVersion findAndParseJavaVersion(@NotNull List<String> lines) {
        if (lines == null) {
            JavaUtil.$$$reportNull$$$0(16);
        }
        String version = null;
        String runtimeVersion = null;
        for (String line : lines) {
            int endPos;
            int startPos;
            if (version == null && line.contains(" version ") && (startPos = line.indexOf(34)) != -1 && (endPos = line.indexOf(34, startPos + 1)) != -1) {
                version = line.substring(startPos + 1, endPos);
            }
            if (!line.contains(" Runtime Environment ") || (startPos = line.indexOf("(build")) == -1 || (endPos = line.indexOf(41, startPos + 1)) == -1) continue;
            runtimeVersion = line.substring(startPos + "(build".length(), endPos);
        }
        return version != null ? new JavaVersion(version, runtimeVersion) : null;
    }

    @NotNull
    private static String getSystemDependentToolName(@NotNull String toolName) {
        if (toolName == null) {
            JavaUtil.$$$reportNull$$$0(17);
        }
        String string = SystemInfo.isWindows ? toolName + ".exe" : toolName;
        if (string == null) {
            JavaUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String[] getJStackToolCommandLine(@NotNull File jstack, int pid) {
        if (jstack == null) {
            JavaUtil.$$$reportNull$$$0(19);
        }
        String[] stringArray = new String[]{jstack.getAbsolutePath(), "-l", String.valueOf(pid)};
        if (stringArray == null) {
            JavaUtil.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    @NotNull
    public static String[] getJMapToolCommandLine(@NotNull File jmap, @NotNull File dumpFile, int pid) {
        if (jmap == null) {
            JavaUtil.$$$reportNull$$$0(21);
        }
        if (dumpFile == null) {
            JavaUtil.$$$reportNull$$$0(22);
        }
        String[] stringArray = new String[]{jmap.getAbsolutePath(), "-dump:format=b,file=" + dumpFile.getAbsolutePath(), String.valueOf(pid)};
        if (stringArray == null) {
            JavaUtil.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/JavaUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaVersionStr";
                break;
            }
            case 6: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaHome";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jstack";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jmap";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentJavaHomePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentJavaVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentJavaRuntimeVersion";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/JavaUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentJavaExecutablePath";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExecutable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaTool";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDependentToolName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getJStackToolCommandLine";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getJMapToolCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isJavaAtLeast18";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findJavaTool";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJavaExecutable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTool";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isJavaExecutable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "detectJavaVersion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAndParseJavaVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSystemDependentToolName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getJStackToolCommandLine";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getJMapToolCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JavaVersion {
        @NotNull
        private final String myVersion;
        private final String myRuntimeVersion;

        public JavaVersion(@NotNull String version, String runtimeVersion) {
            if (version == null) {
                JavaVersion.$$$reportNull$$$0(0);
            }
            this.myVersion = version;
            this.myRuntimeVersion = runtimeVersion;
        }

        public Version getMajorMinorVersion() {
            return Version.parse(this.myVersion);
        }

        @NotNull
        public String getVersion() {
            String string = this.myVersion;
            if (string == null) {
                JavaVersion.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getRuntimeVersion() {
            return this.myRuntimeVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/JavaUtil$JavaVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/JavaUtil$JavaVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Version {
        private final int myMajor;
        private final int myMinor;

        public Version(int major, int minor) {
            this.myMajor = major;
            this.myMinor = minor;
        }

        public boolean isAtLeast(@NotNull Version that) {
            if (that == null) {
                Version.$$$reportNull$$$0(0);
            }
            return this.myMajor > that.myMajor || this.myMajor == that.myMajor && this.myMinor >= that.myMinor;
        }

        public int getMajor() {
            return this.myMajor;
        }

        public int getMinor() {
            return this.myMinor;
        }

        @Nullable
        public static Version parse(@NotNull String versionText) {
            if (versionText == null) {
                Version.$$$reportNull$$$0(1);
            }
            String[] versionParts = versionText.trim().split("[-_+]", 2)[0].split("\\.");
            try {
                if (versionParts.length == 1) {
                    return new Version(Integer.parseInt(versionParts[0]), 0);
                }
                return new Version(Integer.parseInt(versionParts[0]), Integer.parseInt(versionParts[1]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionText";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/launcher/util/JavaUtil$Version";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAtLeast";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

