/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.OptionsProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    @NotNull
    public static final String ISO_8859_1 = "ISO-8859-1";
    @Static
    @NotNull
    private static final Map<Character, Character> ourEscapeSymbols = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('\t'), Character.valueOf('t'));
            this.put(Character.valueOf('\f'), Character.valueOf('f'));
            this.put(Character.valueOf('\r'), Character.valueOf('r'));
            this.put(Character.valueOf('\n'), Character.valueOf('n'));
            this.put(Character.valueOf('\\'), Character.valueOf('\\'));
            this.put(Character.valueOf(':'), Character.valueOf(':'));
            this.put(Character.valueOf('='), Character.valueOf('='));
            this.put(Character.valueOf('#'), Character.valueOf('#'));
            this.put(Character.valueOf('!'), Character.valueOf('!'));
        }
    };
    @Static
    @NotNull
    private static final Map<Character, Character> ourUnescapeSymbols = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('t'), Character.valueOf('\t'));
            this.put(Character.valueOf('f'), Character.valueOf('\f'));
            this.put(Character.valueOf('r'), Character.valueOf('\r'));
            this.put(Character.valueOf('n'), Character.valueOf('\n'));
        }
    };

    public static void loadFromFile(@NotNull Properties properties, @NotNull File file) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(1);
        }
        PropertiesUtil.loadFromUrl(properties, file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromUrl(@NotNull Properties properties, @NotNull URL url) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(2);
        }
        if (url == null) {
            PropertiesUtil.$$$reportNull$$$0(3);
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(FileUtil.openStream(url));
            properties.load(is);
        }
        catch (Throwable throwable) {
            FileUtil.close(is);
            throw throwable;
        }
        FileUtil.close(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(@NotNull Properties properties, @NotNull File file) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(5);
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(file));
            properties.store(os, null);
        }
        catch (Throwable throwable) {
            FileUtil.close(os);
            throw throwable;
        }
        FileUtil.close(os);
    }

    @Nullable
    public static String getProperty(@NotNull Properties properties, @NotNull String propertyKey) {
        String propertyValue;
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(6);
        }
        if (propertyKey == null) {
            PropertiesUtil.$$$reportNull$$$0(7);
        }
        if ((propertyValue = properties.getProperty(propertyKey)) == null) {
            return null;
        }
        return (propertyValue = propertyValue.trim()).length() == 0 ? null : propertyValue;
    }

    @NotNull
    public static Map<String, String> toMap(final @NotNull Properties properties) {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(8);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                for (String propertyName : properties.stringPropertyNames()) {
                    this.put(propertyName, properties.getProperty(propertyName));
                }
            }
        };
        if (hashMap == null) {
            PropertiesUtil.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    public static void fixPropertyValues(@NotNull File file, @NotNull Map<String, String> newValues) throws IOException {
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(10);
        }
        if (newValues == null) {
            PropertiesUtil.$$$reportNull$$$0(11);
        }
        PropertiesUtil.doFixPropertyValues(file, newValues, false);
    }

    public static void fixCommentedPropertyValues(@NotNull File file, @NotNull Map<String, String> newValues) throws IOException {
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(12);
        }
        if (newValues == null) {
            PropertiesUtil.$$$reportNull$$$0(13);
        }
        PropertiesUtil.doFixPropertyValues(file, newValues, true);
    }

    private static void doFixPropertyValues(@NotNull File file, @NotNull Map<String, String> newValues, boolean fixCommentedValuesOnly) throws IOException {
        if (file == null) {
            PropertiesUtil.$$$reportNull$$$0(14);
        }
        if (newValues == null) {
            PropertiesUtil.$$$reportNull$$$0(15);
        }
        List<String> lines = FileUtil.readLines(file, ISO_8859_1);
        lines = PropertiesUtil.doFixPropertyValues(lines, newValues, fixCommentedValuesOnly);
        FileUtil.writeLines(file, lines, ISO_8859_1);
    }

    @NotNull
    public static List<String> doFixPropertyValues(@NotNull List<String> lines, @NotNull Map<String, String> newValues, boolean fixCommentedValuesOnly) {
        if (lines == null) {
            PropertiesUtil.$$$reportNull$$$0(16);
        }
        if (newValues == null) {
            PropertiesUtil.$$$reportNull$$$0(17);
        }
        List<String> list = new PropertiesProcessor(newValues, fixCommentedValuesOnly).processOptionLines(lines);
        if (list == null) {
            PropertiesUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String escapeKey(@Nullable String key) {
        return PropertiesUtil.doEscape(key, true);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String escapeValue(@Nullable String value) {
        return PropertiesUtil.doEscape(value, false);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    private static String doEscape(@Nullable String str, boolean escapeAllSpaces) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str.length());
        boolean leadingSpace = true;
        for (int i = 0; i < str.length(); ++i) {
            Character escapeSymbol;
            char symbol = str.charAt(i);
            if (symbol == ' ') {
                if (escapeAllSpaces || leadingSpace) {
                    sb.append("\\");
                }
            } else {
                leadingSpace = false;
            }
            if ((escapeSymbol = ourEscapeSymbols.get(Character.valueOf(symbol))) != null) {
                sb.append("\\").append(escapeSymbol);
                continue;
            }
            if (symbol < ' ' || symbol > '~') {
                PropertiesUtil.appendUnicodeSymbol(sb, symbol);
                continue;
            }
            sb.append(symbol);
        }
        return sb.toString();
    }

    private static void appendUnicodeSymbol(@NotNull StringBuilder sb, char symbol) {
        if (sb == null) {
            PropertiesUtil.$$$reportNull$$$0(19);
        }
        sb.append("\\u");
        String hex = Integer.toHexString(symbol);
        int leadingZerosNeeded = 4 - hex.length();
        for (int i = 0; i < leadingZerosNeeded; ++i) {
            sb.append('0');
        }
        sb.append(hex);
    }

    @NotNull
    public static String unescape(@NotNull String str) {
        if (str == null) {
            PropertiesUtil.$$$reportNull$$$0(20);
        }
        char[] chars = new char[str.length() + 1];
        str.getChars(0, str.length(), chars, 0);
        chars[str.length()] = 10;
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char symbol = chars[i];
            if (symbol == '\\') {
                Character unescapeSymbol;
                if ((unescapeSymbol = ourUnescapeSymbols.get(Character.valueOf(symbol = chars[++i]))) != null) {
                    symbol = unescapeSymbol.charValue();
                } else if (symbol == 'u') {
                    symbol = PropertiesUtil.unescapeUnicodeSymbol(chars, i + 1);
                    i += 4;
                }
            }
            sb.append(symbol);
        }
        String string = sb.toString();
        if (string == null) {
            PropertiesUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static char unescapeUnicodeSymbol(char[] chars, int i) {
        String s = new String(chars, i, 4);
        return (char)Integer.parseInt(s, 16);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/PropertiesUtil";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValues";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/PropertiesUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doFixPropertyValues";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toMap";
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fixPropertyValues";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fixCommentedPropertyValues";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doFixPropertyValues";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendUnicodeSymbol";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ParsedPropertyLine
    implements OptionsProcessor.ParsedLine<ParsedPropertyLine, String> {
        @NotNull
        private final String myRawLine;
        @Nullable
        private final String myKey;
        private final boolean myIsCommented;

        private ParsedPropertyLine(@NotNull String rawLine, @Nullable String key, boolean isCommented) {
            if (rawLine == null) {
                ParsedPropertyLine.$$$reportNull$$$0(0);
            }
            this.myRawLine = rawLine;
            this.myKey = key;
            this.myIsCommented = isCommented;
        }

        @Override
        public boolean isCommented() {
            return this.myIsCommented;
        }

        @Override
        public boolean isRemovingLine() {
            return false;
        }

        @Override
        @Nullable
        public String getKey() {
            return this.myKey;
        }

        @Override
        @NotNull
        public String getRawLine() {
            String string = this.myRawLine;
            if (string == null) {
                ParsedPropertyLine.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public ParsedPropertyLine commentOut() {
            ParsedPropertyLine parsedPropertyLine = this.myIsCommented ? this : new ParsedPropertyLine("#" + this.myRawLine, this.myKey, true);
            if (parsedPropertyLine == null) {
                ParsedPropertyLine.$$$reportNull$$$0(2);
            }
            return parsedPropertyLine;
        }

        @Override
        public boolean hasSameValue(@NotNull String value) {
            if (value == null) {
                ParsedPropertyLine.$$$reportNull$$$0(3);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawLine";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/PropertiesUtil$ParsedPropertyLine";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/PropertiesUtil$ParsedPropertyLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawLine";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "commentOut";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "hasSameValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PropertiesProcessor
    extends OptionsProcessor<String, ParsedPropertyLine, RuntimeException> {
        public PropertiesProcessor(@NotNull Map<String, String> newOptions, boolean fixCommentedOptionsOnly) {
            if (newOptions == null) {
                PropertiesProcessor.$$$reportNull$$$0(0);
            }
            super(newOptions, fixCommentedOptionsOnly);
        }

        @Override
        @NotNull
        protected String getCommentPrefix() {
            if ("#" == null) {
                PropertiesProcessor.$$$reportNull$$$0(1);
            }
            return "#";
        }

        @Override
        @NotNull
        protected ParsedPropertyLine doParseLine(@NotNull String line, @NotNull String actualLine, boolean isCommented) {
            if (line == null) {
                PropertiesProcessor.$$$reportNull$$$0(2);
            }
            if (actualLine == null) {
                PropertiesProcessor.$$$reportNull$$$0(3);
            }
            int eqPos = -1;
            while ((eqPos = actualLine.indexOf(61, eqPos + 1)) > 0 && actualLine.charAt(eqPos - 1) == '\\') {
            }
            String key = eqPos == -1 ? null : PropertiesUtil.unescape(actualLine.substring(0, eqPos).trim());
            ParsedPropertyLine parsedPropertyLine = new ParsedPropertyLine(line, key, isCommented);
            if (parsedPropertyLine == null) {
                PropertiesProcessor.$$$reportNull$$$0(4);
            }
            return parsedPropertyLine;
        }

        @Override
        protected boolean isOptionToRemove(@Nullable String option) {
            return option == null;
        }

        @Override
        @NotNull
        protected ParsedPropertyLine createLine(@NotNull String key, @NotNull String option) {
            if (key == null) {
                PropertiesProcessor.$$$reportNull$$$0(5);
            }
            if (option == null) {
                PropertiesProcessor.$$$reportNull$$$0(6);
            }
            ParsedPropertyLine parsedPropertyLine = new ParsedPropertyLine(PropertiesUtil.escapeKey(key) + "=" + PropertiesUtil.escapeValue(option), key, false);
            if (parsedPropertyLine == null) {
                PropertiesProcessor.$$$reportNull$$$0(7);
            }
            return parsedPropertyLine;
        }

        @Override
        protected boolean addRemovingLines() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newOptions";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/launcher/util/PropertiesUtil$PropertiesProcessor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actualLine";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/launcher/util/PropertiesUtil$PropertiesProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doParseLine";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doParseLine";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

