/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util.process;

import com.jetbrains.launcher.util.process.ProcessOutputListener;
import com.jetbrains.launcher.util.process.ProcessOutputPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessOutputLineListener
implements ProcessOutputListener {
    @NotNull
    private final LineBuilder myOutputLine;
    @NotNull
    private final LineBuilder myErrorLine;

    public ProcessOutputLineListener() {
        this(null);
    }

    public ProcessOutputLineListener(@Nullable Integer thresholdLineLength) {
        this.myOutputLine = new LineBuilder(thresholdLineLength);
        this.myErrorLine = new LineBuilder(thresholdLineLength);
    }

    @Override
    public final void output(@NotNull ProcessOutputPart outputPart) {
        ProcessOutputPart line;
        if (outputPart == null) {
            ProcessOutputLineListener.$$$reportNull$$$0(0);
        }
        if ((line = this.myOutputLine.append(outputPart)) != null) {
            this.outputLine(line);
        }
    }

    protected abstract void outputLine(@NotNull ProcessOutputPart var1);

    @Override
    public final void error(@NotNull ProcessOutputPart outputPart) {
        ProcessOutputPart line;
        if (outputPart == null) {
            ProcessOutputLineListener.$$$reportNull$$$0(1);
        }
        if ((line = this.myErrorLine.append(outputPart)) != null) {
            this.errorLine(line);
        }
    }

    protected abstract void errorLine(@NotNull ProcessOutputPart var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "outputPart";
        objectArray2[1] = "com/jetbrains/launcher/util/process/ProcessOutputLineListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "output";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LineBuilder {
        private static final int DEFAULT_CAPACITY = 80;
        @Nullable
        private final Integer myThresholdLineLength;
        @NotNull
        private final StringBuilder myTextBuilder = new StringBuilder(80);
        private boolean myLineStart = true;

        private LineBuilder(@Nullable Integer thresholdLineLength) {
            this.myThresholdLineLength = thresholdLineLength;
        }

        @Nullable
        private ProcessOutputPart append(@NotNull ProcessOutputPart outputPart) {
            if (outputPart == null) {
                LineBuilder.$$$reportNull$$$0(0);
            }
            ProcessOutputPart line = null;
            this.myTextBuilder.append(outputPart.getText());
            boolean lineEnd = outputPart.isLineEnd();
            if (lineEnd || this.myThresholdLineLength != null && this.myTextBuilder.length() > this.myThresholdLineLength) {
                line = new ProcessOutputPart(this.myTextBuilder.toString(), this.myLineStart, lineEnd);
                this.resetTextBuilder();
                this.myLineStart = lineEnd;
            }
            return line;
        }

        private void resetTextBuilder() {
            if (this.myTextBuilder.length() > 80) {
                this.myTextBuilder.setLength(80);
                this.myTextBuilder.trimToSize();
            }
            this.myTextBuilder.setLength(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputPart", "com/jetbrains/launcher/util/process/ProcessOutputLineListener$LineBuilder", "append"));
        }
    }
}

