/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.springframework.configuration.runtime;

import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;

public class ExtensionPoint
implements BeanFactoryPostProcessor {
    private String myBeanName;
    private String myExtensionPropertyName;
    private Class<?> myExtensionType;

    public void setBeanName(String beanName) {
        this.myBeanName = beanName;
    }

    public void setExtensionPropertyName(String extensionPropertyName) {
        this.myExtensionPropertyName = extensionPropertyName;
    }

    public void setExtensionType(Class<?> extensionType) {
        this.myExtensionType = extensionType;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinition definition = beanFactory.getBeanDefinition(this.myBeanName);
        String[] extensionBeansNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, this.myExtensionType);
        ManagedList list = new ManagedList(extensionBeansNames.length);
        for (String extensionBeanName : extensionBeansNames) {
            RuntimeBeanReference reference = new RuntimeBeanReference(extensionBeanName);
            list.add((Object)reference);
        }
        PropertyValue value = new PropertyValue(this.myExtensionPropertyName, (Object)list);
        definition.getPropertyValues().addPropertyValue(value);
    }
}

