/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.OAuthClientValidationException;
import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.request.AuthRequestParameter;
import com.intellij.hub.core.Error;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.core.store.OneTimeStore;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.dnq.LogMarkers;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.oauth2.server.AccessTokenIssuer;
import jetbrains.jetpass.oauth2.server.ApproveAction;
import jetbrains.jetpass.oauth2.server.AuthCookieUtilKt;
import jetbrains.jetpass.oauth2.server.AuthError;
import jetbrains.jetpass.oauth2.server.AuthErrorKt;
import jetbrains.jetpass.oauth2.server.AuthHandler$WhenMappings;
import jetbrains.jetpass.oauth2.server.AuthParameters;
import jetbrains.jetpass.oauth2.server.AuthorizationCode;
import jetbrains.jetpass.oauth2.server.OAuth2RequestHandler;
import jetbrains.jetpass.oauth2.server.OAuthParametersKt;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.oauth2.server.OpenIDConnectUtilKt;
import jetbrains.jetpass.oauth2.server.RequestType;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt;
import jetbrains.jetpass.oauth2.server.UriBuilderUtilKt;
import jetbrains.jetpass.oauth2.server.UserSession;
import jetbrains.jetpass.rest.common.certificates.CertificateUtilsKt;
import jetbrains.jetpass.rest.common.certificates.ClientCertificateUnsuitableRequestException;
import jetbrains.jetpass.service.api.FrontendURLProvider;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEmailContact;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGuestUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProfile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPublicSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdApprovedScope;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 W2\u00020\u0001:\u0001WB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010*\u001a\u00020+H\u0002J6\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010/2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020/022\u0006\u00103\u001a\u00020\u000fH\u0002J\u001e\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/072\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u00020/H\u0002J(\u0010=\u001a\u00020;2\u0006\u00108\u001a\u0002092\n\b\u0002\u0010>\u001a\u0004\u0018\u00010/2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010/H\u0002J*\u0010@\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020/022\f\u0010A\u001a\b\u0012\u0004\u0012\u00020/072\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u00108\u001a\u0002092\u0006\u0010F\u001a\u00020\u000fH\u0002J\u0018\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010K\u001a\u00020H2\u0006\u00108\u001a\u000209H\u0014J\u001a\u0010L\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020C2\b\u0010M\u001a\u0004\u0018\u00010/H\u0002J\u0010\u0010N\u001a\u00020H2\u0006\u00108\u001a\u000209H\u0002J0\u0010O\u001a\u0004\u0018\u00010E2\u0006\u00108\u001a\u0002092\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020/07H\u0002J\u0012\u0010U\u001a\u0004\u0018\u00010E2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010V\u001a\u00020+2\u0006\u00108\u001a\u000209H\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\t\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\t\u001a\u0004\b \u0010!R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\t\u001a\u0004\b'\u0010(\u00a8\u0006X"}, d2={"Ljetbrains/jetpass/oauth2/server/AuthHandler;", "Ljetbrains/jetpass/oauth2/server/OAuth2RequestHandler;", "()V", "approvalStore", "Ljetbrains/jetpass/core/store/OneTimeStore;", "Ljetbrains/jetpass/oauth2/server/ApproveAction;", "getApprovalStore", "()Ljetbrains/jetpass/core/store/OneTimeStore;", "approvalStore$delegate", "Lkotlin/properties/ReadOnlyProperty;", "authorizationCodeStore", "Ljetbrains/jetpass/oauth2/server/AuthorizationCode;", "getAuthorizationCodeStore", "authorizationCodeStore$delegate", "autoApproveVerifiedServices", "", "getAutoApproveVerifiedServices", "()Z", "setAutoApproveVerifiedServices", "(Z)V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "hubPrincipalManager$delegate", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "tokenIssuer", "Ljetbrains/jetpass/oauth2/server/AccessTokenIssuer;", "urlProvider", "Ljetbrains/jetpass/service/api/FrontendURLProvider;", "getUrlProvider", "()Ljetbrains/jetpass/service/api/FrontendURLProvider;", "urlProvider$delegate", "assertBasicAuthIsEnabled", "", "authResponse", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "redirectUri", "", "state", "parameters", "", "isURLFragmentResponse", "getAccessType", "Lcom/intellij/hub/auth/request/AuthRequestParameter$AccessType;", "responseType", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "getApprovalUrl", "Ljava/net/URI;", "csrf", "getLoginUrl", "message", "messagesToken", "getResponseParameters", "responseTypes", "authParameters", "Ljetbrains/jetpass/oauth2/server/AuthParameters;", "getUserSession", "Ljetbrains/jetpass/oauth2/server/UserSession;", "isGuestAllowed", "handleOAuthError", "Ljavax/ws/rs/core/Response;", "error", "Lcom/intellij/hub/core/Error;", "handleOAuthRequest", "isAutoApproved", "approvalPrompt", "requireEmailVerificationResponse", "resolveSession", "client", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "mode", "Lcom/intellij/hub/auth/request/AuthRequestParameter$RequestCredentials;", "prompt", "sessionByClientCertificate", "writeLogoutAudit", "Companion", "jetbrains.jetpass.oauth2"})
public final class AuthHandler
extends OAuth2RequestHandler {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty approvalStore$delegate;
    private final ReadOnlyProperty urlProvider$delegate;
    private final ReadOnlyProperty daoContainer$delegate;
    private final ReadOnlyProperty jetPass$delegate;
    private final ReadOnlyProperty hubPrincipalManager$delegate;
    private boolean autoApproveVerifiedServices;
    private final AccessTokenIssuer tokenIssuer;
    private final ReadOnlyProperty authorizationCodeStore$delegate;
    @NotNull
    public static final String FRAGMENT_DELIMITER = "#";
    @NotNull
    public static final String QUERY_DELIMITER = "?";
    public static final char PARAMETER_VALUE_DELIMITER = '=';
    @NotNull
    public static final String PARAMETER_DELIMITER = "&";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthHandler.class), "approvalStore", "getApprovalStore()Ljetbrains/jetpass/core/store/OneTimeStore;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthHandler.class), "urlProvider", "getUrlProvider()Ljetbrains/jetpass/service/api/FrontendURLProvider;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthHandler.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthHandler.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthHandler.class), "hubPrincipalManager", "getHubPrincipalManager()Ljetbrains/jetpass/service/api/HubPrincipalManager;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthHandler.class), "authorizationCodeStore", "getAuthorizationCodeStore()Ljetbrains/jetpass/core/store/OneTimeStore;"))};
        Companion = new Companion(null);
    }

    private final OneTimeStore<ApproveAction> getApprovalStore() {
        return (OneTimeStore)this.approvalStore$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final FrontendURLProvider getUrlProvider() {
        return (FrontendURLProvider)this.urlProvider$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final JetPassMainApp getJetPass() {
        return (JetPassMainApp)this.jetPass$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final HubPrincipalManager getHubPrincipalManager() {
        return (HubPrincipalManager)this.hubPrincipalManager$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public final boolean getAutoApproveVerifiedServices() {
        return this.autoApproveVerifiedServices;
    }

    public final void setAutoApproveVerifiedServices(boolean bl) {
        this.autoApproveVerifiedServices = bl;
    }

    @Override
    @NotNull
    protected Response handleOAuthRequest(@NotNull HttpServletRequest request) throws OAuthValidationException {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        XdService client = RequestValidatorKt.authenticateClientFromQuery(request);
        String redirectUri = request.getParameter("redirect_uri");
        String string2 = redirectUri;
        if (string2 == null) {
            string2 = string = (String)CollectionsKt.firstOrNull((Iterable)client.getRedirectURIs());
        }
        if (string2 == null) {
            string = "";
        }
        String redirectResponseTo = string;
        Set<String> responseTypes = RequestValidatorKt.getResponseTypeParameter(request);
        String state = request.getParameter("state");
        AuthRequestParameter.RequestCredentials credentialsMode2 = OAuthParametersKt.getCredentialsMode(request);
        AuthRequestParameter.AuthMode authMode2 = OAuthParametersKt.getAuthMode(request);
        boolean isURLFragmentResponse = responseTypes.contains("token") || responseTypes.contains("id_token");
        try {
            Response response;
            String approvalPrompt;
            boolean bl;
            List<String> scopes;
            AuthRequestParameter.AccessType accessType2;
            XdBaseUser user2;
            UserSession session2;
            block27: {
                UserSession userSession;
                if (request.getParameter("request") != null) {
                    throw (Throwable)OAuthClientValidationException.Companion.requestNotSupported();
                }
                if (request.getParameter("request_uri") != null) {
                    throw (Throwable)OAuthClientValidationException.Companion.requestURINotSupported();
                }
                if (authMode2 == AuthRequestParameter.AuthMode.BYPASS_TO_LOGIN) {
                    Response response2 = Response.seeOther((URI)AuthHandler.getLoginUrl$default(this, request, null, null, 6, null)).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.seeOther(getLoginUrl(request)).build()");
                    return response2;
                }
                if (credentialsMode2 == AuthRequestParameter.RequestCredentials.SILENT_LOGOUT) {
                    this.writeLogoutAudit(request);
                    Response response3 = AuthCookieUtilKt.removeAuthCookie(this.authResponse(redirectResponseTo, state, MapsKt.emptyMap(), isURLFragmentResponse)).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"authResponse(redirectRes\u2026emoveAuthCookie().build()");
                    return response3;
                }
                Set<String> prompt = RequestValidatorKt.getPromptParameter(request);
                try {
                    userSession = this.resolveSession(request, client, credentialsMode2, prompt);
                }
                catch (AuthenticationException ex) {
                    AuthError authError = AuthErrorKt.toAuthError((DataAccessException)((Object)ex));
                    return AuthErrorKt.redirectToUri(authError, this.getUrlProvider().getLoginUrl(), OAuthUtilKt.getAuthParameters(request), (Function1<? super Response.ResponseBuilder, ? extends Response.ResponseBuilder>)((Function1)new Function1<Response.ResponseBuilder, Response.ResponseBuilder>(this, request){
                        final /* synthetic */ AuthHandler this$0;
                        final /* synthetic */ HttpServletRequest $request;

                        @NotNull
                        public final Response.ResponseBuilder invoke(@NotNull Response.ResponseBuilder $receiver) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            AuthHandler.access$writeLogoutAudit(this.this$0, this.$request);
                            return AuthCookieUtilKt.removeAuthCookie($receiver);
                        }
                        {
                            this.this$0 = authHandler;
                            this.$request = httpServletRequest;
                            super(1);
                        }
                    }));
                }
                session2 = userSession;
                if (session2 == null) {
                    if (prompt.contains("none")) {
                        throw (Throwable)OAuthClientValidationException.Companion.loginRequired();
                    }
                    URI loginUri = this.getLoginUrl(request, request.getParameter("message"), request.getParameter("messages_token"));
                    Response.ResponseBuilder it = ex = Response.seeOther((URI)loginUri);
                    if (credentialsMode2 == AuthRequestParameter.RequestCredentials.REQUIRED) {
                        this.writeLogoutAudit(request);
                        Response.ResponseBuilder responseBuilder = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"it");
                        AuthCookieUtilKt.removeAuthCookie(responseBuilder);
                    }
                    Response response4 = ex.build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response4, (String)"Response.seeOther(loginU\u2026                }.build()");
                    return response4;
                }
                user2 = session2.getUser();
                accessType2 = this.getAccessType(responseTypes, request);
                if (accessType2 == AuthRequestParameter.AccessType.OFFLINE && Intrinsics.areEqual((Object)user2, (Object)XdRoots.INSTANCE.getGuest())) {
                    throw (Throwable)OAuthClientValidationException.Companion.cantGiveGuestOfflineAccess();
                }
                if (user2.getBanned()) {
                    OAuthValidationException accessDenied = OAuthClientValidationException.Companion.userBanned();
                    Response response5 = this.authResponse(redirectResponseTo, state, OAuthUtilKt.toParameterMap(accessDenied.getError()), isURLFragmentResponse).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response5, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
                    return response5;
                }
                if (!client.isLicensedFor(user2)) {
                    OAuthValidationException noLicense = OAuthClientValidationException.Companion.userHasNoLicense(client.getName());
                    Response response6 = this.authResponse(redirectResponseTo, state, OAuthUtilKt.toParameterMap(noLicense.getError()), isURLFragmentResponse).build();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response6, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
                    return response6;
                }
                scopes = RequestValidatorKt.getScopeParameter(request, RequestType.AUTH, true);
                Iterable $receiver$iv = scopes;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!Intrinsics.areEqual((Object)it, (Object)"openid")) continue;
                        bl = true;
                        break block27;
                    }
                    bl = false;
                }
            }
            boolean isOpenIdScope = bl;
            Set<XdService> scopeServices2 = RequestValidatorKt.getScopeServices(RequestType.AUTH, scopes, user2, isOpenIdScope);
            String nonce = responseTypes.contains("id_token") ? RequestValidatorKt.getRequiredParameter(request, "nonce", RequestType.AUTH) : request.getParameter("nonce");
            AuthParameters authParameters = new AuthParameters(client, (Iterable<? extends XdService>)scopeServices2, isOpenIdScope, session2, accessType2, redirectUri, nonce);
            XdPublicSettings.Companion this_$iv = XdPublicSettings.Companion;
            if (((XdPublicSettings)XdPublicSettings.Companion.getInstance()).getEmailVerificationRequired() && !user2.isAdmin()) {
                XdEmailContact email$iv;
                XdProfile xdProfile = user2.getProfile();
                Object object = email$iv = xdProfile != null ? xdProfile.getEmail() : null;
                if (email$iv != null && !email$iv.getVerified()) {
                    Response response7;
                    String it = email$iv.getEmail();
                    if (credentialsMode2 == AuthRequestParameter.RequestCredentials.SILENT) {
                        OAuthValidationException ex = OAuthClientValidationException.Companion.userEmailIsNotVerified();
                        Response response8 = this.authResponse(redirectResponseTo, state, OAuthUtilKt.toParameterMap(ex.getError()), isURLFragmentResponse).build();
                        response7 = response8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)response8, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
                    } else {
                        response7 = this.requireEmailVerificationResponse(request);
                    }
                    return response7;
                }
            }
            if (this.isAutoApproved(authParameters, approvalPrompt = request.getParameter("approval_prompt"))) {
                Response response9 = this.authResponse(redirectResponseTo, state, this.getResponseParameters(responseTypes, authParameters), isURLFragmentResponse).build();
                response = response9;
                Intrinsics.checkExpressionValueIsNotNull((Object)response9, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
            } else {
                Response response10;
                if (credentialsMode2 == AuthRequestParameter.RequestCredentials.SILENT) {
                    OAuthValidationException accessDenied = OAuthClientValidationException.Companion.userDistrusts();
                    response10 = this.authResponse(redirectResponseTo, state, OAuthUtilKt.toParameterMap(accessDenied.getError()), isURLFragmentResponse).build();
                } else {
                    ApproveAction action2 = new ApproveAction(this, client, user2, scopeServices2, redirectResponseTo, state, responseTypes, authParameters, isURLFragmentResponse, client, scopeServices2){
                        final /* synthetic */ AuthHandler this$0;
                        final /* synthetic */ XdService $client;
                        final /* synthetic */ XdBaseUser $user;
                        final /* synthetic */ Set $scopeServices;
                        final /* synthetic */ String $redirectResponseTo;
                        final /* synthetic */ String $state;
                        final /* synthetic */ Set $responseTypes;
                        final /* synthetic */ AuthParameters $authParameters;
                        final /* synthetic */ boolean $isURLFragmentResponse;

                        @NotNull
                        public Response execute(boolean approved) {
                            Response response;
                            if (approved) {
                                XdBaseUser xdBaseUser = this.$user;
                                if (xdBaseUser == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.userManagement.persistence.dnq.XdUser");
                                }
                                XdApprovedScope.Companion.createOrUpdate(this.$client, (XdUser)xdBaseUser, CollectionsKt.asSequence((Iterable)this.$scopeServices));
                                Response response2 = AuthHandler.access$authResponse(this.this$0, this.$redirectResponseTo, this.$state, AuthHandler.access$getResponseParameters(this.this$0, this.$responseTypes, this.$authParameters), this.$isURLFragmentResponse).build();
                                response = response2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
                            } else {
                                OAuthValidationException accessDenied = OAuthClientValidationException.Companion.authRequestDeclined();
                                Response response3 = AuthHandler.access$authResponse(this.this$0, this.$redirectResponseTo, this.$state, OAuthUtilKt.toParameterMap(accessDenied.getError()), this.$isURLFragmentResponse).build();
                                response = response3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
                            }
                            return response;
                        }
                        {
                            this.this$0 = $outer;
                            this.$client = $captured_local_variable$1;
                            this.$user = $captured_local_variable$2;
                            this.$scopeServices = $captured_local_variable$3;
                            this.$redirectResponseTo = $captured_local_variable$4;
                            this.$state = $captured_local_variable$5;
                            this.$responseTypes = $captured_local_variable$6;
                            this.$authParameters = $captured_local_variable$7;
                            this.$isURLFragmentResponse = $captured_local_variable$8;
                            super($super_call_param$9, $super_call_param$10);
                        }
                    };
                    String csrf = this.getApprovalStore().put((Object)action2);
                    response10 = Response.seeOther((URI)this.getApprovalUrl(request, csrf)).build();
                }
                response = response10;
                Intrinsics.checkExpressionValueIsNotNull((Object)response10, (String)"if (credentialsMode == A\u2026f)).build()\n            }");
            }
            return response;
        }
        catch (OAuthClientValidationException ex) {
            Response response = this.authResponse(redirectResponseTo, state, OAuthUtilKt.toParameterMap(ex.getError()), isURLFragmentResponse).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"authResponse(redirectRes\u2026FragmentResponse).build()");
            return response;
        }
    }

    private final UserSession resolveSession(HttpServletRequest request, XdService client, AuthRequestParameter.RequestCredentials mode, Set<String> prompt) {
        UserSession userSession;
        UserSession userSession2;
        if (prompt.contains("consent")) {
            return null;
        }
        String authHeader = request.getHeader("Authorization");
        if (BasicAuthToken.Companion.isBasic(authHeader)) {
            this.assertBasicAuthIsEnabled();
            String string = authHeader;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authHeader");
            BasicAuthToken basicAuthToken = BasicAuthToken.Companion.decodeHeader(string);
            TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
            if (transientStoreSession != null) {
                transientStoreSession.flush();
            }
            User user2 = this.getDaoContainer().getAuthModuleDAO().loginUser(basicAuthToken.getUsername(), basicAuthToken.getPassword(), request.getParameter("client_id"), request.getHeader(ServletRequestCredentials.Companion.getUSER_AGENT_HEADER()), request.getRemoteAddr(), false);
            XdBaseUser xdBaseUser = (XdBaseUser)XdBaseUser.Companion.resolve(user2.getId());
            if (xdBaseUser != null) {
                XdBaseUser xdBaseUser2;
                XdBaseUser it = xdBaseUser2 = xdBaseUser;
                userSession2 = new UserSession(it, null, null, 6, null);
            } else {
                userSession2 = null;
            }
        } else {
            if (prompt.contains("login")) {
                return null;
            }
            switch (AuthHandler$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return this.getUserSession(request, true);
                }
                case 4: {
                    userSession2 = this.getUserSession(request, true);
                    break;
                }
                case 5: {
                    userSession2 = this.getUserSession(request, false);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown mode: " + mode.name());
                }
            }
        }
        UserSession session2 = userSession2;
        if (session2 == null || session2.getUser().getBanned() || !client.isLicensedFor(session2.getUser())) {
            userSession = null;
        } else {
            String string = request.getParameter("max_age");
            if (string != null) {
                long l;
                String string2 = string;
                long maxAge = l = Long.parseLong(string2) * (long)1000;
                long age = new Date().getTime() - session2.getAuthenticationTime().getTime();
                if (age > maxAge) {
                    return null;
                }
            }
            userSession = session2;
        }
        return userSession;
    }

    private final UserSession getUserSession(HttpServletRequest request, boolean isGuestAllowed) {
        UserSession userSession;
        UserSession userSession2 = OAuthUtilKt.getUserSession(request, isGuestAllowed);
        if (userSession2 == null) {
            userSession2 = userSession = this.sessionByClientCertificate(request);
        }
        if (userSession2 == null) {
            if (isGuestAllowed) {
                XdGuestUser xdGuestUser = XdRoots.INSTANCE.getGuest();
                if (xdGuestUser != null) {
                    XdGuestUser xdGuestUser2;
                    XdGuestUser it = xdGuestUser2 = xdGuestUser;
                    userSession = new UserSession((XdBaseUser)it, null, null, 6, null);
                } else {
                    userSession = null;
                }
            } else {
                userSession = null;
            }
        }
        return userSession;
    }

    private final UserSession sessionByClientCertificate(HttpServletRequest request) {
        Object object;
        if (!this.getDaoContainer().getJetPassFeatureDAO().isEnabledSafe("jetbrains.hub.auth.client.certificate.feature")) {
            return null;
        }
        try {
            UserDetails details = object = CertificateUtilsKt.loginWithCertificate((JetPassDAOContainer)this.getDaoContainer(), (HttpServletRequest)request);
            object = (UserSession)this.getHubPrincipalManager().runAsRoot((Function0)new Function0<UserSession>(details){
                final /* synthetic */ UserDetails $details;

                @Nullable
                public final UserSession invoke() {
                    UserSession userSession;
                    TransientStoreSession transientStoreSession = DnqUtils.getCurrentTransientSession();
                    if (transientStoreSession != null) {
                        transientStoreSession.flush();
                    }
                    User user2 = this.$details.getUser();
                    Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"details.user");
                    XdBaseUser xdBaseUser = (XdBaseUser)XdBaseUser.Companion.resolve(user2.getId());
                    if (xdBaseUser != null) {
                        XdBaseUser xdBaseUser2;
                        XdBaseUser it = xdBaseUser2 = xdBaseUser;
                        userSession = new UserSession(it, null, null, 6, null);
                    } else {
                        userSession = null;
                    }
                    return userSession;
                }
                {
                    this.$details = userDetails;
                    super(0);
                }
            });
        }
        catch (Exception ex) {
            Exception exception = ex;
            if (!(exception instanceof ClientCertificateUnsuitableRequestException)) {
                if (exception instanceof AuthenticationException) {
                    if (ex.getCause() != null) {
                        this.getLogger().warn(ex.getMessage(), ex.getCause());
                    } else {
                        this.getLogger().warn(ex.getMessage());
                    }
                    throw (Throwable)ex;
                }
                this.getLogger().error("Failed to get a client certificate from the request header", (Throwable)ex);
            }
            object = null;
        }
        return object;
    }

    private final void assertBasicAuthIsEnabled() {
        if (this.getJetPass().getAuth().isBasicAuthDisabled()) {
            throw (Throwable)InvalidTokenException.Companion.basicAuthDisabled();
        }
    }

    private final URI getLoginUrl(HttpServletRequest request, String message, String messagesToken) {
        String string;
        Object object;
        Object object2;
        Map authParameters = MapsKt.toMutableMap(OAuthUtilKt.getAuthParameters(request));
        String string2 = request.getParameter("disableGuestLogin");
        if (string2 != null) {
            object2 = string2;
            String it = object2;
            object = authParameters;
            String string3 = "disableGuestLogin";
            String string4 = it;
            object.put(string3, string4);
        }
        if (message != null) {
            object2 = authParameters;
            string = "message";
            object = message;
            object2.put(string, object);
        }
        if (messagesToken != null) {
            object2 = authParameters;
            string = "messages_token";
            object = messagesToken;
            object2.put(string, object);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getUrlProvider().getLoginUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(urlProvider.loginUrl)");
        URI uRI = UriBuilderUtilKt.copyParams(uriBuilder, authParameters).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(urlPr\u2026s(authParameters).build()");
        return uRI;
    }

    static /* bridge */ /* synthetic */ URI getLoginUrl$default(AuthHandler authHandler, HttpServletRequest httpServletRequest, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = httpServletRequest.getParameter("message");
        }
        if ((n & 4) != 0) {
            string2 = httpServletRequest.getParameter("messages_token");
        }
        return authHandler.getLoginUrl(httpServletRequest, string, string2);
    }

    private final URI getApprovalUrl(HttpServletRequest request, String csrf) {
        Map<String, String> authParameters = OAuthUtilKt.getAuthParameters(request);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getUrlProvider().redirectApprovalUrl(csrf));
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(urlPr\u2026edirectApprovalUrl(csrf))");
        URI uRI = UriBuilderUtilKt.copyParams(uriBuilder, authParameters).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(urlPr\u2026s(authParameters).build()");
        return uRI;
    }

    @Override
    @NotNull
    protected Response handleOAuthError(@NotNull Error error, @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response response = Response.seeOther((URI)OAuthUtilKt.getRedirectURL(error, request.getParameter("client_id"))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(error.\u2026eter.CLIENT_ID))).build()");
        return response;
    }

    private final AuthRequestParameter.AccessType getAccessType(Set<String> responseType, HttpServletRequest request) {
        return responseType.contains("token") ? AuthRequestParameter.AccessType.ONLINE : OAuthParametersKt.getAccessType(request);
    }

    private final boolean isAutoApproved(AuthParameters authParameters, String approvalPrompt) {
        if (StringsKt.equals((String)"force", (String)approvalPrompt, (boolean)true)) {
            return false;
        }
        if (this.autoApproveVerifiedServices && authParameters.getClient().getTrusted()) {
            return true;
        }
        XdBaseUser user2 = authParameters.getSession().getUser();
        XdBaseUser xdBaseUser = user2;
        return xdBaseUser instanceof XdUser ? XdApprovedScope.Companion.find((XdUser)user2, authParameters.getClient(), CollectionsKt.asSequence(authParameters.getScope())) != null : xdBaseUser instanceof XdGuestUser;
    }

    private final OneTimeStore<AuthorizationCode> getAuthorizationCodeStore() {
        return (OneTimeStore)this.authorizationCodeStore$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    private final Map<String, String> getResponseParameters(Set<String> responseTypes, AuthParameters authParameters) {
        Pair pair;
        Map map;
        HashMap hashMap;
        HashMap $receiver = hashMap = new HashMap();
        if (responseTypes.contains("token")) {
            AccessToken token = AccessTokenIssuer.issue$default(this.tokenIssuer, authParameters.getClient(), authParameters.getSession().getUser(), authParameters.getScope(), null, 8, null);
            this.getLogger().debug((Function0)new Function0<String>(token){
                final /* synthetic */ AccessToken $token;

                @NotNull
                public final String invoke() {
                    return "Issued token: " + this.$token;
                }
                {
                    this.$token = accessToken;
                    super(0);
                }
            });
            map = $receiver;
            pair = OAuthUtilKt.toParameterMap(token);
            map.putAll(pair);
        }
        if (responseTypes.contains("code")) {
            AuthorizationCode code = new AuthorizationCode(authParameters.getClient(), authParameters.getSession(), authParameters.getScope(), authParameters.getRedirectURI(), authParameters.getAccessType() == AuthRequestParameter.AccessType.OFFLINE, authParameters.getNonce(), authParameters.isOpenIdScope());
            map = $receiver;
            pair = TuplesKt.to((Object)"code", (Object)this.getAuthorizationCodeStore().put((Object)code));
            map.put(pair.getFirst(), pair.getSecond());
        }
        if (responseTypes.contains("id_token")) {
            Map map2 = $receiver;
            map = TuplesKt.to((Object)"id_token", (Object)OpenIDConnectUtilKt.getIdToken(authParameters.getClient(), authParameters.getSession(), authParameters.getNonce(), (String)$receiver.get("access_token"), (String)$receiver.get("code"), responseTypes.size() == 1));
            map2.put(map.getFirst(), map.getSecond());
        }
        return hashMap;
    }

    private final Response.ResponseBuilder authResponse(String redirectUri, String state, Map<String, String> parameters, boolean isURLFragmentResponse) {
        StringBuilder location = new StringBuilder(redirectUri).append(isURLFragmentResponse ? FRAGMENT_DELIMITER : (StringsKt.contains$default((CharSequence)redirectUri, (CharSequence)QUERY_DELIMITER, (boolean)false, (int)2, null) ? PARAMETER_DELIMITER : QUERY_DELIMITER)).append(OAuthUtilKt.asQueryString(parameters, state));
        String string = location.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"location.toString()");
        URI uri = OAuthUtilKt.toURI(string);
        Response.ResponseBuilder responseBuilder = Response.status((int)302).location(uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.status(HttpServ\u2026e.SC_FOUND).location(uri)");
        return responseBuilder;
    }

    private final Response requireEmailVerificationResponse(HttpServletRequest request) {
        UriBuilder uriBuilder;
        UriBuilder $receiver$iv;
        URI $receiver$iv2 = this.getUrlProvider().getRequestEmailVerificationURL();
        UriBuilder $receiver = $receiver$iv = (uriBuilder = UriBuilderUtilKt.builder($receiver$iv2));
        UriBuilderUtilKt.copyParams($receiver, OAuthUtilKt.getAuthParameters(request));
        URI uRI = uriBuilder.build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"builder().apply { body() }.build()");
        URI uri = uRI;
        Response response = Response.seeOther((URI)uri).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(uri).build()");
        return response;
    }

    private final void writeLogoutAudit(HttpServletRequest request) {
        UserSession userSession = OAuthUtilKt.getUserSession(request, true);
        if (userSession == null) {
            return;
        }
        UserSession session2 = userSession;
        XdBaseUser user2 = session2.getUser();
        this.getLogger().info(LogMarkers.INSTANCE.getLOGIN_AUDIT(), "User " + user2.getLogin() + " [" + user2.getUuid() + "] has been logged out");
    }

    public AuthHandler() {
        ReadOnlyProperty readOnlyProperty;
        AuthHandler authHandler = this;
        String name$iv = null;
        authHandler.approvalStore$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        authHandler = this;
        name$iv = null;
        authHandler.urlProvider$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        authHandler = this;
        name$iv = null;
        authHandler.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        authHandler = this;
        name$iv = null;
        authHandler.jetPass$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        authHandler = this;
        name$iv = null;
        authHandler.hubPrincipalManager$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        this.autoApproveVerifiedServices = true;
        this.tokenIssuer = new AccessTokenIssuer();
        name$iv = "authorizationCodeStoreDelegate";
        authHandler = this;
        authHandler.authorizationCodeStore$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    public static final /* synthetic */ void access$writeLogoutAudit(AuthHandler $this, @NotNull HttpServletRequest request) {
        $this.writeLogoutAudit(request);
    }

    @NotNull
    public static final /* synthetic */ Response.ResponseBuilder access$authResponse(AuthHandler $this, @NotNull String redirectUri, @Nullable String state, @NotNull Map parameters, boolean isURLFragmentResponse) {
        return $this.authResponse(redirectUri, state, parameters, isURLFragmentResponse);
    }

    @NotNull
    public static final /* synthetic */ Map access$getResponseParameters(AuthHandler $this, @NotNull Set responseTypes, @NotNull AuthParameters authParameters) {
        return $this.getResponseParameters(responseTypes, authParameters);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/oauth2/server/AuthHandler$Companion;", "Lmu/KLogging;", "()V", "FRAGMENT_DELIMITER", "", "PARAMETER_DELIMITER", "PARAMETER_VALUE_DELIMITER", "", "QUERY_DELIMITER", "jetbrains.jetpass.oauth2"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

