/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.OAuthTokenValidationException;
import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.RefreshToken;
import javax.servlet.http.HttpServletRequest;
import jetbrains.jetpass.core.store.OneTimeStore;
import jetbrains.jetpass.oauth2.server.AuthorizationCode;
import jetbrains.jetpass.oauth2.server.OpenIDConnectUtilKt;
import jetbrains.jetpass.oauth2.server.RequestType;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt;
import jetbrains.jetpass.oauth2.server.TokenHandler;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdRefreshToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0014R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\n\u001a\u00020\u0005*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/oauth2/server/AuthorizationCodeTokenHandler;", "Ljetbrains/jetpass/oauth2/server/TokenHandler;", "()V", "authorizationCodeStore", "Ljetbrains/jetpass/core/store/OneTimeStore;", "Ljetbrains/jetpass/oauth2/server/AuthorizationCode;", "getAuthorizationCodeStore", "()Ljetbrains/jetpass/core/store/OneTimeStore;", "authorizationCodeStore$delegate", "Lkotlin/properties/ReadOnlyProperty;", "authorizationCode", "Ljavax/servlet/http/HttpServletRequest;", "getAuthorizationCode$jetbrains_jetpass_oauth2", "(Ljavax/servlet/http/HttpServletRequest;)Ljetbrains/jetpass/oauth2/server/AuthorizationCode;", "issue", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "request", "jetbrains.jetpass.oauth2"})
public final class AuthorizationCodeTokenHandler
extends TokenHandler {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty authorizationCodeStore$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AuthorizationCodeTokenHandler.class), "authorizationCodeStore", "getAuthorizationCodeStore()Ljetbrains/jetpass/core/store/OneTimeStore;"))};
    }

    @NotNull
    public final OneTimeStore<AuthorizationCode> getAuthorizationCodeStore() {
        return (OneTimeStore)this.authorizationCodeStore$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    protected AccessToken issue(@NotNull HttpServletRequest request) throws OAuthValidationException {
        AccessToken accessToken;
        XdService client;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AuthorizationCode code = this.getAuthorizationCode$jetbrains_jetpass_oauth2(request);
        String redirectUri = null;
        if (code.hasRedirectUri()) {
            redirectUri = RequestValidatorKt.getRequiredParameter(request, "redirect_uri", RequestType.TOKEN);
        }
        if (!code.matches(client = RequestValidatorKt.authenticateClientFromHeader(request), redirectUri)) {
            throw (Throwable)OAuthTokenValidationException.Companion.invalidAuthCode();
        }
        XdBaseUser issuedToUser = code.getSession().getUser();
        Iterable<XdService> issuedForScope = code.getScope();
        String idToken = code.isOpenIDScope() ? OpenIDConnectUtilKt.getIdToken$default(code.getClient(), code.getSession(), code.getNonce(), null, null, false, 56, null) : null;
        AccessToken accessToken2 = this.getTokenIssuer().issue(client, issuedToUser, issuedForScope, idToken);
        if (code.isOffline()) {
            RefreshToken refreshToken = new RefreshToken(accessToken2, XdRefreshToken.Companion.emit(issuedToUser, client, issuedForScope));
            accessToken = (AccessToken)refreshToken;
        } else {
            accessToken = accessToken2;
        }
        return accessToken;
    }

    @NotNull
    public final AuthorizationCode getAuthorizationCode$jetbrains_jetpass_oauth2(@NotNull HttpServletRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String code = RequestValidatorKt.getRequiredParameter($receiver, "code", RequestType.TOKEN);
        AuthorizationCode authorizationCode = (AuthorizationCode)this.getAuthorizationCodeStore().get(code);
        if (authorizationCode == null) {
            throw (Throwable)OAuthTokenValidationException.Companion.unknownAuthCode();
        }
        return authorizationCode;
    }

    public AuthorizationCodeTokenHandler() {
        ReadOnlyProperty readOnlyProperty;
        String name$iv = "authorizationCodeStoreDelegate";
        AuthorizationCodeTokenHandler authorizationCodeTokenHandler = this;
        authorizationCodeTokenHandler.authorizationCodeStore$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }
}

