/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.SignatureException;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import jetbrains.exodus.core.crypto.MessageDigestUtil;
import jetbrains.jetpass.oauth2.server.MaxAgeInfo;
import jetbrains.jetpass.oauth2.server.PersistentMaxAgeInfo;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import mu.KLogging;
import org.apache.commons.lang.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00122\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0004J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0010H\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/oauth2/server/CookieHandler;", "", "()V", "maxAgeInfo", "Ljetbrains/jetpass/oauth2/server/MaxAgeInfo;", "getMaxAgeInfo", "()Ljetbrains/jetpass/oauth2/server/MaxAgeInfo;", "setMaxAgeInfo", "(Ljetbrains/jetpass/oauth2/server/MaxAgeInfo;)V", "initCipher", "Ljavax/crypto/Cipher;", "mode", "", "secret", "", "decode", "Ljetbrains/jetpass/oauth2/server/CookieHandler$CookieData;", "encode", "Companion", "CookieData", "Decoder", "Encoder", "jetbrains.jetpass.oauth2"})
public abstract class CookieHandler {
    @NotNull
    private MaxAgeInfo maxAgeInfo = new PersistentMaxAgeInfo();
    private static final char DELIMITER = '.';
    private static final String SPLIT_PATTERN = "\\.";
    private static final String SESSION = "session";
    @NotNull
    private static final String GUEST_SECRET;
    public static final Companion Companion;

    @NotNull
    public final MaxAgeInfo getMaxAgeInfo() {
        return this.maxAgeInfo;
    }

    public final void setMaxAgeInfo(@NotNull MaxAgeInfo maxAgeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)maxAgeInfo, (String)"<set-?>");
        this.maxAgeInfo = maxAgeInfo;
    }

    @NotNull
    public final Cipher initCipher(int mode, @NotNull String secret) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        try {
            SecretKeySpec secretKeySpec;
            Cipher cipher;
            Cipher $receiver = cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            Companion.getLogger().trace((Function0)new Function0<String>($receiver){
                final /* synthetic */ Cipher receiver$0;

                @NotNull
                public final String invoke() {
                    return "Algorithm: " + this.receiver$0.getAlgorithm();
                }
                {
                    this.receiver$0 = cipher;
                    super(0);
                }
            });
            String string = secret;
            Charset charset = Charsets.UTF_8;
            SecretKeySpec secretKeySpec2 = secretKeySpec;
            SecretKeySpec secretKeySpec3 = secretKeySpec;
            int n = mode;
            Cipher cipher2 = $receiver;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            secretKeySpec2(MessageDigestUtil.MD5((byte[])byArray2), "AES");
            cipher2.init(n, secretKeySpec3);
            Cipher cipher3 = cipher;
            Intrinsics.checkExpressionValueIsNotNull((Object)cipher3, (String)"Cipher.getInstance(\"AES/\u2026)), \"AES\"))\n            }");
            return cipher3;
        }
        catch (GeneralSecurityException ex) {
            throw (Throwable)new RuntimeException("Failed to init cipher", ex);
        }
    }

    @NotNull
    protected final String encode(@NotNull CookieData $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder builder = new StringBuilder(String.valueOf($receiver.getIssued()));
        builder.append('.');
        builder.append($receiver.getSession() ? SESSION : "");
        builder.append('.');
        String string = $receiver.getDetails();
        Charset charset = Charsets.UTF_8;
        StringBuilder stringBuilder = builder;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        stringBuilder.append(DatatypeConverter.printBase64Binary((byte[])byArray2));
        String string3 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.toString()");
        return string3;
    }

    @NotNull
    protected final CookieData decode(@NotNull String $receiver, @NotNull MaxAgeInfo maxAgeInfo) throws SignatureException {
        List list;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)maxAgeInfo, (String)"maxAgeInfo");
        Object object = $receiver;
        String string = SPLIT_PATTERN;
        string = new Regex(string);
        int n = 0;
        object = string.split((CharSequence)object, n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                CharSequence charSequence = it;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $receiver$iv = list;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] sections = stringArray;
        if (sections.length != 3) {
            throw (Throwable)new SignatureException("Incorrect block padding. Expected: 3, but was: " + sections.length);
        }
        long issued = Long.parseLong(sections[0]);
        boolean session2 = Intrinsics.areEqual((Object)SESSION, (Object)sections[1]);
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)sections[2]);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"DatatypeConverter.parseBase64Binary(sections[2])");
        byte[] byArray2 = byArray;
        Charset charset = Charsets.UTF_8;
        String details = new String(byArray2, charset);
        return new CookieData(session2, details, maxAgeInfo, issued);
    }

    static {
        Companion = new Companion(null);
        String string = RandomStringUtils.randomAlphanumeric((int)16);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RandomStringUtils.randomAlphanumeric(16)");
        GUEST_SECRET = string;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Ljetbrains/jetpass/oauth2/server/CookieHandler$Decoder;", "Ljetbrains/jetpass/oauth2/server/CookieHandler;", "detailsUUID", "", "data", "", "(Ljava/lang/String;[B)V", "getDetailsUUID", "()Ljava/lang/String;", "decode", "Ljetbrains/jetpass/oauth2/server/CookieHandler$CookieData;", "secret", "jetbrains.jetpass.oauth2"})
    public static final class Decoder
    extends CookieHandler {
        @NotNull
        private final String detailsUUID;
        private final byte[] data;

        @Nullable
        public final CookieData decode(@NotNull String secret) {
            Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
            Cipher cipher = this.initCipher(2, secret);
            try {
                Companion.getLogger().trace((Function0)new Function0<String>(this){
                    final /* synthetic */ Decoder this$0;

                    @NotNull
                    public final String invoke() {
                        return "Data length to decode: " + Decoder.access$getData$p(this.this$0).length;
                    }
                    {
                        this.this$0 = decoder;
                        super(0);
                    }
                });
                byte[] byArray = cipher.doFinal(this.data);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(data)");
                byte[] byArray2 = byArray;
                Charset charset = Charsets.UTF_8;
                String decoded = new String(byArray2, charset);
                CookieData cookie = this.decode(decoded, this.getMaxAgeInfo());
                String detailsUUID = this.detailsUUID;
                if (Intrinsics.areEqual((Object)cookie.getDetails(), (Object)detailsUUID) ^ true) {
                    Companion.getLogger().error((Function0)new Function0<String>(detailsUUID){
                        final /* synthetic */ String $detailsUUID;

                        @NotNull
                        public final String invoke() {
                            return "Secret was compromised for details: " + this.$detailsUUID;
                        }
                        {
                            this.$detailsUUID = string;
                            super(0);
                        }
                    });
                    return null;
                }
                return cookie;
            }
            catch (GeneralSecurityException ex) {
                if (Companion.getLogger().isTraceEnabled()) {
                    Companion.getLogger().info((Throwable)ex, (Function0)new Function0<String>(ex){
                        final /* synthetic */ GeneralSecurityException $ex;

                        @NotNull
                        public final String invoke() {
                            return "Failed to decode cookie data. " + this.$ex.getMessage();
                        }
                        {
                            this.$ex = generalSecurityException;
                            super(0);
                        }
                    });
                } else {
                    Companion.getLogger().info((Function0)new Function0<String>(ex){
                        final /* synthetic */ GeneralSecurityException $ex;

                        @NotNull
                        public final String invoke() {
                            return "Failed to decode cookie data. " + this.$ex.getMessage();
                        }
                        {
                            this.$ex = generalSecurityException;
                            super(0);
                        }
                    });
                }
                return null;
            }
        }

        @NotNull
        public final String getDetailsUUID() {
            return this.detailsUUID;
        }

        public Decoder(@NotNull String detailsUUID, @NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)detailsUUID, (String)"detailsUUID");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            this.detailsUUID = detailsUUID;
            this.data = data;
        }

        @NotNull
        public static final /* synthetic */ byte[] access$getData$p(Decoder $this) {
            return $this.data;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Ljetbrains/jetpass/oauth2/server/CookieHandler$Encoder;", "Ljetbrains/jetpass/oauth2/server/CookieHandler;", "detailsUUID", "", "data", "Ljetbrains/jetpass/oauth2/server/CookieHandler$CookieData;", "(Ljava/lang/String;Ljetbrains/jetpass/oauth2/server/CookieHandler$CookieData;)V", "getDetailsUUID", "()Ljava/lang/String;", "encode", "secret", "jetbrains.jetpass.oauth2"})
    public static final class Encoder
    extends CookieHandler {
        @NotNull
        private final String detailsUUID;
        private final CookieData data;

        @NotNull
        public final String encode(@NotNull String secret) {
            Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
            Cipher cipher = this.initCipher(1, secret);
            try {
                String string = this.encode(this.data);
                Object object = Charsets.UTF_8;
                Object object2 = cipher;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                byte[] encoded = ((Cipher)object2).doFinal(byArray2);
                Companion.getLogger().trace((Function0)new Function0<String>(encoded){
                    final /* synthetic */ byte[] $encoded;

                    @NotNull
                    public final String invoke() {
                        return "Data length encoded result: " + this.$encoded.length;
                    }
                    {
                        this.$encoded = byArray;
                        super(0);
                    }
                });
                object = this.detailsUUID;
                Charset charset = Charsets.UTF_8;
                object2 = new StringBuilder();
                Object object3 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray3 = ((String)object3).getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
                byArray2 = byArray3;
                String result = ((StringBuilder)object2).append(DatatypeConverter.printBase64Binary((byte[])byArray2)).append('.').append(DatatypeConverter.printBase64Binary((byte[])encoded)).toString();
                return result;
            }
            catch (GeneralSecurityException ex) {
                throw (Throwable)new RuntimeException("Failed to encode cookie", ex);
            }
        }

        @NotNull
        public final String getDetailsUUID() {
            return this.detailsUUID;
        }

        public Encoder(@NotNull String detailsUUID, @NotNull CookieData data) {
            Intrinsics.checkParameterIsNotNull((Object)detailsUUID, (String)"detailsUUID");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            this.detailsUUID = detailsUUID;
            this.data = data;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001c\u001a\u00020\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/oauth2/server/CookieHandler$CookieData;", "", "session", "", "details", "", "maxAgeInfo", "Ljetbrains/jetpass/oauth2/server/MaxAgeInfo;", "issued", "", "(ZLjava/lang/String;Ljetbrains/jetpass/oauth2/server/MaxAgeInfo;J)V", "getDetails", "()Ljava/lang/String;", "expiration", "Lorg/joda/time/DateTime;", "getExpiration", "()Lorg/joda/time/DateTime;", "isExpired", "()Z", "getIssued", "()J", "maxAge", "Lorg/joda/time/Seconds;", "getMaxAge", "()Lorg/joda/time/Seconds;", "getMaxAgeInfo", "()Ljetbrains/jetpass/oauth2/server/MaxAgeInfo;", "getSession", "equals", "other", "hashCode", "", "jetbrains.jetpass.oauth2"})
    public static final class CookieData {
        private final boolean session;
        @NotNull
        private final String details;
        @NotNull
        private final MaxAgeInfo maxAgeInfo;
        private final long issued;

        @NotNull
        public final DateTime getExpiration() {
            DateTime dateTime = new DateTime(this.issued).plus((ReadablePeriod)this.getMaxAge());
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime(issued).plus(maxAge)");
            return dateTime;
        }

        @NotNull
        public final Seconds getMaxAge() {
            Seconds seconds = Seconds.seconds((int)(this.session ? this.maxAgeInfo.getSessionInterval() : this.maxAgeInfo.getRememberMeInterval()));
            Intrinsics.checkExpressionValueIsNotNull((Object)seconds, (String)"Seconds.seconds(if (sess\u2026eInfo.rememberMeInterval)");
            return seconds;
        }

        public final boolean isExpired() {
            return new DateTime(System.currentTimeMillis()).isAfter((ReadableInstant)this.getExpiration());
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CookieData)) {
                return false;
            }
            if (this.session != ((CookieData)other).session) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.details, (Object)((CookieData)other).details) ^ true) {
                return false;
            }
            return this.issued == ((CookieData)other).issued;
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.session);
            result = 31 * result + this.details.hashCode();
            result = 31 * result + Long.hashCode(this.issued);
            return result;
        }

        public final boolean getSession() {
            return this.session;
        }

        @NotNull
        public final String getDetails() {
            return this.details;
        }

        @NotNull
        public final MaxAgeInfo getMaxAgeInfo() {
            return this.maxAgeInfo;
        }

        public final long getIssued() {
            return this.issued;
        }

        public CookieData(boolean session2, @NotNull String details, @NotNull MaxAgeInfo maxAgeInfo, long issued) {
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            Intrinsics.checkParameterIsNotNull((Object)maxAgeInfo, (String)"maxAgeInfo");
            this.session = session2;
            this.details = details;
            this.maxAgeInfo = maxAgeInfo;
            this.issued = issued;
        }

        public /* synthetic */ CookieData(boolean bl, String string, MaxAgeInfo maxAgeInfo, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                l = System.currentTimeMillis();
            }
            this(bl, string, maxAgeInfo, l);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/oauth2/server/CookieHandler$Companion;", "Lmu/KLogging;", "()V", "DELIMITER", "", "GUEST_SECRET", "", "getGUEST_SECRET", "()Ljava/lang/String;", "SESSION", "SPLIT_PATTERN", "getDecoder", "Ljetbrains/jetpass/oauth2/server/CookieHandler$Decoder;", "data", "getEncoder", "Ljetbrains/jetpass/oauth2/server/CookieHandler$Encoder;", "Ljetbrains/jetpass/oauth2/server/CookieHandler$CookieData;", "jetbrains.jetpass.oauth2"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final String getGUEST_SECRET() {
            return GUEST_SECRET;
        }

        @Nullable
        public final Decoder getDecoder(@NotNull String data) {
            Decoder decoder;
            List list;
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Object object = data;
            Object object2 = CookieHandler.SPLIT_PATTERN;
            object2 = new Regex((String)object2);
            int n = 0;
            Collection $receiver$iv = object2.split((CharSequence)object, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] parts = stringArray;
            if (parts.length == 2) {
                Decoder decoder2;
                byte[] byArray = DatatypeConverter.parseBase64Binary((String)parts[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"DatatypeConverter.parseBase64Binary(parts[0])");
                object = byArray;
                object2 = Charsets.UTF_8;
                Decoder decoder3 = decoder2;
                Decoder decoder4 = decoder2;
                String string = new String((byte[])object, (Charset)object2);
                decoder = decoder4;
                byte[] byArray2 = DatatypeConverter.parseBase64Binary((String)parts[1]);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"DatatypeConverter.parseBase64Binary(parts[1])");
                decoder3(string, byArray2);
            } else {
                this.getLogger().warn((Function0)new Function0<String>(data){
                    final /* synthetic */ String $data;

                    @NotNull
                    public final String invoke() {
                        return "Invalid cookie value \"" + this.$data + '\"';
                    }
                    {
                        this.$data = string;
                        super(0);
                    }
                });
                decoder = null;
            }
            return decoder;
        }

        @NotNull
        public final Encoder getEncoder(@NotNull CookieData data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return new Encoder(data.getDetails(), data);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

