/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.NewCookie;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/oauth2/server/NewCookieExt;", "Ljavax/ws/rs/core/NewCookie;", "name", "", "value", "path", "maxAge", "", "secure", "", "httpOnly", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IZZ)V", "expires", "Ljava/util/Date;", "toString", "Companion", "jetbrains.jetpass.oauth2"})
public final class NewCookieExt
extends NewCookie {
    private final Date expires;
    private final boolean httpOnly;
    private static final TimeZone GMT_TZ;
    private static final String COOKIE_DATE_FORMAT = "EEE, dd-MMM-yyyy HH:mm:ss zzz";
    private static final int SESSION_COOKIE = -1;
    private static final int REMOVE_COOKIE = 0;
    public static final Companion Companion;

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        if (this.getMaxAge() != SESSION_COOKIE) {
            SimpleDateFormat format = new SimpleDateFormat(COOKIE_DATE_FORMAT, Locale.ROOT);
            format.setTimeZone(GMT_TZ);
            builder.append(";Expires=").append(format.format(this.expires));
        }
        if (this.httpOnly) {
            builder.append(";HttpOnly");
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public NewCookieExt(@NotNull String name, @NotNull String value, @NotNull String path, int maxAge, boolean secure, boolean httpOnly) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        super(name, OAuthUtilKt.urlEncode(value), path, null, null, maxAge, secure);
        this.httpOnly = httpOnly;
        this.expires = new Date(maxAge == REMOVE_COOKIE ? 0L : System.currentTimeMillis() + (long)maxAge * (long)1000);
    }

    static {
        Companion = new Companion(null);
        GMT_TZ = TimeZone.getTimeZone("GMT");
        COOKIE_DATE_FORMAT = COOKIE_DATE_FORMAT;
        SESSION_COOKIE = -1;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Ljetbrains/jetpass/oauth2/server/NewCookieExt$Companion;", "", "()V", "COOKIE_DATE_FORMAT", "", "GMT_TZ", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "REMOVE_COOKIE", "", "getREMOVE_COOKIE", "()I", "SESSION_COOKIE", "getSESSION_COOKIE", "jetbrains.jetpass.oauth2"})
    public static final class Companion {
        public final int getSESSION_COOKIE() {
            return SESSION_COOKIE;
        }

        public final int getREMOVE_COOKIE() {
            return REMOVE_COOKIE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

