/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.core.Error;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.oauth2.server.PerformanceUtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/oauth2/server/OAuth2RequestHandler;", "", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "handle", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "handleOAuthError", "error", "Lcom/intellij/hub/core/Error;", "handleOAuthRequest", "jetbrains.jetpass.oauth2"})
public abstract class OAuth2RequestHandler {
    @NotNull
    private final KLogger logger;

    @NotNull
    protected final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Response handle(@NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (Response)PerformanceUtilKt.measurePerformance("process OAuth2 request: [" + request.getRequestURL() + ']', (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ OAuth2RequestHandler this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.getLogger().trace(it);
            }
            {
                this.this$0 = oAuth2RequestHandler;
                super(1);
            }
        }), TimeUnit.MILLISECONDS, (Function0)new Function0<Response>(this, request){
            final /* synthetic */ OAuth2RequestHandler this$0;
            final /* synthetic */ HttpServletRequest $request;

            @NotNull
            public final Response invoke() {
                Response response;
                try {
                    response = this.this$0.handleOAuthRequest(this.$request);
                }
                catch (OAuthValidationException ex) {
                    response = this.this$0.handleOAuthError(ex.getError(), this.$request);
                }
                return response;
            }
            {
                this.this$0 = oAuth2RequestHandler;
                this.$request = httpServletRequest;
                super(0);
            }
        });
    }

    @NotNull
    protected abstract Response handleOAuthRequest(@NotNull HttpServletRequest var1) throws OAuthValidationException;

    @NotNull
    protected abstract Response handleOAuthError(@NotNull Error var1, @NotNull HttpServletRequest var2);

    public OAuth2RequestHandler() {
        String string = this.getClass().getCanonicalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.canonicalName");
        this.logger = KotlinLogging.INSTANCE.logger(string);
    }
}

