/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import java.net.URI;
import java.net.URL;
import javax.ws.rs.core.UriBuilder;
import jetbrains.jetpass.core.webr.async.RequestContext;
import jetbrains.jetpass.oauth2.server.UriBuilderUtilKt;
import jetbrains.jetpass.service.api.FrontendURLProvider;
import jetbrains.jetpass.userManagement.persistence.UriConcatenator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J.\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u00142\b\u0010!\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0014H\u0016J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0014H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006)"}, d2={"Ljetbrains/jetpass/oauth2/server/OAuthURLProvider;", "Ljetbrains/jetpass/service/api/FrontendURLProvider;", "()V", "_authURI", "Ljava/net/URI;", "absoluteFrontEndURL", "Ljava/net/URL;", "getAbsoluteFrontEndURL", "()Ljava/net/URL;", "approvalUrl", "getApprovalUrl", "()Ljava/net/URI;", "value", "authUrl", "getAuthUrl", "setAuthUrl", "(Ljava/net/URI;)V", "errorUrl", "getErrorUrl", "frontEndURI", "", "getFrontEndURI", "()Ljava/lang/String;", "setFrontEndURI", "(Ljava/lang/String;)V", "loginUrl", "getLoginUrl", "registerUrl", "getRegisterUrl", "baseUrl", "getInviteURL", "code", "serviceId", "userId", "getProfileURL", "getRequestEmailVerificationURL", "getRestoreCodeUrl", "getTwoFactorAuthenticationUrl", "session", "redirectApprovalUrl", "csrfKey", "jetbrains.jetpass.oauth2"})
public final class OAuthURLProvider
implements FrontendURLProvider {
    private URI _authURI;
    @Nullable
    private String frontEndURI;

    @NotNull
    public final URI getAuthUrl() {
        return this.getAuthUrl(null);
    }

    public final void setAuthUrl(@NotNull URI value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this._authURI = value;
    }

    @Nullable
    public final String getFrontEndURI() {
        return this.frontEndURI;
    }

    public final void setFrontEndURI(@Nullable String string) {
        this.frontEndURI = string;
    }

    @NotNull
    public URL getAbsoluteFrontEndURL() {
        return this.getAbsoluteFrontEndURL(null);
    }

    @NotNull
    public URI getRestoreCodeUrl(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        URI uRI = UriBuilder.fromUri((URI)this.getAuthUrl()).path("restore").path(code).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authU\u2026tore\").path(code).build()");
        return uRI;
    }

    @NotNull
    public URI getTwoFactorAuthenticationUrl(@NotNull String session2) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.getAuthUrl()).path("2fa");
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder.fromUri(authU\u2026             .path(\"2fa\")");
        URI uRI = UriBuilderUtilKt.q(uriBuilder, "session", session2).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authU\u2026                 .build()");
        return uRI;
    }

    @NotNull
    public URI getInviteURL(@NotNull String code, @Nullable String serviceId, @Nullable String userId, @Nullable String baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        URI authUrl = this.getAuthUrl(baseUrl);
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)authUrl).path("invite").path(code);
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"UriBuilder\n             \u2026              .path(code)");
        URI uRI = UriBuilderUtilKt.q(UriBuilderUtilKt.q(uriBuilder, "client_id", serviceId), "userId", userId).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder\n             \u2026\n                .build()");
        return uRI;
    }

    @NotNull
    public URI getRequestEmailVerificationURL() {
        URI uRI = UriBuilder.fromUri((URI)this.getAuthUrl()).path("verification").build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authU\u2026h(\"verification\").build()");
        return uRI;
    }

    @NotNull
    public URI redirectApprovalUrl(@NotNull String csrfKey) {
        Intrinsics.checkParameterIsNotNull((Object)csrfKey, (String)"csrfKey");
        URI uRI = UriBuilder.fromUri((URI)this.getApprovalUrl()).queryParam("csrf", new Object[]{csrfKey}).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(appro\u2026(\"csrf\", csrfKey).build()");
        return uRI;
    }

    @NotNull
    public URI getErrorUrl() {
        URI uRI = UriBuilder.fromUri((URI)this.getAuthUrl()).path("oauth").path("error").build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authU\u2026h\").path(\"error\").build()");
        return uRI;
    }

    @NotNull
    public final URI getApprovalUrl() {
        URI uRI = UriBuilder.fromUri((URI)this.getAuthUrl()).path("oauth").build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authUrl).path(\"oauth\").build()");
        return uRI;
    }

    @NotNull
    public URI getLoginUrl() {
        URI uRI = UriBuilder.fromUri((URI)this.getAuthUrl()).path("login").build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authUrl).path(\"login\").build()");
        return uRI;
    }

    @NotNull
    public URI getRegisterUrl() {
        URI uRI = UriBuilder.fromUri((URI)this.getAuthUrl()).path("register").build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(authU\u2026.path(\"register\").build()");
        return uRI;
    }

    @NotNull
    public URL getProfileURL(@NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        URL uRL = UriBuilder.fromUri((URI)this.getAbsoluteFrontEndURL().toURI()).path("users").path(userId).build(new Object[0]).toURL();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"UriBuilder.fromUri(absol\u2026h(userId).build().toURL()");
        return uRL;
    }

    private final URI getAuthUrl(String baseUrl) {
        String string = this.getAbsoluteFrontEndURL(baseUrl).toString();
        Object object = this._authURI;
        if (object == null || (object = ((URI)object).toASCIIString()) == null) {
            object = "auth";
        }
        return UriConcatenator.INSTANCE.concat(string, (String)object);
    }

    private final URL getAbsoluteFrontEndURL(String baseUrl) {
        String frontEndURL;
        String string = baseUrl;
        if (string == null) {
            string = RequestContext.INSTANCE.getBaseURL();
        }
        String hubBaseURL = string;
        String frontEndURI = this.frontEndURI;
        String string2 = frontEndURL = frontEndURI != null ? UriConcatenator.INSTANCE.concat(hubBaseURL, frontEndURI).toString() : hubBaseURL + StringsKt.removeSuffix((String)RequestContext.INSTANCE.getServletPath(), (CharSequence)"/api/rest");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"frontEndURL");
        return new URL(UriConcatenator.INSTANCE.stripSlash(string2));
    }
}

