/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.RefreshToken;
import com.intellij.hub.core.Error;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import jetbrains.jetpass.oauth2.server.AuthCookieUtilKt;
import jetbrains.jetpass.oauth2.server.CookieHandler;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.oauth2.server.UriBuilderUtilKt;
import jetbrains.jetpass.oauth2.server.UserSession;
import jetbrains.jetpass.rest.dto.AccessTokenJSON;
import jetbrains.jetpass.service.api.FrontendURLProvider;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGuestUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u000e\u001a\u00020\u0002*\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u001a\u0016\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n*\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\u000b*\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0002\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u001b\u001a\u0016\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n*\u00020\u001b\u001a\u0016\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n*\u00020\u0013\u001a\n\u0010\u001d\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001f\u001a\u00020\u0002*\u00020\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"!\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"PASSED_AUTH_PARAMETERS", "", "", "urlProvider", "Ljetbrains/jetpass/service/api/FrontendURLProvider;", "getUrlProvider", "()Ljetbrains/jetpass/service/api/FrontendURLProvider;", "urlProvider$delegate", "Lkotlin/properties/ReadOnlyProperty;", "queryParameters", "", "Ljava/net/URI;", "getQueryParameters", "(Ljava/net/URI;)Ljava/util/Map;", "asQueryString", "state", "getAuthParameters", "Ljavax/servlet/http/HttpServletRequest;", "getRedirectURL", "Lcom/intellij/hub/core/Error;", "clientId", "getUserSession", "Ljetbrains/jetpass/oauth2/server/UserSession;", "isGuestAllowed", "", "toJSON", "Ljetbrains/jetpass/rest/dto/AccessTokenJSON;", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "toParameterMap", "toURI", "urlDecode", "urlEncode", "jetbrains.jetpass.oauth2"})
public final class OAuthUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Set<String> PASSED_AUTH_PARAMETERS;
    @NotNull
    private static final ReadOnlyProperty urlProvider$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(OAuthUtilKt.class, (String)"jetbrains.jetpass.oauth2"), "urlProvider", "getUrlProvider()Ljetbrains/jetpass/service/api/FrontendURLProvider;"))};
        PASSED_AUTH_PARAMETERS = SetsKt.setOf((Object[])new String[]{"response_type", "client_id", "redirect_uri", "scope", "state", "access_type", "nonce"});
        String name$iv = null;
        urlProvider$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final String asQueryString(@NotNull Map<String, String> $receiver, @Nullable String state) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return SequencesKt.joinToString$default((Sequence)(state != null ? SequencesKt.plus((Sequence)MapsKt.asSequence($receiver), (Sequence)MapsKt.asSequence((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"state", (Object)state)))) : MapsKt.asSequence($receiver)), (CharSequence)"&", null, null, (int)0, null, (Function1)asQueryString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String urlEncode(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            String string = URLEncoder.encode($receiver, Charsets.UTF_8.name());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(this, Charsets.UTF_8.name())");
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            throw (Throwable)new RuntimeException(ex);
        }
    }

    @NotNull
    public static final String urlDecode(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            String string = URLDecoder.decode($receiver, Charsets.UTF_8.name());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLDecoder.decode(this, Charsets.UTF_8.name())");
            return string;
        }
        catch (UnsupportedEncodingException ex) {
            throw (Throwable)new RuntimeException(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getQueryParameters(@NotNull URI $receiver) {
        void var3_3;
        List list;
        List it;
        char[] cArray;
        Collection collection;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.getRawQuery();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rawQuery");
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)string, (char[])new char[]{'&'}, (boolean)false, (int)0, (int)6, null);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            cArray = new char[]{'='};
            boolean bl = false;
            int n = 2;
            list = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (char[])cArray, (boolean)bl, (int)n, (int)2, null);
            collection.add(list);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $key_value;
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            cArray = $key_value;
            String key = (String)cArray.get(0);
            cArray = $key_value;
            String value = (String)cArray.get(1);
            list = TuplesKt.to((Object)OAuthUtilKt.urlDecode(key), (Object)OAuthUtilKt.urlDecode(value));
            collection.add(list);
        }
        return MapsKt.toMap((Iterable)((List)var3_3));
    }

    @NotNull
    public static final URI toURI(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            URI uRI = new URI($receiver).parseServerAuthority();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI(this).parseServerAuthority()");
            return uRI;
        }
        catch (URISyntaxException ex) {
            throw (Throwable)new RuntimeException(ex);
        }
    }

    @NotNull
    public static final AccessTokenJSON toJSON(@NotNull AccessToken $receiver) {
        AccessTokenJSON accessTokenJSON;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AccessTokenJSON $receiver2 = accessTokenJSON = new AccessTokenJSON();
        $receiver2.setAccess_token($receiver.encode());
        $receiver2.setToken_type($receiver.getType());
        $receiver2.setExpires_in(Integer.valueOf($receiver.getTtlSeconds()));
        $receiver2.setScope(ArraysKt.joinToString$default((Object[])$receiver.getScope(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        $receiver2.setId_token($receiver.getData().getIdToken());
        if ($receiver instanceof RefreshToken) {
            $receiver2.setRefresh_token(((RefreshToken)$receiver).getRefreshTokenID());
        }
        return accessTokenJSON;
    }

    @NotNull
    public static final Map<String, String> toParameterMap(@NotNull AccessToken $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"access_token", (Object)$receiver.encode()), TuplesKt.to((Object)"token_type", (Object)$receiver.getType()), TuplesKt.to((Object)"expires_in", (Object)String.valueOf($receiver.getTtlSeconds())), TuplesKt.to((Object)"scope", (Object)ArraysKt.joinToString$default((Object[])$receiver.getScope(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null))});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getAuthParameters(@NotNull HttpServletRequest $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Iterable iterable = $receiver$iv = (Iterable)PASSED_AUTH_PARAMETERS;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Pair pair;
            Pair pair2;
            Object element$iv$iv = element$iv$iv$iv;
            String parameterName = (String)element$iv$iv;
            if ($receiver.getParameter(parameterName) != null) {
                String string;
                String parameterValue = string;
                pair2 = TuplesKt.to((Object)parameterName, (Object)StringsKt.replace$default((String)OAuthUtilKt.urlEncode(parameterValue), (String)"+", (String)"%20", (boolean)false, (int)4, null));
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair = pair2;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final UserSession getUserSession(@NotNull HttpServletRequest $receiver, boolean isGuestAllowed) {
        void loggedInUser;
        Pair pair;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = AuthCookieUtilKt.getCookie($receiver);
        if (string == null) {
            return null;
        }
        String value = string;
        XdGuestUser guest = XdRoots.INSTANCE.getGuest();
        CookieHandler.Decoder decoder = CookieHandler.Companion.getDecoder(value);
        if (decoder == null) {
            return null;
        }
        CookieHandler.Decoder decoder2 = decoder;
        String detailsId = decoder2.getDetailsUUID();
        XdGuestUser xdGuestUser = guest;
        if (Intrinsics.areEqual((Object)detailsId, (Object)(xdGuestUser != null ? xdGuestUser.getUuid() : null))) {
            if (guest.getBanned() || !isGuestAllowed) {
                return null;
            }
            pair = TuplesKt.to((Object)guest, (Object)decoder2.decode(CookieHandler.Companion.getGUEST_SECRET()));
        } else {
            XdBaseUserDetails xdBaseUserDetails = (XdBaseUserDetails)XdBaseUserDetails.Companion.resolve(detailsId);
            if (xdBaseUserDetails == null) {
                return null;
            }
            XdBaseUserDetails details = xdBaseUserDetails;
            CookieHandler.CookieData data = decoder2.decode(details.generateSecret());
            pair = TuplesKt.to((Object)details.getUser(), (Object)data);
        }
        Pair pair2 = pair;
        XdBaseUser xdBaseUser = (XdBaseUser)pair2.component1();
        CookieHandler.CookieData data = (CookieHandler.CookieData)pair2.component2();
        if (data == null) {
            return null;
        }
        if (data.isExpired()) {
            return null;
        }
        Date date = new Date(data.getIssued());
        Date date2 = data.getExpiration().toDate();
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"data.expiration.toDate()");
        return new UserSession((XdBaseUser)loggedInUser, date, date2);
    }

    @NotNull
    public static final FrontendURLProvider getUrlProvider() {
        return (FrontendURLProvider)urlProvider$delegate.getValue(null, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URI getRedirectURL(@NotNull Error $receiver, @Nullable String clientId) {
        void var3_3;
        UriBuilder uriBuilder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        UriBuilder uriBuilder2 = UriBuilder.fromUri((URI)OAuthUtilKt.getUrlProvider().getErrorUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"UriBuilder.fromUri(urlProvider.errorUrl)");
        UriBuilder it = uriBuilder = UriBuilderUtilKt.copyParams(uriBuilder2, OAuthUtilKt.toParameterMap($receiver));
        URI uRI = (clientId != null ? it.queryParam("client_id", new Object[]{clientId}) : var3_3).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"UriBuilder.fromUri(urlPr\u2026it }\n            .build()");
        return uRI;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ URI getRedirectURL$default(Error error, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return OAuthUtilKt.getRedirectURL(error, string);
    }

    @NotNull
    public static final Map<String, String> toParameterMap(@NotNull Error $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object[] objectArray = new Pair[3];
        objectArray[0] = TuplesKt.to((Object)"error", (Object)$receiver.getError());
        objectArray[1] = TuplesKt.to((Object)"error_description", (Object)$receiver.getDescription());
        URI uRI = $receiver.getUri();
        objectArray[2] = TuplesKt.to((Object)"error_uri", (Object)(uRI != null ? uRI.toASCIIString() : null));
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)toParameterMap.1.INSTANCE));
    }
}

