/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.openidConnect.JsonWebKeySet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter;
import jetbrains.jetpass.oauth2.rest.security.SecurityContext;
import jetbrains.jetpass.oauth2.server.AuthHandler;
import jetbrains.jetpass.oauth2.server.AuthorizationCodeTokenHandler;
import jetbrains.jetpass.oauth2.server.ClientTokenHandler;
import jetbrains.jetpass.oauth2.server.Oauth2Resource$doGetUserInfo$user$1;
import jetbrains.jetpass.oauth2.server.OpenIDConnectUtilKt;
import jetbrains.jetpass.oauth2.server.RefreshTokenHandler;
import jetbrains.jetpass.oauth2.server.ResourceOwnerTokenHandler;
import jetbrains.jetpass.oauth2.server.TokenInfoUtilKt;
import jetbrains.jetpass.oauth2.server.UnsupportedTokenHandler;
import jetbrains.jetpass.rest.common.Transactional;
import jetbrains.jetpass.rest.dto.TokenInfoJSON;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/oauth2")
@Transactional
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\nH\u0007J\u0012\u0010\u0012\u001a\u00020\n2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\fH\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u0018\u001a\u00020\nH\u0007J\b\u0010\u0019\u001a\u00020\nH\u0007J\u001e\u0010\u001a\u001a\u00020\n2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Ljetbrains/jetpass/oauth2/server/Oauth2Resource;", "", "()V", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "Lkotlin/properties/ReadOnlyProperty;", "auth", "Ljavax/ws/rs/core/Response;", "responseType", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "doGetUserInfo", "getKey", "getKeys", "getOpenIDConfiguration", "uriInfo", "Ljavax/ws/rs/core/UriInfo;", "getTarget", "getTokenInfo", "Ljetbrains/jetpass/rest/dto/TokenInfoJSON;", "getUserInfoGET", "getUserInfoPOST", "token", "grantType", "jetbrains.jetpass.oauth2"})
public final class Oauth2Resource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty jetPass$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Oauth2Resource.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;"))};
    }

    @NotNull
    public final JetPassMainApp getJetPass() {
        return (JetPassMainApp)this.jetPass$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @GET
    @Path(value="/auth")
    @Produces(value={"text/html;charset=UTF-8"})
    @NotNull
    public final Response auth(@QueryParam(value="response_type") @Nullable String responseType, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return new AuthHandler().handle(request);
    }

    /*
     * Unable to fully structure code
     */
    @POST
    @Path(value="/token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response token(@FormParam(value="grant_type") @Nullable String grantType, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        v0 = grantType;
        if (v0 == null) ** GOTO lbl-1000
        var4_3 = v0;
        tmp = -1;
        switch (var4_3.hashCode()) {
            case -1432035435: {
                if (!var4_3.equals("refresh_token")) break;
                tmp = 1;
                break;
            }
            case 290069640: {
                if (!var4_3.equals("client_credentials")) break;
                tmp = 2;
                break;
            }
            case 1216985755: {
                if (!var4_3.equals("password")) break;
                tmp = 3;
                break;
            }
            case 1571154419: {
                if (!var4_3.equals("authorization_code")) break;
                tmp = 4;
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v1 = new ClientTokenHandler();
                break;
            }
            case 3: {
                v1 = new ResourceOwnerTokenHandler();
                break;
            }
            case 4: {
                v1 = new AuthorizationCodeTokenHandler();
                break;
            }
            case 1: {
                v1 = new RefreshTokenHandler();
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new UnsupportedTokenHandler();
            }
        }
        handler = v1;
        return handler.handle(request);
    }

    @GET
    @Path(value="/target")
    @Produces(value={"text/plain;charset=UTF-8"})
    @NotNull
    public final String getTarget() {
        return this.getJetPass().getDefaultServiceID();
    }

    @GET
    @Path(value="/key")
    @Produces(value={"text/plain;charset=UTF-8"})
    @NotNull
    public final String getKey() {
        return "" + XdKey.Companion.getDsaKey().getVersion() + '.' + XdKey.Companion.getDsaKey().getPublicKeyB64String();
    }

    @GET
    @Path(value="/keys")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getKeys() {
        Response response = Response.ok((Object)new JsonWebKeySet(CollectionsKt.listOf((Object)OpenIDConnectUtilKt.getJsonWebPublicKey())).toJsonString()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(JsonWebKeySe\u2026).toJsonString()).build()");
        return response;
    }

    @GET
    @Path(value="/token/info")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final TokenInfoJSON getTokenInfo(@Context @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return TokenInfoUtilKt.getTokenInfo(request);
    }

    @OAuth
    @GET
    @Path(value="/userinfo")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getUserInfoGET() {
        return this.doGetUserInfo();
    }

    @OAuth
    @POST
    @Path(value="/userinfo")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getUserInfoPOST() {
        return this.doGetUserInfo();
    }

    /*
     * WARNING - void declaration
     */
    private final Response doGetUserInfo() {
        XdBaseUser xdBaseUser;
        AuthorityHolder authHolder;
        SecurityContext securityContext = OAuthResourceFilter.Companion.getSecurityContext();
        if (securityContext == null) {
            Intrinsics.throwNpe();
        }
        AuthorityHolder authorityHolder = securityContext.getAuthorityHolder();
        if (authorityHolder == null) {
            Intrinsics.throwNpe();
        }
        if ((authHolder = authorityHolder) instanceof User) {
            KProperty1 it;
            void value$iv;
            void $receiver$iv;
            NodeBase nodeBase;
            KProperty1 kProperty1 = (KProperty1)Oauth2Resource$doGetUserInfo$user$1.INSTANCE;
            Comparable comparable = (Comparable)((Object)((User)authHolder).getId());
            XdQuery xdQuery = XdBaseUser.Companion.all();
            XdBaseUser user2 = (XdBaseUser)XdQueryKt.firstOrNull((XdQuery)xdQuery, (NodeBase)(nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdBaseUser.class)), (Comparable)value$iv)));
            xdBaseUser = user2;
            if (xdBaseUser == null || (xdBaseUser = Response.ok((Object)OpenIDConnectUtilKt.getUserInfo((XdBaseUser)(it = (kProperty1 = xdBaseUser))).toJsonString()).build()) == null) {
                throw (Throwable)new NotFoundException("User " + ((User)authHolder).getId() + " is not found");
            }
        } else {
            throw (Throwable)new BadRequestException("The authority holder is not a user");
        }
        return xdBaseUser;
    }

    @GET
    @Path(value="/.well-known/openid-configuration")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response getOpenIDConfiguration(@Context @NotNull UriInfo uriInfo) {
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        Response response = Response.ok((Object)OpenIDConnectUtilKt.getOpenIDConnectConfiguration(uriInfo).toJsonString()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(getOpenIDCon\u2026).toJsonString()).build()");
        return response;
    }

    public Oauth2Resource() {
        ReadOnlyProperty readOnlyProperty;
        Oauth2Resource oauth2Resource = this;
        String name$iv = null;
        oauth2Resource.jetPass$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }
}

