/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.openidConnect.AsymmetricKeySignatureCalculator;
import com.intellij.hub.auth.openidConnect.IdToken;
import com.intellij.hub.auth.openidConnect.JsonWebKey;
import com.intellij.hub.auth.openidConnect.OpenIDConfiguration;
import com.intellij.hub.auth.openidConnect.OpenidConnectUtilKt;
import com.intellij.hub.auth.openidConnect.RSAJsonWebPublicKey;
import com.intellij.hub.auth.openidConnect.SignatureCalculator;
import com.intellij.hub.auth.openidConnect.UserInfo;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.ws.rs.core.UriInfo;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.oauth2.server.Oauth2Resource;
import jetbrains.jetpass.oauth2.server.OpenIDConnectUtilKt;
import jetbrains.jetpass.oauth2.server.UserSession;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProfile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdKey;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u001a\b\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a8\u0006\u0015"}, d2={"getIdToken", "", "client", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "session", "Ljetbrains/jetpass/oauth2/server/UserSession;", "nonce", "accessToken", "code", "includeUserInfo", "", "getJsonWebPublicKey", "Lcom/intellij/hub/auth/openidConnect/JsonWebKey;", "getOpenIDConnectConfiguration", "Lcom/intellij/hub/auth/openidConnect/OpenIDConfiguration;", "uriInfo", "Ljavax/ws/rs/core/UriInfo;", "getUserInfo", "Lcom/intellij/hub/auth/openidConnect/UserInfo;", "user", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "jetbrains.jetpass.oauth2"})
public final class OpenIDConnectUtilKt {
    @NotNull
    public static final String getIdToken(@NotNull XdService client, @NotNull UserSession session2, @Nullable String nonce, @Nullable String accessToken, @Nullable String code, boolean includeUserInfo) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        getIdToken.1 half$ = getIdToken.1.INSTANCE;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        Function1<String, String> halfHash$ = new Function1<String, String>(md){
            final /* synthetic */ MessageDigest $md;

            @NotNull
            public final String invoke(@NotNull String $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                this.$md.reset();
                String string = $receiver;
                Charset charset = Charsets.US_ASCII;
                MessageDigest messageDigest = this.$md;
                getIdToken.1 var4_5 = getIdToken.1.INSTANCE;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                byte[] byArray3 = messageDigest.digest(byArray2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"md.digest(toByteArray(Charsets.US_ASCII))");
                return OpenidConnectUtilKt.toBase64URL((byte[])var4_5.invoke(byArray3));
            }
            {
                this.$md = messageDigest;
                super(1);
            }
        };
        XdBaseUser user2 = session2.getUser();
        UserInfo userInfo = includeUserInfo ? OpenIDConnectUtilKt.getUserInfo(user2) : new UserInfo(user2.getUuid(), null, null, null, null, null, null, 126, null);
        URI uRI = OAuthUtilKt.getUrlProvider().getAbsoluteFrontEndURL().toURI();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"urlProvider.absoluteFrontEndURL.toURI()");
        String string = accessToken;
        String string2 = code;
        IdToken idToken = new IdToken(userInfo, uRI, new String[]{client.getUuid()}, session2.getExpirationTime(), new Date(), session2.getAuthenticationTime(), nonce, string != null ? halfHash$.invoke(string) : null, string2 != null ? halfHash$.invoke(string2) : null);
        XdKey key = XdKey.Companion.getRsaKey();
        AsymmetricKeySignatureCalculator signatureCalculator = new AsymmetricKeySignatureCalculator("RS256", String.valueOf(key.getVersion()), "SHA256withRSA", key.getPrivateKey());
        return idToken.signAndEncode((SignatureCalculator)signatureCalculator);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getIdToken$default(XdService xdService, UserSession userSession, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return OpenIDConnectUtilKt.getIdToken(xdService, userSession, string, string2, string3, bl);
    }

    @NotNull
    public static final UserInfo getUserInfo(@NotNull XdBaseUser user2) {
        XdProfile xdProfile;
        XdProfile xdProfile2;
        URI uRI;
        UserInfo userInfo;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        XdProfile profile = user2 instanceof XdUser ? ((XdUser)user2).getProfile() : null;
        UserInfo userInfo2 = userInfo;
        UserInfo userInfo3 = userInfo;
        String string = user2.getUuid();
        String string2 = user2.getVisibleName();
        String string3 = user2.getLogin();
        URI uRI2 = OAuthUtilKt.getUrlProvider().getProfileURL(user2.getUuid()).toURI();
        Object object = profile;
        if (object != null && (object = object.getAvatar()) != null && (object = object.getAvatarURL(null, null)) != null) {
            Object object2 = object;
            URI uRI3 = uRI2;
            String string4 = string3;
            String string5 = string2;
            String string6 = string;
            UserInfo userInfo4 = userInfo2;
            UserInfo userInfo5 = userInfo3;
            Object p1 = object2;
            URI uRI4 = new URI((String)p1);
            userInfo3 = userInfo5;
            userInfo2 = userInfo4;
            string = string6;
            string2 = string5;
            string3 = string4;
            uRI2 = uRI3;
            uRI = uRI4;
        } else {
            uRI = null;
        }
        userInfo2(string, string2, string3, uRI2, uRI, (xdProfile2 = profile) != null && (xdProfile2 = xdProfile2.getEmail()) != null ? xdProfile2.getEmail() : null, (xdProfile = profile) != null && (xdProfile = xdProfile.getEmail()) != null ? Boolean.valueOf(xdProfile.getVerified()) : null);
        return userInfo3;
    }

    @NotNull
    public static final JsonWebKey getJsonWebPublicKey() {
        XdKey keyPair = XdKey.Companion.getRsaKey();
        PublicKey publicKey = keyPair.getPublicKey();
        if (publicKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        RSAPublicKey publicKey2 = (RSAPublicKey)publicKey;
        String string = String.valueOf(keyPair.getVersion());
        BigInteger bigInteger = publicKey2.getModulus();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"publicKey.modulus");
        BigInteger bigInteger2 = publicKey2.getPublicExponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"publicKey.publicExponent");
        return (JsonWebKey)new RSAJsonWebPublicKey("sig", "RS256", string, bigInteger, bigInteger2);
    }

    @NotNull
    public static final OpenIDConfiguration getOpenIDConnectConfiguration(@NotNull UriInfo uriInfo) {
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        Function1 getURI$ = new Function1<KFunction<?>, URI>(uriInfo){
            final /* synthetic */ UriInfo $uriInfo;

            public final URI invoke(@NotNull KFunction<?> property) {
                Intrinsics.checkParameterIsNotNull(property, (String)"property");
                return this.$uriInfo.getBaseUriBuilder().path(Oauth2Resource.class).path(ReflectJvmMapping.getJavaMethod(property)).build(new Object[0]);
            }
            {
                this.$uriInfo = uriInfo;
                super(1);
            }
        };
        URI uRI = OAuthUtilKt.getUrlProvider().getAbsoluteFrontEndURL().toURI();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"urlProvider.absoluteFrontEndURL.toURI()");
        URI uRI2 = getURI$.invoke((KFunction<?>)getOpenIDConnectConfiguration.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"getURI(Oauth2Resource::auth)");
        URI uRI3 = getURI$.invoke((KFunction<?>)getOpenIDConnectConfiguration.3.INSTANCE);
        URI uRI4 = getURI$.invoke((KFunction<?>)getOpenIDConnectConfiguration.4.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI4, (String)"getURI(Oauth2Resource::getUserInfoGET)");
        URI uRI5 = getURI$.invoke((KFunction<?>)getOpenIDConnectConfiguration.5.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI5, (String)"getURI(Oauth2Resource::getKeys)");
        return new OpenIDConfiguration(uRI, uRI2, uRI3, uRI4, uRI5, SetsKt.setOf((Object[])new String[]{"openid", "profile", "email"}), SetsKt.setOf((Object[])new String[]{"code", "token", "id_token"}), null, SetsKt.setOf((Object[])new String[]{"authorization_code", "client_credentials", "password", "refresh_token", "implicit"}), SetsKt.setOf((Object)"public"), SetsKt.setOf((Object)"RS256"), SetsKt.setOf((Object[])new String[]{"client_secret_basic", "client_secret_post"}), SetsKt.setOf((Object[])new String[]{"sub", "name", "preferred_username", "profile", "picture", "email", "email_verified"}), "https://www.jetbrains.com/help/hub/Managing-Services.html", Boolean.valueOf(false), 128, null);
    }
}

