/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.OAuthTokenValidationException;
import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jetbrains.jetpass.oauth2.server.AccessTokenIssuer;
import jetbrains.jetpass.oauth2.server.RequestType;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt;
import jetbrains.jetpass.oauth2.server.TokenHandler;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdRefreshToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ljetbrains/jetpass/oauth2/server/RefreshTokenHandler;", "Ljetbrains/jetpass/oauth2/server/TokenHandler;", "()V", "refreshToken", "Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdRefreshToken;", "Ljavax/servlet/http/HttpServletRequest;", "getRefreshToken", "(Ljavax/servlet/http/HttpServletRequest;)Ljetbrains/jetpass/userManagement/persistence/dnq/oauth/XdRefreshToken;", "issue", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "request", "jetbrains.jetpass.oauth2"})
public final class RefreshTokenHandler
extends TokenHandler {
    @Override
    @NotNull
    protected AccessToken issue(@NotNull HttpServletRequest request) throws OAuthValidationException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        XdRefreshToken refresh = this.getRefreshToken(request);
        XdService client = RequestValidatorKt.authenticateClientFromHeader(request);
        if (Intrinsics.areEqual((Object)refresh.getClient(), (Object)client) ^ true) {
            throw (Throwable)OAuthTokenValidationException.Companion.wrongClient();
        }
        Set<XdService> scopes = RequestValidatorKt.getScope(request, RequestType.TOKEN, (XdBaseUser)refresh.getUser(), false);
        if (!refresh.matches((Iterable)scopes)) {
            throw (Throwable)OAuthTokenValidationException.Companion.inaccessibleScope();
        }
        if (refresh.getUser().getBanned()) {
            throw (Throwable)OAuthTokenValidationException.Companion.bannedUser();
        }
        refresh.access();
        return AccessTokenIssuer.issue$default(this.getTokenIssuer(), refresh.getClient(), (XdBaseUser)refresh.getUser(), scopes.isEmpty() ? (Collection)SequencesKt.toList((Sequence)XdQueryKt.asSequence((XdQuery)((XdQuery)refresh.getScope()))) : (Collection)scopes, null, 8, null);
    }

    @NotNull
    public final XdRefreshToken getRefreshToken(@NotNull HttpServletRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String token = RequestValidatorKt.getRequiredParameter($receiver, "refresh_token", RequestType.TOKEN);
        XdRefreshToken xdRefreshToken = XdRefreshToken.Companion.getAccessToken(token);
        if (xdRefreshToken == null) {
            throw (Throwable)OAuthTokenValidationException.Companion.unknownRefreshToken();
        }
        return xdRefreshToken;
    }
}

