/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.InvalidAuthorizationHeaderException;
import com.intellij.hub.auth.InvalidTokenDataException;
import com.intellij.hub.auth.InvalidTokenScopeException;
import com.intellij.hub.auth.OAuthClientValidationException;
import com.intellij.hub.auth.OAuthTokenValidationException;
import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.token.ScopeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.oauth2.server.RequestType;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt$authenticateClientFromQuery$clientService$1;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt$authenticateService$service$1;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt$getRedirectUris$clientService$1;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt$getScopeServices$1;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt$getScopeServices$scopeServices$2$serviceByUUID$1;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt$getScopeServices$scopeServices$2$servicesByAppName$1;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u000f*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u000f*\u00020\u0019\u001a\f\u0010\u001b\u001a\u00020\u000f*\u00020\u001cH\u0000\u001a\f\u0010\u001d\u001a\u00020\u001c*\u00020\u0019H\u0000\u001a\u0010\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e*\u00020\u0019\u001a\u0012\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0013*\u00020\u0019\u001a\u001a\u0010 \u001a\u00020\u0002*\u00020\u00192\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e*\u00020\u0019\u001a*\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010$\u001a\u00020\u0017\u001a \u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013*\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0017\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006&"}, d2={"KNOWN_PROMPTS", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "KNOWN_RESPONSE_TYPES", "SPACE_DELIMITER", "Lkotlin/text/Regex;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getScopeServices", "", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "requestType", "Ljetbrains/jetpass/oauth2/server/RequestType;", "scopes", "", "user", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "ignoreUnknown", "", "authenticateClientFromHeader", "Ljavax/servlet/http/HttpServletRequest;", "authenticateClientFromQuery", "authenticateService", "Lcom/intellij/hub/auth/basic/BasicAuthToken;", "getBasicAuthToken", "getPromptParameter", "getRedirectUris", "getRequiredParameter", "name", "getResponseTypeParameter", "getScope", "required", "getScopeParameter", "jetbrains.jetpass.oauth2"})
public final class RequestValidatorKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final HashSet<String> KNOWN_RESPONSE_TYPES;
    private static final HashSet<String> KNOWN_PROMPTS;
    private static final Regex SPACE_DELIMITER;
    private static final ReadOnlyProperty jetPass$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(RequestValidatorKt.class, (String)"jetbrains.jetpass.oauth2"), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;"))};
        KNOWN_RESPONSE_TYPES = SetsKt.hashSetOf((Object[])new String[]{"token", "id_token", "code"});
        KNOWN_PROMPTS = SetsKt.hashSetOf((Object[])new String[]{"none", "login", "consent", "select_account"});
        SPACE_DELIMITER = new Regex(" +");
        String name$iv = null;
        jetPass$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final String getRequiredParameter(@NotNull HttpServletRequest $receiver, @NotNull String name, @NotNull RequestType requestType) throws OAuthValidationException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)((Object)requestType), (String)"requestType");
        String value = $receiver.getParameter(name);
        if (value == null || value.length() == 0) {
            throw (Throwable)requestType.missingParameter(name);
        }
        return value;
    }

    @NotNull
    public static final XdService authenticateClientFromHeader(@NotNull HttpServletRequest $receiver) throws OAuthValidationException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return RequestValidatorKt.authenticateService(RequestValidatorKt.getBasicAuthToken($receiver));
    }

    @NotNull
    public static final BasicAuthToken getBasicAuthToken(@NotNull HttpServletRequest $receiver) throws OAuthValidationException {
        String string;
        block9: {
            String string2;
            block8: {
                BasicAuthToken basicAuthToken;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                string = $receiver.getHeader("Authorization");
                if (string == null) break block8;
                String it = string2 = string;
                try {
                    basicAuthToken = BasicAuthToken.Companion.decodeHeader(it);
                }
                catch (InvalidAuthorizationHeaderException e) {
                    throw (Throwable)OAuthTokenValidationException.Companion.invalidAuthHeader((Throwable)e);
                }
                catch (InvalidTokenDataException e) {
                    throw (Throwable)OAuthTokenValidationException.Companion.invalidAuthHeader((Throwable)e);
                }
                BasicAuthToken basicAuthToken2 = basicAuthToken;
                string = basicAuthToken2;
                if (basicAuthToken2 != null) break block9;
            }
            String $receiver2 = string2 = $receiver;
            String string3 = $receiver2.getParameter("client_id");
            if (string3 == null) {
                throw (Throwable)OAuthTokenValidationException.Companion.missingAuthHeader();
            }
            String clientId = string3;
            String string4 = $receiver2.getParameter("client_secret");
            if (string4 == null) {
                string4 = "";
            }
            String clientSecret = string4;
            string = new BasicAuthToken(clientId, clientSecret);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final XdService authenticateService(@NotNull BasicAuthToken $receiver) throws OAuthValidationException, OAuthValidationException {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String clientServiceId = $receiver.getUsername();
        String clientSecret = $receiver.getPassword();
        KProperty1 kProperty1 = (KProperty1)RequestValidatorKt$authenticateService$service$1.INSTANCE;
        XdQuery xdQuery = XdService.Companion.all();
        NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)((Comparable)((Object)clientServiceId)));
        XdService xdService = (XdService)XdQueryKt.firstOrNull((XdQuery)xdQuery, (NodeBase)nodeBase);
        if (xdService == null) {
            throw (Throwable)OAuthTokenValidationException.Companion.unknownService(clientServiceId);
        }
        XdService service2 = xdService;
        if (!service2.isValidSecret(clientSecret)) {
            throw (Throwable)OAuthTokenValidationException.Companion.invalidServiceSecret();
        }
        return service2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final XdService authenticateClientFromQuery(@NotNull HttpServletRequest $receiver) throws OAuthValidationException {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String redirectUri = $receiver.getParameter("redirect_uri");
        String clientId = RequestValidatorKt.getRequiredParameter($receiver, "client_id", RequestType.AUTH);
        Object object = (KProperty1)RequestValidatorKt$authenticateClientFromQuery$clientService$1.INSTANCE;
        XdQuery xdQuery = XdService.Companion.all();
        NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)((Comparable)((Object)clientId)));
        XdService xdService = (XdService)XdQueryKt.firstOrNull((XdQuery)xdQuery, (NodeBase)nodeBase);
        if (xdService == null) {
            throw (Throwable)OAuthClientValidationException.Companion.unknownService(clientId);
        }
        XdService clientService2 = xdService;
        if (CollectionsKt.none((Iterable)clientService2.getRedirectURIs())) {
            String string = clientService2.getName();
            String string2 = redirectUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"redirectUri");
            throw (Throwable)OAuthClientValidationException.Companion.serviceHasNoRedirectURI(string, string2);
        }
        object = redirectUri;
        if (object == null || object.length() == 0) {
            return clientService2;
        }
        if (!clientService2.matchesRedirectUri(redirectUri)) {
            String string = redirectUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"redirectUri");
            clientService2.addUntrustedRedirectUri(string, $receiver.getRemoteAddr(), Calendar.getInstance());
            throw (Throwable)OAuthClientValidationException.Companion.unregisteredRedirectURI(clientService2.getName(), redirectUri);
        }
        return clientService2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> getRedirectUris(@NotNull HttpServletRequest $receiver) {
        List list;
        Object $i$f$eq;
        void $receiver$iv;
        String string;
        String it;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string2 = $receiver.getParameter("client_id");
        if (string2 == null || (string2 = (charSequence = (CharSequence)(it = (string = string2))).length() > 0 ? string : null) == null) {
            return null;
        }
        String clientId = string2;
        it = (KProperty1)RequestValidatorKt$getRedirectUris$clientService$1.INSTANCE;
        Object object = XdService.Companion.all();
        Object object2 = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)((Comparable)((Object)clientId)));
        XdService xdService = (XdService)XdQueryKt.firstOrNull((XdQuery)object, (NodeBase)object2);
        if (xdService == null) {
            return null;
        }
        XdService clientService2 = xdService;
        if (!clientService2.getTrusted()) {
            return null;
        }
        String redirectUri = $receiver.getParameter("redirect_uri");
        if (redirectUri != null && ($i$f$eq = (CharSequence)redirectUri).length() > 0) {
            list = clientService2.matchesRedirectUri(redirectUri) ? CollectionsKt.listOf((Object)redirectUri) : null;
        } else {
            URI it2;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv2;
            $i$f$eq = clientService2.getAllRedirectUris();
            void $i$a$1$takeIf = $receiver$iv2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it2 = (URI)element$iv$iv;
                if (!it2.isAbsolute()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv2 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it2 = (URI)item$iv$iv;
                object = destination$iv$iv;
                object2 = it2.toASCIIString();
                object.add(object2);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public static final Set<String> getResponseTypeParameter(@NotNull HttpServletRequest $receiver) {
        HashSet responseType;
        block9: {
            String rawResponseType;
            block8: {
                boolean bl;
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    rawResponseType = RequestValidatorKt.getRequiredParameter($receiver, "response_type", RequestType.AUTH);
                    CharSequence charSequence = rawResponseType;
                    Regex regex = SPACE_DELIMITER;
                    int n = 0;
                    responseType = CollectionsKt.toHashSet((Iterable)regex.split(charSequence, n));
                    if (responseType.isEmpty()) break block8;
                    Iterable $receiver$iv = responseType;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            if (!(!KNOWN_RESPONSE_TYPES.contains(it))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            throw (Throwable)OAuthClientValidationException.Companion.invalidResponseType(rawResponseType);
        }
        return responseType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Set<String> getPromptParameter(@NotNull HttpServletRequest $receiver) {
        Set set;
        int n;
        Object object;
        Regex regex;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object2 = $receiver.getParameter("prompt");
        if (object2 != null && (object2 = (regex = SPACE_DELIMITER).split((CharSequence)(object = (CharSequence)object2), n = 0)) != null && (object2 = CollectionsKt.toHashSet((Iterable)((Iterable)object2))) != null) {
            boolean bl;
            block7: {
                Iterable $receiver$iv;
                object = object2;
                Object $receiver2 = object;
                if (((HashSet)$receiver2).isEmpty()) throw (Throwable)OAuthClientValidationException.Companion.invalidParameter("prompt");
                if (((HashSet)$receiver2).contains("none")) {
                    if (((HashSet)$receiver2).size() != 1) throw (Throwable)OAuthClientValidationException.Companion.invalidParameter("prompt");
                }
                if (($receiver$iv = (Iterable)$receiver2) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!(!KNOWN_PROMPTS.contains(it))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw (Throwable)OAuthClientValidationException.Companion.invalidParameter("prompt");
            }
            object2 = object;
            if (object2 != null) {
                set = (Set)object2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    @NotNull
    public static final Set<XdService> getScope(@NotNull HttpServletRequest $receiver, @NotNull RequestType requestType, @Nullable XdBaseUser user2, boolean required) throws OAuthValidationException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)requestType), (String)"requestType");
        List<String> scopes = RequestValidatorKt.getScopeParameter($receiver, requestType, required);
        return RequestValidatorKt.getScopeServices$default(requestType, scopes, user2, false, 8, null);
    }

    @NotNull
    public static final List<String> getScopeParameter(@NotNull HttpServletRequest $receiver, @NotNull RequestType requestType, boolean required) throws OAuthValidationException {
        List list;
        String scope;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)requestType), (String)"requestType");
        String string = scope = required ? RequestValidatorKt.getRequiredParameter($receiver, "scope", requestType) : $receiver.getParameter("scope");
        if (scope != null && scope.length() > 0) {
            List list2;
            try {
                list2 = StringsKt.split$default((CharSequence)scope, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
            }
            catch (InvalidTokenScopeException ex) {
                throw (Throwable)requestType.invalidScope(ex);
            }
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final JetPassMainApp getJetPass() {
        return (JetPassMainApp)jetPass$delegate.getValue(null, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final Set<XdService> getScopeServices(@NotNull RequestType requestType, @NotNull List<String> scopes, @Nullable XdBaseUser user2, boolean ignoreUnknown) throws OAuthValidationException {
        Set set;
        String string;
        Collection collection;
        Object $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)requestType), (String)"requestType");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Iterable iterable = $receiver$iv = (Iterable)scopes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            string = ScopeUtil.INSTANCE.decode((String)it);
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            List list;
            void $receiver$iv2;
            NodeBase nodeBase;
            Object element$iv$iv = iterator.next();
            String scope = (String)element$iv$iv;
            KProperty1 $i$a$1$map = (KProperty1)RequestValidatorKt$getScopeServices$scopeServices$2$serviceByUUID$1.INSTANCE;
            XdQuery xdQuery = XdService.Companion.all();
            XdService serviceByUUID2 = (XdService)XdQueryKt.firstOrNull((XdQuery)xdQuery, (NodeBase)(nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv2, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)((Comparable)((Object)scope)))));
            if (serviceByUUID2 != null) {
                if (user2 != null && !serviceByUUID2.isLicensedFor(user2)) {
                    throw (Throwable)requestType.unlicensedScope(serviceByUUID2.getName());
                }
                list = CollectionsKt.listOf((Object)serviceByUUID2);
            } else {
                List licensedServices;
                List list2;
                void $receiver$iv3;
                KProperty1 $i$f$eq = (KProperty1)RequestValidatorKt$getScopeServices$scopeServices$2$servicesByAppName$1.INSTANCE;
                xdQuery = XdService.Companion.all();
                nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv3, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)((Comparable)((Object)scope)));
                List servicesByAppName2 = XdQueryKt.toList((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase));
                if (user2 != null) {
                    void $receiver$iv$iv2;
                    Iterable $receiver$iv4;
                    Iterable iterable2 = $receiver$iv4 = (Iterable)servicesByAppName2;
                    Collection destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        XdService it = (XdService)element$iv$iv2;
                        if (!it.isLicensedFor(user2)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = servicesByAppName2;
                }
                list = licensedServices = list2;
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List scopeServices2 = (List)destination$iv$iv;
        if (CollectionsKt.none((Iterable)scopeServices2) && CollectionsKt.any((Iterable)scopes)) {
            void value$iv;
            if (!ignoreUnknown) throw (Throwable)requestType.unknownScope(scopes);
            $receiver$iv = (KProperty1)RequestValidatorKt$getScopeServices$1.INSTANCE;
            $receiver$iv$iv = (Comparable)((Object)RequestValidatorKt.getJetPass().getDefaultServiceID());
            collection = XdService.Companion.all();
            string = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)value$iv);
            set = SetsKt.setOf((Object)XdQueryKt.first((XdQuery)collection, (NodeBase)string));
            return set;
        } else {
            set = CollectionsKt.toSet((Iterable)scopeServices2);
        }
        return set;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Set getScopeServices$default(RequestType requestType, List list, XdBaseUser xdBaseUser, boolean bl, int n, Object object) throws OAuthValidationException {
        if ((n & 8) != 0) {
            bl = false;
        }
        return RequestValidatorKt.getScopeServices(requestType, list, xdBaseUser, bl);
    }
}

