/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.OAuthTokenValidationException;
import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.RefreshToken;
import com.intellij.hub.auth.request.AuthRequestParameter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.auth.module.dnq.authentication.SecondFactorRequiredException;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.oauth2.server.AccessTokenIssuer;
import jetbrains.jetpass.oauth2.server.OAuthParametersKt;
import jetbrains.jetpass.oauth2.server.RequestType;
import jetbrains.jetpass.oauth2.server.RequestValidatorKt;
import jetbrains.jetpass.oauth2.server.ResourceOwnerTokenHandler;
import jetbrains.jetpass.oauth2.server.TokenHandler;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEmailContact;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProfile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPublicSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdRefreshToken;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/oauth2/server/ResourceOwnerTokenHandler;", "Ljetbrains/jetpass/oauth2/server/TokenHandler;", "()V", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "hubPrincipalManager$delegate", "issue", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "request", "Ljavax/servlet/http/HttpServletRequest;", "authenticateUser", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "clientId", "", "jetbrains.jetpass.oauth2"})
public final class ResourceOwnerTokenHandler
extends TokenHandler {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty daoContainer$delegate;
    @NotNull
    private final ReadOnlyProperty hubPrincipalManager$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ResourceOwnerTokenHandler.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ResourceOwnerTokenHandler.class), "hubPrincipalManager", "getHubPrincipalManager()Ljetbrains/jetpass/service/api/HubPrincipalManager;"))};
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final HubPrincipalManager getHubPrincipalManager() {
        return (HubPrincipalManager)this.hubPrincipalManager$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    @NotNull
    protected AccessToken issue(@NotNull HttpServletRequest request) throws OAuthValidationException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        XdService client = RequestValidatorKt.authenticateClientFromHeader(request);
        XdBaseUser user2 = this.authenticateUser(request, client.getUuid());
        Set<XdService> scopes = RequestValidatorKt.getScope(request, RequestType.TOKEN, user2, true);
        AccessToken accessToken = AccessTokenIssuer.issue$default(this.getTokenIssuer(), client, user2, scopes, null, 8, null);
        AuthRequestParameter.AccessType accessType2 = OAuthParametersKt.getAccessType(request);
        return accessType2 == AuthRequestParameter.AccessType.OFFLINE ? (AccessToken)new RefreshToken(accessToken, XdRefreshToken.Companion.emit(user2, client, (Iterable)scopes)) : accessToken;
    }

    private final XdBaseUser authenticateUser(@NotNull HttpServletRequest $receiver, String clientId) {
        User user2;
        String username = RequestValidatorKt.getRequiredParameter($receiver, "username", RequestType.TOKEN);
        String password = RequestValidatorKt.getRequiredParameter($receiver, "password", RequestType.TOKEN);
        try {
            DnqUtils.getCurrentTransientSession().flush();
            user2 = this.getDaoContainer().getAuthModuleDAO().loginUser(username, password, clientId, $receiver.getHeader(ServletRequestCredentials.Companion.getUSER_AGENT_HEADER()), $receiver.getRemoteAddr(), false);
            user2 = (XdBaseUser)XdBaseUser.Companion.resolve(user2.getId());
        }
        catch (SecondFactorRequiredException ex) {
            throw (Throwable)OAuthTokenValidationException.Companion.twoFactorAuthenticationRequired();
        }
        catch (DataAccessException ex) {
            DataAccessExceptionUtilKt.logError((KLogger)this.getLogger(), (DataAccessException)ex, (Function0)authenticateUser.user.1.INSTANCE);
            user2 = null;
        }
        User user3 = user2;
        if (user3 != null) {
            XdPublicSettings.Companion this_$iv = XdPublicSettings.Companion;
            if (((XdPublicSettings)XdPublicSettings.Companion.getInstance()).getEmailVerificationRequired() && !user3.isAdmin()) {
                XdEmailContact email$iv;
                XdProfile xdProfile = user3.getProfile();
                Object object = email$iv = xdProfile != null ? xdProfile.getEmail() : null;
                if (email$iv != null && !email$iv.getVerified()) {
                    String it = email$iv.getEmail();
                    throw (Throwable)OAuthTokenValidationException.Companion.userEmailIsNotVerified();
                }
            }
        }
        User user4 = user3;
        if (user4 == null) {
            throw (Throwable)OAuthTokenValidationException.Companion.invalidCredentials();
        }
        return user4;
    }

    public ResourceOwnerTokenHandler() {
        ReadOnlyProperty readOnlyProperty;
        ResourceOwnerTokenHandler resourceOwnerTokenHandler = this;
        String name$iv = null;
        resourceOwnerTokenHandler.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        resourceOwnerTokenHandler = this;
        name$iv = null;
        resourceOwnerTokenHandler.hubPrincipalManager$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }
}

