/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.OAuthValidationException;
import com.intellij.hub.auth.oauth2.error.OAuthTokenErrorCode;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.core.Error;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.oauth2.server.AccessTokenIssuer;
import jetbrains.jetpass.oauth2.server.OAuth2RequestHandler;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.rest.common.ExceptionExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH$R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ljetbrains/jetpass/oauth2/server/TokenHandler;", "Ljetbrains/jetpass/oauth2/server/OAuth2RequestHandler;", "()V", "tokenIssuer", "Ljetbrains/jetpass/oauth2/server/AccessTokenIssuer;", "getTokenIssuer", "()Ljetbrains/jetpass/oauth2/server/AccessTokenIssuer;", "setTokenIssuer", "(Ljetbrains/jetpass/oauth2/server/AccessTokenIssuer;)V", "handleOAuthError", "Ljavax/ws/rs/core/Response;", "error", "Lcom/intellij/hub/core/Error;", "request", "Ljavax/servlet/http/HttpServletRequest;", "handleOAuthRequest", "issue", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "Companion", "jetbrains.jetpass.oauth2"})
public abstract class TokenHandler
extends OAuth2RequestHandler {
    @NotNull
    private AccessTokenIssuer tokenIssuer = new AccessTokenIssuer();
    private static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final AccessTokenIssuer getTokenIssuer() {
        return this.tokenIssuer;
    }

    protected final void setTokenIssuer(@NotNull AccessTokenIssuer accessTokenIssuer) {
        Intrinsics.checkParameterIsNotNull((Object)accessTokenIssuer, (String)"<set-?>");
        this.tokenIssuer = accessTokenIssuer;
    }

    @Override
    @NotNull
    protected Response handleOAuthRequest(@NotNull HttpServletRequest request) throws OAuthValidationException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        AccessToken token = this.issue(request);
        Response response = TokenHandler.Companion.jsonResponse(Response.Status.OK, OAuthUtilKt.toJSON(token)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"jsonResponse(Response.St\u2026, token.toJSON()).build()");
        return response;
    }

    @NotNull
    protected abstract AccessToken issue(@NotNull HttpServletRequest var1) throws OAuthValidationException;

    @Override
    @NotNull
    protected Response handleOAuthError(@NotNull Error error, @NotNull HttpServletRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response.ResponseBuilder builder = Intrinsics.areEqual((Object)error.getError(), (Object)OAuthTokenErrorCode.INVALID_CLIENT.getAsciiCode()) ? TokenHandler.Companion.jsonResponse(Response.Status.UNAUTHORIZED, ExceptionExtKt.toJSON((Error)error)).header(AUTHENTICATE_HEADER, (Object)"Basic realm=\"JetPass service\"") : TokenHandler.Companion.jsonResponse(Response.Status.BAD_REQUEST, ExceptionExtKt.toJSON((Error)error));
        Response response = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"builder.build()");
        return response;
    }

    static {
        AUTHENTICATE_HEADER = AUTHENTICATE_HEADER;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/oauth2/server/TokenHandler$Companion;", "", "()V", "AUTHENTICATE_HEADER", "", "jsonResponse", "Ljavax/ws/rs/core/Response$ResponseBuilder;", "status", "Ljavax/ws/rs/core/Response$Status;", "entity", "jetbrains.jetpass.oauth2"})
    public static final class Companion {
        private final Response.ResponseBuilder jsonResponse(Response.Status status, Object entity) {
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity(entity).type("application/json;charset=UTF-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.status(status).\u2026y(entity).type(JSON_UTF8)");
            return responseBuilder;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

