/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.server;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.TokenVerification;
import com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.GuestToken;
import com.intellij.hub.auth.oauth2.token.PermanentToken;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotAuthorizedException;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.auth.module.dnq.metrics.AuthMetrics;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.DefaultDSAPublicKeySource;
import jetbrains.jetpass.oauth2.server.TokenInfoUtilKt;
import jetbrains.jetpass.rest.dto.TokenInfoJSON;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.UtilsKt;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdPermanentToken;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"authMetrics", "Ljetbrains/jetpass/auth/module/dnq/metrics/AuthMetrics;", "getAuthMetrics", "()Ljetbrains/jetpass/auth/module/dnq/metrics/AuthMetrics;", "authMetrics$delegate", "Lkotlin/properties/ReadOnlyProperty;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "tokenInfo", "Ljetbrains/jetpass/rest/dto/TokenInfoJSON;", "Ljavax/servlet/http/HttpServletRequest;", "getTokenInfo", "(Ljavax/servlet/http/HttpServletRequest;)Ljetbrains/jetpass/rest/dto/TokenInfoJSON;", "jetbrains.jetpass.oauth2"})
public final class TokenInfoUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final ReadOnlyProperty jetPass$delegate;
    private static final ReadOnlyProperty authMetrics$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(TokenInfoUtilKt.class, (String)"jetbrains.jetpass.oauth2"), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;")), (KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(TokenInfoUtilKt.class, (String)"jetbrains.jetpass.oauth2"), "authMetrics", "getAuthMetrics()Ljetbrains/jetpass/auth/module/dnq/metrics/AuthMetrics;"))};
        String name$iv = null;
        jetPass$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
        name$iv = null;
        authMetrics$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    private static final JetPassMainApp getJetPass() {
        return (JetPassMainApp)jetPass$delegate.getValue(null, $$delegatedProperties[0]);
    }

    private static final AuthMetrics getAuthMetrics() {
        return (AuthMetrics)authMetrics$delegate.getValue(null, $$delegatedProperties[1]);
    }

    @NotNull
    public static final TokenInfoJSON getTokenInfo(@NotNull HttpServletRequest $receiver) {
        TokenInfoJSON tokenInfoJSON;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String authorizationHeader = $receiver.getHeader("Authorization");
        if (AccessToken.Companion.isBearer(authorizationHeader)) {
            if (GuestToken.isGuestTokenHeader((String)authorizationHeader)) {
                tokenInfoJSON = (TokenInfoJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)tokenInfo.1.INSTANCE, (int)7, null);
            } else if (PermanentToken.Companion.isPermanentTokenHeader(authorizationHeader)) {
                TokenInfoUtilKt.getAuthMetrics().incPermanentTokenClientsUsage();
                String string = authorizationHeader;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authorizationHeader");
                PermanentToken permanentToken = PermanentToken.Companion.decodeHeader(string);
                tokenInfoJSON = (TokenInfoJSON)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, TokenInfoJSON>(permanentToken){
                    final /* synthetic */ PermanentToken $permanentToken;

                    @NotNull
                    public final TokenInfoJSON invoke(@NotNull TransientStoreSession it) {
                        TokenInfoJSON tokenInfoJSON;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        XdPermanentToken xdPermanentToken = XdPermanentToken.Companion.find(this.$permanentToken.getSecret());
                        if (xdPermanentToken == null) {
                            throw (Throwable)InvalidTokenException.Companion.invalidPermanentToken();
                        }
                        XdPermanentToken dbToken = xdPermanentToken;
                        TokenInfoJSON $receiver = tokenInfoJSON = new TokenInfoJSON();
                        $receiver.setId(UtilsKt.getPersistentID((XdEntity)((XdEntity)dbToken)));
                        $receiver.setClient(TokenInfoUtilKt.access$getJetPass$p().getDefaultServiceID());
                        $receiver.setUser(dbToken.getUser().getUuid());
                        $receiver.setScope((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)((XdQuery)dbToken.getScope())), (Function1)tokenInfo.1.1.INSTANCE)));
                        return tokenInfoJSON;
                    }
                    {
                        this.$permanentToken = permanentToken;
                        super(1);
                    }
                }), (int)7, null);
            } else {
                TokenInfoJSON tokenInfoJSON2;
                String string = authorizationHeader;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authorizationHeader");
                AccessToken accessToken = AccessToken.Companion.decodeHeader(string);
                TokenVerification.verifyExpiration((AccessToken)accessToken);
                TokenVerification.verifySignature((AccessToken)accessToken, (DSAPublicKeySource)((DSAPublicKeySource)DefaultDSAPublicKeySource.INSTANCE));
                TokenInfoJSON $receiver2 = tokenInfoJSON2 = new TokenInfoJSON();
                $receiver2.setClient(accessToken.getClient());
                $receiver2.setUser(accessToken.getUser());
                $receiver2.setScope((Iterable)ArraysKt.toList((Object[])accessToken.getScope()));
                tokenInfoJSON = tokenInfoJSON2;
            }
        } else {
            throw (Throwable)new NotAuthorizedException("Invalid authorization header: " + authorizationHeader, (Object)"Bearer", new Object[0]);
        }
        return tokenInfoJSON;
    }

    @NotNull
    public static final /* synthetic */ JetPassMainApp access$getJetPass$p() {
        return TokenInfoUtilKt.getJetPass();
    }
}

