/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.command;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.persistent.IssueFolderUtil;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.restInternal.JaxbSuggest;
import jetbrains.charisma.smartui.filter.FilterData;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.parser.IContext;
import jetbrains.youtrack.commands.impl.RecentCommandsCache;
import jetbrains.youtrack.commands.service.BeansKt;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.persistent.XdIssueFolder;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.rest.command.bean.JaxbCommands;
import jetbrains.youtrack.rest.command.bean.JaxbUnderlineAndSuggestAndCommands;
import jetbrains.youtrack.rest.search.JaxbUnderline;
import jetbrains.youtrack.rest.search.JaxbUnderlineAndSuggest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/command")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J_\u0010\r\u001a\u00020\u000e2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0012J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J3\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0016JB\u0010\u0017\u001a\u00020\u00182\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007J_\u0010\u0019\u001a\u00020\u001a2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u001bJ_\u0010\u001c\u001a\u00020\u001d2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u001eJ8\u0010\u001f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006 "}, d2={"Ljetbrains/youtrack/rest/command/DeprecatedCommandResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "doParse", "Ljetbrains/youtrack/api/commands/ICommandList;", "folder", "Ljetbrains/exodus/entitystore/Entity;", "query", "", "issueIds", "command", "noIssuesContext", "", "getSuggest", "Ljetbrains/charisma/restInternal/JaxbSuggest;", "caret", "", "optionsLimit", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljetbrains/charisma/restInternal/JaxbSuggest;", "getSuggests", "commandList", "limit", "(Ljetbrains/youtrack/api/commands/ICommandList;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljetbrains/charisma/restInternal/JaxbSuggest;", "getUnderline", "Ljetbrains/youtrack/rest/search/JaxbUnderline;", "getUnderlineAndSuggest", "Ljetbrains/youtrack/rest/search/JaxbUnderlineAndSuggest;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljetbrains/youtrack/rest/search/JaxbUnderlineAndSuggest;", "getUnderlineAndSuggestAndCommands", "Ljetbrains/youtrack/rest/command/bean/JaxbUnderlineAndSuggestAndCommands;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Z)Ljetbrains/youtrack/rest/command/bean/JaxbUnderlineAndSuggestAndCommands;", "parse", "youtrack-old-rest"})
public final class DeprecatedCommandResource
implements Resource {
    @GET
    @Path(value="/suggest")
    @NotNull
    public final JaxbSuggest getSuggest(@QueryParam(value="issueIds") @Nullable String issueIds, @QueryParam(value="folder") @Nullable String folder, @QueryParam(value="query") @Nullable String query, @QueryParam(value="command") @Nullable String command, @QueryParam(value="caret") @Nullable Integer caret, @QueryParam(value="optionsLimit") @Nullable Integer optionsLimit, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList = this.parse(IssueFolderUtil.findById((String)folder), query, issueIds, command, noIssuesContext);
        return this.getSuggests(commandList, command, caret, optionsLimit);
    }

    @GET
    @Path(value="/underline")
    @NotNull
    public final JaxbUnderline getUnderline(@QueryParam(value="issueIds") @Nullable String issueIds, @QueryParam(value="folder") @Nullable String folder, @QueryParam(value="query") @Nullable String query, @QueryParam(value="command") @Nullable String command, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList = this.parse(IssueFolderUtil.findById((String)folder), query, issueIds, command, noIssuesContext);
        String string = command;
        if (string == null) {
            string = "";
        }
        Iterable iterable = commandList.getCells();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"commandList.cells");
        return new JaxbUnderline(string, iterable);
    }

    @GET
    @Path(value="/underlineAndSuggest")
    @NotNull
    public final JaxbUnderlineAndSuggest getUnderlineAndSuggest(@QueryParam(value="issueIds") @Nullable String issueIds, @QueryParam(value="folder") @Nullable String folder, @QueryParam(value="query") @Nullable String query, @QueryParam(value="command") @Nullable String command, @QueryParam(value="caret") @Nullable Integer caret, @QueryParam(value="optionsLimit") @Nullable Integer optionsLimit, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList = this.parse(IssueFolderUtil.findById((String)folder), query, issueIds, command, noIssuesContext);
        String string = command;
        if (string == null) {
            string = "";
        }
        Iterable iterable = commandList.getCells();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"commandList.cells");
        return new JaxbUnderlineAndSuggest(new JaxbUnderline(string, iterable), this.getSuggests(commandList, command, caret, optionsLimit));
    }

    @GET
    @Path(value="/underlineAndSuggestAndCommands")
    @NotNull
    public final JaxbUnderlineAndSuggestAndCommands getUnderlineAndSuggestAndCommands(@QueryParam(value="issueIds") @Nullable String issueIds, @QueryParam(value="folder") @Nullable String folder, @QueryParam(value="query") @Nullable String query, @QueryParam(value="command") @Nullable String command, @QueryParam(value="caret") @Nullable Integer caret, @QueryParam(value="optionsLimit") @Nullable Integer optionsLimit, @QueryParam(value="noIssuesContext") boolean noIssuesContext) {
        IsLoggedInSecurityConstraint.check();
        ICommandList commandList = this.parse(ProjectImpl.findReadableProject((String)folder, (Entity)jetbrains.charisma.persistent.BeansKt.getCurrentUser().get()), query, issueIds, command, noIssuesContext);
        String string = command;
        if (string == null) {
            string = "";
        }
        Iterable iterable = commandList.getCells();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"commandList.cells");
        JaxbUnderline jaxbUnderline = new JaxbUnderline(string, iterable);
        JaxbSuggest jaxbSuggest = this.getSuggests(commandList, command, caret, optionsLimit);
        Iterable iterable2 = commandList.getValidCommands();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"commandList.validCommands");
        return new JaxbUnderlineAndSuggestAndCommands(jaxbUnderline, jaxbSuggest, new JaxbCommands(iterable2));
    }

    private final ICommandList parse(Entity folder, String query, String issueIds, String command, boolean noIssuesContext) {
        Object object = folder;
        if (object == null) {
            Entity entity = jetbrains.charisma.persistent.BeansKt.getCurrentUser().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"currentUser.get()");
            XdIssueFolder xdIssueFolder = ((XdUser)XdExtensionsKt.toXd((Entity)entity)).getProfile().getFilterFolder();
            object = xdIssueFolder != null ? xdIssueFolder.getEntity() : null;
        }
        return this.doParse((Entity)object, query, issueIds, command, noIssuesContext);
    }

    private final ICommandList doParse(Entity folder, String query, String issueIds, String command, boolean noIssuesContext) {
        Context context = new Context();
        if (!noIssuesContext) {
            CharSequence charSequence = query;
            if (!(charSequence == null || charSequence.length() == 0) || issueIds == null || (charSequence = (CharSequence)issueIds).length() == 0) {
                FilterData filterData = FilterData.create((String)query, (Entity)folder, (Entity)jetbrains.charisma.persistent.BeansKt.getCurrentUser().get(), (int)Integer.MAX_VALUE);
                Intrinsics.checkExpressionValueIsNotNull((Object)filterData, (String)"FilterData.create(query,\u2026get(), Integer.MAX_VALUE)");
                FilterData filterData2 = filterData;
                context.setSelectedIssues(filterData2.getIssues(true, false));
            } else {
                context.setSelectedIssues(BeansKt.getIssueIdEncoder().toIssues(issueIds));
            }
        } else if (folder != null) {
            context.setSelectedProjects(((XdIssueFolder)XdExtensionsKt.toXd((Entity)folder)).getQueryProjects().getEntityIterable());
        }
        ICommandList iCommandList = jetbrains.youtrack.api.commands.BeansKt.getCommandService().parse(command, (IContext)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)iCommandList, (String)"commandService.parse(command, context)");
        return iCommandList;
    }

    private final JaxbSuggest getSuggests(ICommandList commandList, String command, Integer caret, Integer limit) {
        Integer n;
        String string = command;
        if (string == null) {
            string = "";
        }
        if ((n = caret) == null) {
            String string2 = command;
            n = string2 != null ? Integer.valueOf(string2.length()) : null;
        }
        Integer n2 = limit;
        return this.getSuggests(commandList, string, n != null ? n : 0, n2 != null ? n2 : 15);
    }

    private final JaxbSuggest getSuggests(ICommandList commandList, String command, int caret, int limit) {
        RecentCommandsCache recentCommandsCache = RecentCommandsCache.get((Entity)jetbrains.charisma.persistent.BeansKt.getCurrentUser().get());
        if (recentCommandsCache == null) {
            Intrinsics.throwNpe();
        }
        Iterable recentCommands = recentCommandsCache.getSuggests(command, caret);
        Iterable iterable = jetbrains.youtrack.api.commands.BeansKt.getCommandService().suggest(commandList, caret, limit);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"commandService.suggest(commandList, caret, limit)");
        Iterable iterable2 = recentCommands;
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"recentCommands");
        List suggestItems = CollectionsKt.plus((Iterable)iterable, (Iterable)iterable2);
        return new JaxbSuggest(command, caret, (Iterable)suggestItems);
    }
}

