/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.customfields;

import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.provider.exception.RESTNotFoundException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.rest.customfields.OldRestBundleServiceImpl;
import jetbrains.youtrack.workflow.api.ProjectWorkflowApiExtensionKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"oldRestBundleService", "Ljetbrains/youtrack/rest/customfields/OldRestBundleServiceImpl;", "getOldRestBundleService", "()Ljetbrains/youtrack/rest/customfields/OldRestBundleServiceImpl;", "assertHasAdminOrCreateProjectPermission", "", "assertHasReadPermissionToProjectField", "projectId", "", "fieldName", "youtrack-old-rest"})
public final class OldRestBundleServiceImplKt {
    @NotNull
    public static final OldRestBundleServiceImpl getOldRestBundleService() {
        String name$iv = "oldRestBundleService";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.rest.customfields.OldRestBundleServiceImpl");
        }
        return (OldRestBundleServiceImpl)object;
    }

    public static final void assertHasAdminOrCreateProjectPermission() {
        XdUser current = BeansKt.getXdLoggedInUser();
        if (!current.hasPermission(Permission.ADMIN_UPDATE_APP) && !current.hasPermission(Permission.CREATE_PROJECT)) {
            throw (Throwable)new ForbiddenException("You do not have permissions to access this resource.");
        }
    }

    public static final void assertHasReadPermissionToProjectField(@NotNull String projectId, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        XdProject xdProject = XdProject.Companion.findByKey(projectId);
        if (xdProject == null) {
            throw (Throwable)new ForbiddenException("You have no permission for project [ " + projectId + " ]");
        }
        XdProject project = xdProject;
        XdProjectCustomField xdProjectCustomField = ProjectWorkflowApiExtensionKt.findFieldByName((XdProject)project, (String)fieldName);
        if (xdProjectCustomField == null) {
            throw (Throwable)new RESTNotFoundException("No field with name [ " + fieldName + " ] found attached to project [ " + projectId + " ]");
        }
        XdProjectCustomField field2 = xdProjectCustomField;
        if (!XdProjectCustomField.isAccessible$default((XdProjectCustomField)field2, (Operation)Operation.READ, null, (int)2, null)) {
            throw (Throwable)new ForbiddenException("You have no permission for field [ " + fieldName + " ] in project [ " + projectId + " ]");
        }
    }
}

