/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.customfields.state;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.customfields.complex.common.RequireBundleIsAccessibleSecurityConstraint;
import jetbrains.charisma.customfields.persistence.fields.XdBundle;
import jetbrains.charisma.customfields.persistence.fields.XdFieldBundle;
import jetbrains.charisma.customfields.persistence.fields.XdState;
import jetbrains.charisma.customfields.persistence.fields.XdStatesBundle;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.customfields.OldRestBundleServiceImplKt;
import jetbrains.youtrack.rest.customfields.state.OldRestStateBundleResource;
import jetbrains.youtrack.rest.customfields.state.StateBean;
import jetbrains.youtrack.rest.customfields.state.StateBundleBean;
import jetbrains.youtrack.rest.customfields.state.StateBundleRef;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/admin/customfield/stateBundle")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u0006H\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0007J]\u0010\u0019\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u001a\u001a\u00020\u00062\n\b\u0001\u0010\u0018\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0011H\u0007JQ\u0010#\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u001a\u001a\u00020\u00062\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007\u00a2\u0006\u0002\u0010$\u00a8\u0006%"}, d2={"Ljetbrains/youtrack/rest/customfields/state/OldRestStateBundleResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "deleteBundleName", "Ljavax/ws/rs/core/Response;", "bundleName", "", "deleteBundleNameFieldName", "fieldName", "get", "", "Ljetbrains/youtrack/rest/customfields/state/StateBundleRef;", "getBundle", "Ljetbrains/charisma/customfields/persistence/fields/XdStatesBundle;", "shouldExist", "", "getBundleName", "Ljetbrains/youtrack/rest/customfields/state/StateBundleBean;", "getBundleNameFieldName", "Ljetbrains/youtrack/rest/customfields/state/StateBean;", "getStateField", "Ljetbrains/charisma/customfields/persistence/fields/XdState;", "bundle", "postBundleName", "newName", "postBundleNameStateName", "stateName", "isResolved", "localizedName", "description", "colorIndex", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Ljavax/ws/rs/core/Response;", "put", "bundleBean", "putBundleNameFieldName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Ljavax/ws/rs/core/Response;", "youtrack-old-rest"})
public final class OldRestStateBundleResource
implements Resource {
    @GET
    @NotNull
    public final List<StateBundleRef> get() {
        IsLoggedInSecurityConstraint.check();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdStatesBundle.Companion.all()), (Function1)get.1.INSTANCE), (Function1)get.2.INSTANCE));
    }

    @GET
    @Path(value="/{bundleName}")
    @NotNull
    public final StateBundleBean getBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        RequireBundleIsAccessibleSecurityConstraint.check((String)bundleName);
        return new StateBundleBean(this.getBundle(bundleName, true));
    }

    /*
     * WARNING - void declaration
     */
    @PUT
    @Consumes(value={"application/xml"})
    @NotNull
    public final Response put(@NotNull StateBundleBean bundleBean) {
        Intrinsics.checkParameterIsNotNull((Object)bundleBean, (String)"bundleBean");
        IsLoggedInSecurityConstraint.check();
        OldRestBundleServiceImplKt.assertHasAdminOrCreateProjectPermission();
        String string = bundleBean.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String bundleName = string;
        this.getBundle(bundleName, false);
        XdStatesBundle bundle2 = (XdStatesBundle)XdStatesBundle.Companion.new((Function1)new Function1<XdStatesBundle, Unit>(bundleName){
            final /* synthetic */ String $bundleName;

            public final void invoke(@NotNull XdStatesBundle $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setName(this.$bundleName);
            }
            {
                this.$bundleName = string;
                super(1);
            }
        });
        List<StateBean> list = bundleBean.getState();
        if (list != null) {
            Iterable $receiver$iv = list;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void bean;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                StateBean stateBean = (StateBean)item$iv;
                int index = n2;
                boolean bl = false;
                XdState.Companion.new((Function1)new Function1<XdState, Unit>((StateBean)bean, index, bundle2){
                    final /* synthetic */ StateBean $bean;
                    final /* synthetic */ int $index;
                    final /* synthetic */ XdStatesBundle $bundle$inlined;
                    {
                        this.$bean = stateBean;
                        this.$index = n;
                        this.$bundle$inlined = xdStatesBundle;
                        super(1);
                    }

                    public final void invoke(@NotNull XdState $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        String string = this.$bean.getValue();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        $receiver.setName(string);
                        $receiver.setBundle((XdFieldBundle)this.$bundle$inlined);
                        $receiver.setDescription(this.$bean.getDescription());
                        Integer n = this.$bean.getColorIndex();
                        $receiver.setColorIndex(n != null ? n : 0);
                        Boolean bl = this.$bean.isResolved();
                        $receiver.setResolved(bl != null ? bl : false);
                        $receiver.setOrdinal(this.$index);
                    }
                });
            }
        }
        return ResponseUtilKt.created(OldRestBundleServiceImplKt.getOldRestBundleService().urlOf((XdBundle)bundle2));
    }

    @POST
    @Path(value="/{bundleName}")
    @NotNull
    public final Response postBundleName(@PathParam(value="bundleName") @NotNull String bundleName, @QueryParam(value="newName") @Nullable String newName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        OldRestBundleServiceImplKt.assertHasAdminOrCreateProjectPermission();
        XdStatesBundle xdStatesBundle = this.getBundle(bundleName, true);
        if (xdStatesBundle == null) {
            Intrinsics.throwNpe();
        }
        XdStatesBundle ownedFieldBundle = xdStatesBundle;
        ResponseUtilKt.isRequired("newName", newName);
        String oldName = ownedFieldBundle.getName();
        if (Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            String string = newName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.getBundle(string, false);
            ownedFieldBundle.setName(newName);
        }
        return ResponseUtilKt.created(OldRestBundleServiceImplKt.getOldRestBundleService().urlOf((XdBundle)ownedFieldBundle));
    }

    @DELETE
    @Path(value="/{bundleName}")
    @NotNull
    public final Response deleteBundleName(@PathParam(value="bundleName") @NotNull String bundleName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        IsLoggedInSecurityConstraint.check();
        OldRestBundleServiceImplKt.assertHasAdminOrCreateProjectPermission();
        return ResponseUtilKt.deleted$default((XdEntity)this.getBundle(bundleName, true), false, 2, null);
    }

    @GET
    @Path(value="/{bundleName}/{fieldName}")
    @NotNull
    public final StateBean getBundleNameFieldName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="fieldName") @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        IsLoggedInSecurityConstraint.check();
        XdStatesBundle xdStatesBundle = this.getBundle(bundleName, true);
        if (xdStatesBundle == null) {
            Intrinsics.throwNpe();
        }
        XdState xdState = this.getStateField(xdStatesBundle, fieldName, true);
        if (xdState == null) {
            Intrinsics.throwNpe();
        }
        return new StateBean(xdState);
    }

    @PUT
    @Path(value="/{bundleName}/{stateName}")
    @NotNull
    public final Response putBundleNameFieldName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="stateName") @NotNull String stateName, @QueryParam(value="isResolved") @Nullable String isResolved, @QueryParam(value="localizedName") @Nullable String localizedName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)stateName, (String)"stateName");
        IsLoggedInSecurityConstraint.check();
        OldRestBundleServiceImplKt.assertHasAdminOrCreateProjectPermission();
        XdStatesBundle xdStatesBundle = this.getBundle(bundleName, true);
        if (xdStatesBundle == null) {
            Intrinsics.throwNpe();
        }
        XdStatesBundle bundle2 = xdStatesBundle;
        this.getStateField(bundle2, stateName, false);
        XdState field2 = (XdState)XdState.Companion.new((Function1)new Function1<XdState, Unit>(bundle2, stateName){
            final /* synthetic */ XdStatesBundle $bundle;
            final /* synthetic */ String $stateName;

            public final void invoke(@NotNull XdState $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setBundle((XdFieldBundle)this.$bundle);
                $receiver.setName(this.$stateName);
                $receiver.setOrdinal(this.$bundle.getHighestOrdinal() + 1);
            }
            {
                this.$bundle = xdStatesBundle;
                this.$stateName = string;
                super(1);
            }
        });
        if (isResolved != null) {
            String string = isResolved;
            XdState xdState = field2;
            boolean bl = Boolean.parseBoolean(string);
            xdState.setResolved(bl);
        }
        field2.setDescription(description);
        if (colorIndex != null) {
            field2.setColorIndex(colorIndex.intValue());
        }
        if (localizedName != null) {
            field2.setLocalizedName(localizedName);
        }
        return ResponseUtilKt.created(OldRestBundleServiceImplKt.getOldRestBundleService().urlOf((XdBundle)bundle2));
    }

    @POST
    @Path(value="/{bundleName}/{stateName}")
    @NotNull
    public final Response postBundleNameStateName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="stateName") @NotNull String stateName, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="isResolved") @Nullable Boolean isResolved, @QueryParam(value="localizedName") @Nullable String localizedName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="colorIndex") @Nullable Integer colorIndex) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)stateName, (String)"stateName");
        IsLoggedInSecurityConstraint.check();
        OldRestBundleServiceImplKt.assertHasAdminOrCreateProjectPermission();
        XdStatesBundle xdStatesBundle = this.getBundle(bundleName, true);
        if (xdStatesBundle == null) {
            Intrinsics.throwNpe();
        }
        XdStatesBundle bundle2 = xdStatesBundle;
        XdState xdState = this.getStateField(bundle2, stateName, true);
        if (xdState == null) {
            Intrinsics.throwNpe();
        }
        XdState field2 = xdState;
        if (localizedName != null && (charSequence2 = (CharSequence)localizedName).length() > 0) {
            if (field2.canBeLocalized()) {
                field2.setLocalizedName(localizedName);
            } else {
                throw (Throwable)new BadRequestException("Field is not localized");
            }
        }
        if (isResolved != null) {
            field2.setResolved(isResolved.booleanValue());
        }
        if (description != null) {
            field2.setDescription(description);
        }
        String oldName = field2.getName();
        if (newName != null && (charSequence = (CharSequence)newName).length() > 0 && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            this.getStateField(bundle2, newName, false);
            field2.setName(newName);
        }
        if (colorIndex != null) {
            field2.setColorIndex(colorIndex.intValue());
        }
        return ResponseUtilKt.updated(OldRestBundleServiceImplKt.getOldRestBundleService().urlOf((XdBundle)bundle2), oldName, newName);
    }

    @DELETE
    @Path(value="/{bundleName}/{fieldName}")
    @NotNull
    public final Response deleteBundleNameFieldName(@PathParam(value="bundleName") @NotNull String bundleName, @PathParam(value="fieldName") @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)bundleName, (String)"bundleName");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        IsLoggedInSecurityConstraint.check();
        OldRestBundleServiceImplKt.assertHasAdminOrCreateProjectPermission();
        XdStatesBundle xdStatesBundle = this.getBundle(bundleName, true);
        if (xdStatesBundle == null) {
            Intrinsics.throwNpe();
        }
        return ResponseUtilKt.deleted$default((XdEntity)this.getStateField(xdStatesBundle, fieldName, true), false, 2, null);
    }

    private final XdStatesBundle getBundle(String bundleName, boolean shouldExist) {
        XdStatesBundle bundle2 = (XdStatesBundle)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdStatesBundle.Companion), (Function2)((Function2)new Function2<FilteringContext, XdStatesBundle, XdSearchingNode>(bundleName){
            final /* synthetic */ String $bundleName;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdStatesBundle it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$bundleName));
            }
            {
                this.$bundleName = string;
                super(2);
            }
        })));
        ResponseUtilKt.assertExist("State field bundle", bundle2, bundleName, shouldExist);
        return bundle2;
    }

    private final XdState getStateField(XdStatesBundle bundle2, String fieldName, boolean shouldExist) {
        XdState field2 = (XdState)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)XdQueryKt.filterIsInstance((XdQuery)((XdQuery)bundle2.getChildren()), (XdEntityType)((XdEntityType)XdState.Companion)), (Function2)((Function2)new Function2<FilteringContext, XdState, XdSearchingNode>(fieldName){
            final /* synthetic */ String $fieldName;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdState it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$fieldName));
            }
            {
                this.$fieldName = string;
                super(2);
            }
        })));
        ResponseUtilKt.assertExist("State field", field2, fieldName, shouldExist);
        return field2;
    }
}

