/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.persistent.security.XdUserRole;
import jetbrains.youtrack.persistent.security.XdUserRoleKt;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.group.AdminGroupResource$get$1;
import jetbrains.youtrack.rest.group.AdminGroupResourceKt;
import jetbrains.youtrack.rest.group.UserGroupBean;
import jetbrains.youtrack.rest.group.UserGroupRef;
import jetbrains.youtrack.rest.project.beans.ProjectRef;
import jetbrains.youtrack.rest.role.RolesRestUtilKt;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import jetbrains.youtrack.rest.user.beans.UserRole;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/admin/group")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u0006H\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u0006H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J$\u0010\u0017\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0014H\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J;\u0010\u001e\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"Ljetbrains/youtrack/rest/group/AdminGroupResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "createGroup", "Ljavax/ws/rs/core/Response;", "group", "", "description", "autoJoin", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "deleteGroup", "deleteGroupRoleRole", "role", "get", "", "Ljetbrains/youtrack/rest/group/UserGroupRef;", "getGroup", "Ljetbrains/youtrack/rest/group/UserGroupBean;", "getGroupRole", "Ljetbrains/youtrack/rest/user/beans/UserRole;", "getGroupRoleRole", "getVisible", "putGroupRoleRole", "userRole", "replaceRole", "", "ug", "Ljetbrains/youtrack/persistent/XdUserGroup;", "userRoleJaxb", "updateGroup", "newName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "youtrack-old-rest"})
public final class AdminGroupResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/visible")
    @NotNull
    public final List<UserGroupRef> getVisible() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        IsLoggedInSecurityConstraint.check();
        Iterable iterable = $receiver$iv = (Iterable)XdQueryKt.toList((XdQuery)BeansKt.getXdLoggedInUser().getVisibleGroupsSorted());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdUserGroup xdUserGroup = (XdUserGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserGroupRef userGroupRef = new UserGroupRef((XdUserGroup)it);
            collection.add(userGroupRef);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<UserGroupRef> get() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USERGROUP, null, 2, null);
        Iterable iterable = $receiver$iv = (Iterable)XdQueryKt.toList((XdQuery)XdQueryKt.sortedBy$default((XdQuery)XdUserGroup.Companion.all(), (KProperty1)((KProperty1)AdminGroupResource$get$1.INSTANCE), (boolean)false, (int)2, null));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdUserGroup xdUserGroup = (XdUserGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserGroupRef userGroupRef = new UserGroupRef((XdUserGroup)it);
            collection.add(userGroupRef);
        }
        return (List)var3_3;
    }

    @GET
    @Path(value="/{group}")
    @NotNull
    public final UserGroupBean getGroup(@PathParam(value="group") @NotNull String group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USERGROUP, null, 2, null);
        return new UserGroupBean(AdminGroupResourceKt.getGroupByName(group));
    }

    @PUT
    @Path(value="/{group}")
    @NotNull
    public final Response createGroup(@PathParam(value="group") @NotNull String group, @QueryParam(value="description") @Nullable String description, @QueryParam(value="autoJoin") @Nullable Boolean autoJoin) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        UserRestUtilKt.assertHasPermission$default(Permission.CREATE_USERGROUP, null, 2, null);
        AdminGroupResourceKt.access$checkGroupDoesNotExist(group);
        XdUserGroup.Companion.new(group, (Function1)new Function1<XdUserGroup, Unit>(description, autoJoin){
            final /* synthetic */ String $description;
            final /* synthetic */ Boolean $autoJoin;

            public final void invoke(@NotNull XdUserGroup $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setDescription(this.$description);
                $receiver.setAddNewUser(Intrinsics.areEqual((Object)this.$autoJoin, (Object)true));
            }
            {
                this.$description = string;
                this.$autoJoin = bl;
                super(1);
            }
        });
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtilKt.created(AdminGroupResourceKt.getUserGroupUrl(group));
    }

    @POST
    @Path(value="/{group}")
    @NotNull
    public final Response updateGroup(@PathParam(value="group") @NotNull String group, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="description") @Nullable String description, @QueryParam(value="autoJoin") @Nullable Boolean autoJoin) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_USERGROUP, null, 2, null);
        XdUserGroup ug = AdminGroupResourceKt.getGroupByName(group);
        if (description != null) {
            ug.setDescription(description);
        }
        if (autoJoin != null) {
            ug.setAddNewUser(autoJoin.booleanValue());
        }
        String oldName = ug.getName();
        CharSequence charSequence = newName;
        if (!(charSequence == null || charSequence.length() == 0) && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            AdminGroupResourceKt.access$checkGroupDoesNotExist(newName);
            ug.setName(newName);
        }
        return ResponseUtilKt.updated(AdminGroupResourceKt.getUserGroupUrl(ug.getName()), oldName, newName);
    }

    @DELETE
    @Path(value="/{group}")
    @NotNull
    public final Response deleteGroup(@PathParam(value="group") @NotNull String group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        UserRestUtilKt.assertHasPermission$default(Permission.DELETE_USERGROUP, null, 2, null);
        return ResponseUtilKt.deleted((XdEntity)AdminGroupResourceKt.getGroupByName(group), true);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{group}/role")
    @NotNull
    public final List<UserRole> getGroupRole(@PathParam(value="group") @NotNull String group) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USERGROUP, null, 2, null);
        UserRestUtilKt.assertHasPermission$default(Permission.READ_ROLE, null, 2, null);
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable((XdQuery)((XdQuery)AdminGroupResourceKt.getGroupByName(group).getGroupRoles()));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdUserRole xdUserRole = (XdUserRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserRole userRole = new UserRole(it.getRole().getName(), XdQueryKt.asIterable((XdQuery)((XdQuery)it.getProjects())));
            collection.add(userRole);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/{group}/role/{role}")
    @NotNull
    public final UserRole getGroupRoleRole(@PathParam(value="group") @NotNull String group, @PathParam(value="role") @NotNull String role2) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_USERGROUP, null, 2, null);
        XdUserGroup ug = AdminGroupResourceKt.getGroupByName(group);
        XdUserRole ur = RolesRestUtilKt.getRoleByName(ug, role2);
        return new UserRole(ur.getRole().getName(), XdQueryKt.asIterable((XdQuery)((XdQuery)ur.getProjects())));
    }

    @PUT
    @Path(value="/{group}/role/{role}")
    @NotNull
    public final Response putGroupRoleRole(@PathParam(value="group") @NotNull String group, @PathParam(value="role") @NotNull String role2, @NotNull UserRole userRole) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        Intrinsics.checkParameterIsNotNull((Object)userRole, (String)"userRole");
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_USERGROUP, null, 2, null);
        XdUserGroup ug = AdminGroupResourceKt.getGroupByName(group);
        this.replaceRole(ug, userRole);
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtilKt.created(AdminGroupResourceKt.getUserRoleUrl(group, role2));
    }

    @DELETE
    @Path(value="/{group}/role/{role}")
    @NotNull
    public final Response deleteGroupRoleRole(@PathParam(value="group") @NotNull String group, @PathParam(value="role") @NotNull String role2) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)role2, (String)"role");
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_USERGROUP, null, 2, null);
        XdUserGroup ug = AdminGroupResourceKt.getGroupByName(group);
        XdUserRole ur = RolesRestUtilKt.getRoleByName(ug, role2);
        ur.delete();
        RestUtil.waitForPermissionCacheRecalculation();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceRole(XdUserGroup ug, UserRole userRoleJaxb) {
        Iterable iterable;
        List<ProjectRef> projectRef;
        XdRole r = RolesRestUtilKt.getRoleByName(userRoleJaxb.getName());
        List<ProjectRef> list = projectRef = userRoleJaxb.getProjectRef();
        if (list != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable2 = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                XdProject xdProject;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                ProjectRef it = (ProjectRef)element$iv$iv;
                boolean bl = false;
                if (XdProject.Companion.findByKey(it.getId()) == null) continue;
                XdProject it$iv$iv = xdProject;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = XdQueryKt.asIterable((XdQuery)XdProject.Companion.all());
        }
        Iterable projects = iterable;
        XdUserRole xdUserRole = RolesRestUtilKt.getRoleNullable(ug, userRoleJaxb.getName());
        if (xdUserRole != null) {
            xdUserRole.delete();
        }
        XdUserRoleKt.createRoleWithCheck((XdRole)r, (Iterable)projects, (Iterable)XdQueryKt.asIterable((XdQuery)ug.getUserRoles()), (XdUserGroup)ug);
    }
}

