/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.group;

import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.rest.ResponseUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import webr.framework.url.UrlUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003\u001a\u0016\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003\u00a8\u0006\u000b"}, d2={"checkGroupDoesNotExist", "", "name", "", "getGroupByName", "Ljetbrains/youtrack/persistent/XdUserGroup;", "getUserGroupUrl", "Lwebr/framework/url/UrlUtil$Url;", "groupName", "getUserRoleUrl", "roleName", "youtrack-old-rest"})
public final class AdminGroupResourceKt {
    @NotNull
    public static final XdUserGroup getGroupByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        XdUserGroup group = XdUserGroup.Companion.find(name);
        ResponseUtilKt.assertExist("Group", group, name, true);
        XdUserGroup xdUserGroup = group;
        if (xdUserGroup == null) {
            Intrinsics.throwNpe();
        }
        return xdUserGroup;
    }

    private static final void checkGroupDoesNotExist(String name) {
        XdUserGroup group = XdUserGroup.Companion.find(name);
        ResponseUtilKt.assertExist("Group", group, name, false);
    }

    @NotNull
    public static final UrlUtil.Url getUserGroupUrl(@NotNull String groupName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"admin", "group"}).addPathElements(new String[]{groupName});
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"UrlUtil.getRestPathUri(\"\u2026ddPathElements(groupName)");
        return url;
    }

    @NotNull
    public static final UrlUtil.Url getUserRoleUrl(@NotNull String groupName, @NotNull String roleName) {
        Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
        Intrinsics.checkParameterIsNotNull((Object)roleName, (String)"roleName");
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"admin", "group"}).addPathElements(new String[]{groupName, "role", roleName});
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"UrlUtil.getRestPathUri(\"\u2026upName, \"role\", roleName)");
        return url;
    }

    public static final /* synthetic */ void access$checkGroupDoesNotExist(String name) {
        AdminGroupResourceKt.checkGroupDoesNotExist(name);
    }
}

