/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.link;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.rest.Count;
import jetbrains.charisma.rest.HasAdminReadSecurityConstraint;
import jetbrains.charisma.rest.HasAdminWriteSecurityConstraint;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.link.AdminIssueLinkTypeResource$get$1;
import jetbrains.youtrack.rest.link.IssueLinkPrototype;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Path(value="/admin/issueLinkType")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002JE\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\n\u001a\u00020\u00062\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0006H\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0012\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\t\u001a\u00020\u0006H\u0007J\u0012\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a2\u0006\u0010\t\u001a\u00020\u0006H\u0002JS\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00062\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Ljetbrains/youtrack/rest/link/AdminIssueLinkTypeResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "checkLinkDoestExist", "", "linkName", "", "createLinkType", "Ljavax/ws/rs/core/Response;", "name", "outwardName", "inwardName", "directed", "", "aggregation", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "delete", "get", "", "Ljetbrains/youtrack/rest/link/IssueLinkPrototype;", "getByName", "getCount", "Ljetbrains/charisma/rest/Count;", "getIssueLinkPrototype", "Ljetbrains/youtrack/persistent/XdIssueLinkPrototype;", "getLinkPrototypeUrl", "Lwebr/framework/url/UrlUtil$Url;", "kotlin.jvm.PlatformType", "updateLinkType", "newName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "youtrack-old-rest"})
public final class AdminIssueLinkTypeResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<IssueLinkPrototype> get() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        IsLoggedInSecurityConstraint.check();
        Iterable iterable = $receiver$iv = (Iterable)XdQueryKt.toList((XdQuery)XdQueryKt.sortedBy$default((XdQuery)XdIssueLinkPrototype.Companion.all(), (KProperty1)((KProperty1)AdminIssueLinkTypeResource$get$1.INSTANCE), (boolean)false, (int)2, null));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdIssueLinkPrototype xdIssueLinkPrototype = (XdIssueLinkPrototype)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IssueLinkPrototype issueLinkPrototype = new IssueLinkPrototype((XdIssueLinkPrototype)it);
            collection.add(issueLinkPrototype);
        }
        return (List)var3_3;
    }

    @GET
    @Path(value="/{name}")
    @NotNull
    public final IssueLinkPrototype getByName(@PathParam(value="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        IsLoggedInSecurityConstraint.check();
        return new IssueLinkPrototype(this.getIssueLinkPrototype(name));
    }

    @GET
    @Path(value="/{name}/count")
    @NotNull
    public final Count getCount(@PathParam(value="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        HasAdminReadSecurityConstraint.check();
        return new Count((long)this.getIssueLinkPrototype(name).getUsagesCount());
    }

    @PUT
    @Path(value="/{name}")
    @NotNull
    public final Response createLinkType(@PathParam(value="name") @NotNull String name, @QueryParam(value="outwardName") @NotNull String outwardName, @QueryParam(value="inwardName") @Nullable String inwardName, @QueryParam(value="directed") @Nullable Boolean directed, @QueryParam(value="aggregation") @Nullable Boolean aggregation) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)outwardName, (String)"outwardName");
        HasAdminWriteSecurityConstraint.check();
        this.checkLinkDoestExist(name);
        ResponseUtilKt.isRequired("outwardName", outwardName);
        if (Intrinsics.areEqual((Object)directed, (Object)true)) {
            ResponseUtilKt.isRequired("inwardName", inwardName);
        }
        XdIssueLinkPrototype.Companion.new((Function1)new Function1<XdIssueLinkPrototype, Unit>(name, outwardName, inwardName, directed, aggregation){
            final /* synthetic */ String $name;
            final /* synthetic */ String $outwardName;
            final /* synthetic */ String $inwardName;
            final /* synthetic */ Boolean $directed;
            final /* synthetic */ Boolean $aggregation;

            public final void invoke(@NotNull XdIssueLinkPrototype $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setName(this.$name);
                $receiver.setSourceToTarget(this.$outwardName);
                $receiver.setTargetToSource(this.$inwardName);
                $receiver.setDirected(Intrinsics.areEqual((Object)this.$directed, (Object)true));
                $receiver.setAggregation(Intrinsics.areEqual((Object)this.$aggregation, (Object)true));
            }
            {
                this.$name = string;
                this.$outwardName = string2;
                this.$inwardName = string3;
                this.$directed = bl;
                this.$aggregation = bl2;
                super(1);
            }
        });
        UrlUtil.Url url = this.getLinkPrototypeUrl(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"getLinkPrototypeUrl(name)");
        return ResponseUtilKt.created(url);
    }

    private final UrlUtil.Url getLinkPrototypeUrl(String name) {
        return UrlUtil.getRestPathUri((String[])new String[]{"admin", "issueLinkType"}).addPathElements(new String[]{name});
    }

    @POST
    @Path(value="/{name}")
    @NotNull
    public final Response updateLinkType(@PathParam(value="name") @NotNull String name, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="outwardName") @Nullable String outwardName, @QueryParam(value="inwardName") @Nullable String inwardName, @QueryParam(value="directed") @Nullable Boolean directed, @QueryParam(value="aggregation") @Nullable Boolean aggregation) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        HasAdminWriteSecurityConstraint.check();
        XdIssueLinkPrototype issueLinkPrototype = this.getIssueLinkPrototype(name);
        if (directed != null) {
            issueLinkPrototype.setDirected(directed.booleanValue());
        }
        if (aggregation != null) {
            issueLinkPrototype.setAggregation(aggregation.booleanValue());
        }
        if (!((charSequence = (CharSequence)outwardName) == null || charSequence.length() == 0)) {
            issueLinkPrototype.setSourceToTarget(outwardName);
        }
        if (!((charSequence = (CharSequence)inwardName) == null || charSequence.length() == 0)) {
            issueLinkPrototype.setTargetToSource(inwardName);
        }
        String oldName = issueLinkPrototype.getName();
        CharSequence charSequence2 = newName;
        if (!(charSequence2 == null || charSequence2.length() == 0) && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            this.checkLinkDoestExist(newName);
            issueLinkPrototype.setName(newName);
        }
        UrlUtil.Url url = this.getLinkPrototypeUrl(issueLinkPrototype.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"getLinkPrototypeUrl(issueLinkPrototype.name)");
        return ResponseUtilKt.updated(url, oldName, newName);
    }

    @DELETE
    @Path(value="/{name}")
    @NotNull
    public final Response delete(@PathParam(value="name") @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        HasAdminWriteSecurityConstraint.check();
        return ResponseUtilKt.deleted$default((XdEntity)this.getIssueLinkPrototype(name), false, 2, null);
    }

    private final XdIssueLinkPrototype getIssueLinkPrototype(String linkName) {
        XdIssueLinkPrototype issueLinkPrototype = XdIssueLinkPrototype.Companion.find(linkName);
        ResponseUtilKt.assertExist("Issue link type", issueLinkPrototype, linkName, true);
        XdIssueLinkPrototype xdIssueLinkPrototype = issueLinkPrototype;
        if (xdIssueLinkPrototype == null) {
            Intrinsics.throwNpe();
        }
        return xdIssueLinkPrototype;
    }

    private final void checkLinkDoestExist(String linkName) {
        XdIssueLinkPrototype issueLinkPrototype = XdIssueLinkPrototype.Companion.find(linkName);
        ResponseUtilKt.assertExist("Issue link type", issueLinkPrototype, linkName, false);
    }
}

