/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.login;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.rest.ResponseUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/user/login")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Ljetbrains/youtrack/rest/login/UserLoginResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "post", "", "login", "password", "youtrack-old-rest"})
public final class UserLoginResource
implements Resource {
    @POST
    @NotNull
    public final String post(@QueryParam(value="login") @Nullable String login, @QueryParam(value="password") @NotNull String password) {
        XdUser current;
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        ResponseUtilKt.isRequired("login", login);
        ResponseUtilKt.isRequired("password", password);
        Entity entity = BeansKt.getLoggedInUserOrNull();
        Object object = current = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
        if (current != null && Intrinsics.areEqual((Object)current.getLogin(), (Object)login)) {
            jetbrains.charisma.main.BeansKt.getSecurityNavigator().login((Object)current.getEntity(), true);
        } else {
            Entity user2 = BeansKt.getAuthenticationManager().authorize(new LoginContext(login, password));
            if (login != null && user2 != null) {
                jetbrains.charisma.main.BeansKt.getSecurityNavigator().login((Object)user2, true);
            } else {
                throw (Throwable)new ForbiddenException("Incorrect login or password.");
            }
        }
        return "<login>ok</login>";
    }
}

