/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.ProjectBuilder;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.project.ProjectRestUtilKt;
import jetbrains.youtrack.rest.project.beans.ProjectBean;
import jetbrains.youtrack.rest.project.beans.ProjectRef;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/admin/project")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u000e\u001a\u00020\u0006H\u0007J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0013H\u0007JC\u0010\u0015\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\b\u001a\u00020\u00062\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Ljetbrains/youtrack/rest/project/AdminProjectResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "createProject", "Ljavax/ws/rs/core/Response;", "projectId", "", "projectName", "projectLeadLogin", "description", "startingNumber", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Ljavax/ws/rs/core/Response;", "deleteProject", "project", "getAll", "", "Ljetbrains/youtrack/rest/project/beans/ProjectRef;", "getProject", "Ljetbrains/youtrack/rest/project/beans/ProjectBean;", "put", "putProjectId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Ljavax/ws/rs/core/Response;", "youtrack-old-rest"})
public final class AdminProjectResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<ProjectRef> getAll() {
        void $receiver$iv$iv;
        Iterable projects;
        Iterable $receiver$iv;
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.READ_PROJECT, null, 2, null);
        Iterable iterable = $receiver$iv = (projects = XdQueryKt.asIterable((XdQuery)XdQueryKt.asQuery((Iterable)BeansKt.getSecurity().getProjects((Entity)BeansKt.getLoggedInUser(), Permission.READ_PROJECT, BeansKt.getXdLoggedInUser().hasPermission(Permission.ADMIN_READ_APP)), (XdEntityType)((XdEntityType)XdProject.Companion))));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdProject xdProject = (XdProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProjectRef projectRef = new ProjectRef(it.getShortName());
            collection.add(projectRef);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/{project}")
    @NotNull
    public final ProjectBean getProject(@PathParam(value="project") @NotNull String project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.READ_PROJECT, null, 2, null);
        return new ProjectBean(ProjectRestUtilKt.getProjectById(project));
    }

    @PUT
    @Path(value="/{projectId}")
    @NotNull
    public final Response putProjectId(@PathParam(value="projectId") @NotNull String projectId, @QueryParam(value="projectName") @NotNull String projectName, @QueryParam(value="startingNumber") @Nullable Integer startingNumber, @QueryParam(value="projectLeadLogin") @NotNull String projectLeadLogin, @QueryParam(value="description") @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)projectLeadLogin, (String)"projectLeadLogin");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.CREATE_PROJECT, null, 2, null);
        ResponseUtilKt.ensure(StringsKt.indexOf$default((CharSequence)projectId, (String)"-", (int)0, (boolean)false, (int)6, null) < 0, "Dash is not allowed in [projectId].");
        ResponseUtilKt.isRequired("projectName", projectName);
        ResponseUtilKt.isRequired("projectLeadLogin", projectLeadLogin);
        ResponseUtilKt.ensure(startingNumber == null || startingNumber > 0, "Next issue number should be a positive integer.");
        return this.createProject(projectId, projectName, projectLeadLogin, description, startingNumber);
    }

    @PUT
    @Consumes(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final Response put(@NotNull ProjectBean project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.CREATE_PROJECT, null, 2, null);
        String projectName = project.getName();
        ResponseUtilKt.isRequired("name", projectName);
        String projectId = project.getId();
        ResponseUtilKt.isRequired("id", projectId);
        ResponseUtilKt.ensure(StringsKt.indexOf$default((CharSequence)projectId, (String)"-", (int)0, (boolean)false, (int)6, null) < 0, "Dash is not allowed in [id].");
        String leadLogin = project.getLead();
        ResponseUtilKt.isRequired("lead", leadLogin);
        String startingNumber = project.getStartingNumber();
        int parsedNumber = 1;
        if (startingNumber != null) {
            parsedNumber = Integer.parseInt(startingNumber);
            ResponseUtilKt.ensure(parsedNumber > 0, "Next issue number should be a positive integer.");
        }
        return this.createProject(projectId, projectName, leadLogin, project.getDescription(), parsedNumber);
    }

    @DELETE
    @Path(value="/{project}")
    @NotNull
    public final Response deleteProject(@PathParam(value="project") @NotNull String project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IsLoggedInSecurityConstraint.check();
        XdProject p = ProjectRestUtilKt.getProjectById(project);
        UserRestUtilKt.assertHasPermission(Permission.DELETE_PROJECT, p);
        p.deleteProject();
        RestUtil.waitForPermissionCacheRecalculation();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    private final Response createProject(String projectId, String projectName, String projectLeadLogin, String description, Integer startingNumber) {
        ProjectRestUtilKt.checkProjectDoesntExist(projectId);
        XdUser projectLead = XdUser.Companion.findUser(projectLeadLogin);
        ResponseUtilKt.assertExist("User", projectLead, projectLeadLogin, true);
        ProjectBuilder projectBuilder = BeansKt.getDefaultProjectTemplate().getProjectBuilder().withName(projectName).withShortName(projectId).withCreatedBy((Entity)BeansKt.getLoggedInUser());
        XdUser xdUser = projectLead;
        if (xdUser == null) {
            Intrinsics.throwNpe();
        }
        ProjectBuilder builder = projectBuilder.withLeader(xdUser.getEntity()).withDescription(description);
        if (startingNumber != null) {
            builder.withStartingNumber(Long.valueOf((long)startingNumber.intValue() - 1L));
        }
        builder.buildProject();
        LegacySupportKt.flush();
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtilKt.created(ProjectRestUtilKt.getProjectUrl(projectId));
    }
}

