/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.reports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RedirectUnauthorized;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.reports.ReportsService;
import jetbrains.youtrack.reports.impl.XdReport;
import jetbrains.youtrack.reports.impl.XdReportState;
import jetbrains.youtrack.reports.impl.agile.burndown.BurndownReportDataJson;
import jetbrains.youtrack.reports.impl.agile.burndown.XdBurndownReport;
import jetbrains.youtrack.reports.impl.agile.cumulative.CumulativeFlowReportDataJson;
import jetbrains.youtrack.reports.impl.agile.cumulative.XdCumulativeFlowReport;
import jetbrains.youtrack.reports.impl.distribution.ColumnsDataJson;
import jetbrains.youtrack.reports.impl.distribution.flat.XdFlatDistributionReport;
import jetbrains.youtrack.reports.impl.distribution.matrix.MatrixReportDataJson;
import jetbrains.youtrack.reports.impl.distribution.matrix.XdMatrixReport;
import jetbrains.youtrack.reports.impl.distribution.transition.XdAbstractTransitionReport;
import jetbrains.youtrack.reports.impl.elka.ElkaReportDataJson;
import jetbrains.youtrack.reports.impl.elka.XdElkaReport;
import jetbrains.youtrack.reports.impl.history.interval.IntervalReportDataJson;
import jetbrains.youtrack.reports.impl.history.interval.XdAbstractIntervalReport;
import jetbrains.youtrack.reports.impl.history.rate.RateReportDataJson;
import jetbrains.youtrack.reports.impl.history.rate.XdRateReport;
import jetbrains.youtrack.reports.impl.time.LoggedWorkJson;
import jetbrains.youtrack.reports.impl.time.simple.ByUserGrouping;
import jetbrains.youtrack.reports.impl.time.simple.TimeReportDataService;
import jetbrains.youtrack.reports.impl.time.simple.XdTimeReport;
import jetbrains.youtrack.rest.reports.BurndownDataBean;
import jetbrains.youtrack.rest.reports.CumulativeFlowBean;
import jetbrains.youtrack.rest.reports.CurrentReportsResource$get$1;
import jetbrains.youtrack.rest.reports.CustomDistributionReportDataBean;
import jetbrains.youtrack.rest.reports.FlatDistributionDataBean;
import jetbrains.youtrack.rest.reports.IntervalReportDataBean;
import jetbrains.youtrack.rest.reports.MatrixReportDataBean;
import jetbrains.youtrack.rest.reports.RateReportDataBean;
import jetbrains.youtrack.rest.reports.ReportBean;
import jetbrains.youtrack.rest.reports.ReportBeanShort;
import jetbrains.youtrack.rest.reports.ReportDataBean;
import jetbrains.youtrack.rest.reports.ReportDataError;
import jetbrains.youtrack.rest.reports.ReportParametersRender;
import jetbrains.youtrack.rest.reports.ReportWithDataBean;
import jetbrains.youtrack.rest.reports.TimeReportDataBean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Transactional
@Path(value="/current/reports")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@RedirectUnauthorized
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J$\u0010\u0010\u001a\u00020\u00112\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0007J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/rest/reports/CurrentReportsResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "reportParameters", "Ljetbrains/youtrack/rest/reports/ReportParametersRender;", "reportsService", "Ljetbrains/youtrack/reports/ReportsService;", "timeReportsDataService", "Ljetbrains/youtrack/reports/impl/time/simple/TimeReportDataService;", "assertCanRead", "", "report", "Ljetbrains/youtrack/reports/impl/XdReport;", "get", "", "Ljetbrains/youtrack/rest/reports/ReportBeanShort;", "getReport", "Ljetbrains/youtrack/rest/reports/ReportBean;", "", "fields", "", "recalculate", "Ljavax/ws/rs/core/Response;", "toDataJAXB", "Ljetbrains/youtrack/rest/reports/ReportDataBean;", "togglePinned", "youtrack-old-rest"})
public final class CurrentReportsResource
implements Resource {
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private ReportParametersRender reportParameters;
    @Autowired
    private TimeReportDataService timeReportsDataService;

    /*
     * WARNING - void declaration
     */
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final List<ReportBeanShort> get() {
        void var3_3;
        void $receiver$iv$iv;
        IsLoggedInSecurityConstraint.check();
        ReportsService reportsService = this.reportsService;
        if (reportsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportsService");
        }
        Iterable $receiver$iv = XdQueryKt.asIterable((XdQuery)XdQueryKt.sortedBy((XdQuery)ReportsService.accessibleReports$default((ReportsService)reportsService, null, (int)1, null), (KProperty1)((KProperty1)CurrentReportsResource$get$1.INSTANCE), (boolean)true));
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdReport xdReport = (XdReport)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ReportBeanShort reportBeanShort = new ReportBeanShort((XdReport<? extends Object>)it);
            collection.add(reportBeanShort);
        }
        return (List)var3_3;
    }

    @GET
    @Path(value="/{report}")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final ReportBean getReport(@Transformer(value="reportById") @PathParam(value="report") @NotNull XdReport<? extends Object> report, @QueryParam(value="fields") @Nullable String fields) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull(report, (String)"report");
        IsLoggedInSecurityConstraint.check();
        this.assertCanRead(report);
        ReportDataBean data = null;
        ReportDataBean oldData = null;
        if (fields != null && (charSequence = (CharSequence)fields).length() > 0) {
            if (StringsKt.contains$default((CharSequence)fields, (CharSequence)"reportData", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)report.getState(), (Object)XdReportState.Companion.getREADY()) || Intrinsics.areEqual((Object)report.getState(), (Object)XdReportState.Companion.getERROR())) {
                data = this.toDataJAXB(report);
            } else if (StringsKt.contains$default((CharSequence)fields, (CharSequence)"oldData", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)report.getState(), (Object)XdReportState.Companion.getCALCULATING())) {
                oldData = this.toDataJAXB(report);
            }
        }
        ReportParametersRender reportParametersRender = this.reportParameters;
        if (reportParametersRender == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportParameters");
        }
        return new ReportWithDataBean(report, reportParametersRender.parametersOf(report), data, oldData);
    }

    @PUT
    @Path(value="/{report}/recalculate")
    @NotNull
    public final Response recalculate(@Transformer(value="reportById") @PathParam(value="report") @NotNull XdReport<? extends Object> report) {
        Intrinsics.checkParameterIsNotNull(report, (String)"report");
        IsLoggedInSecurityConstraint.check();
        this.assertCanRead(report);
        ReportsService reportsService = this.reportsService;
        if (reportsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportsService");
        }
        reportsService.resetAndTriggerCalculation(report);
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @PUT
    @Path(value="/{report}/togglePinned")
    @NotNull
    public final ReportBeanShort togglePinned(@Transformer(value="reportById") @PathParam(value="report") @NotNull XdReport<? extends Object> report) {
        XdUser xdUser;
        Intrinsics.checkParameterIsNotNull(report, (String)"report");
        IsLoggedInSecurityConstraint.check();
        this.assertCanRead(report);
        XdUser it = xdUser = BeansKt.getXdLoggedInUser();
        boolean bl = false;
        boolean pinned = report.isPinned(it);
        report.setPinned(!pinned, it);
        return new ReportBeanShort(report);
    }

    private final void assertCanRead(XdReport<?> report) {
        if (!report.canRead(BeansKt.getXdLoggedInUser())) {
            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("canRead.You_don_t_have_premissions_to_view_the_requested_report", new Object[0]));
        }
    }

    private final ReportDataBean toDataJAXB(XdReport<?> report) {
        ReportDataBean reportDataBean;
        if (Intrinsics.areEqual((Object)report.getState(), (Object)XdReportState.Companion.getERROR())) {
            return new ReportDataError(report);
        }
        ReportsService reportsService = this.reportsService;
        if (reportsService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportsService");
        }
        Object object = reportsService.tryGetData(report);
        if (object == null) {
            return null;
        }
        Object data = object;
        XdReport<?> xdReport = report;
        if (xdReport instanceof XdElkaReport) {
            Object object2 = data;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.elka.ElkaReportDataJson");
            }
            reportDataBean = new CustomDistributionReportDataBean((XdElkaReport)report, (ElkaReportDataJson)object2);
        } else if (xdReport instanceof XdFlatDistributionReport) {
            Object object3 = data;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.distribution.ColumnsDataJson");
            }
            reportDataBean = new FlatDistributionDataBean(report, (ColumnsDataJson)object3);
        } else if (xdReport instanceof XdAbstractTransitionReport) {
            Object object4 = data;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.distribution.ColumnsDataJson");
            }
            reportDataBean = new FlatDistributionDataBean(report, (ColumnsDataJson)object4);
        } else if (xdReport instanceof XdAbstractIntervalReport) {
            Object object5 = data;
            if (object5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.history.interval.IntervalReportDataJson");
            }
            reportDataBean = new IntervalReportDataBean((XdAbstractIntervalReport)report, (IntervalReportDataJson)object5);
        } else if (xdReport instanceof XdRateReport) {
            Object object6 = data;
            if (object6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.history.rate.RateReportDataJson");
            }
            reportDataBean = new RateReportDataBean((XdRateReport)report, (RateReportDataJson)object6);
        } else if (xdReport instanceof XdMatrixReport) {
            Object object7 = data;
            if (object7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.distribution.matrix.MatrixReportDataJson");
            }
            reportDataBean = new MatrixReportDataBean((XdMatrixReport)report, (MatrixReportDataJson)object7);
        } else if (xdReport instanceof XdBurndownReport) {
            Object object8 = data;
            if (object8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.agile.burndown.BurndownReportDataJson");
            }
            reportDataBean = new BurndownDataBean((XdBurndownReport)report, (BurndownReportDataJson)object8);
        } else if (xdReport instanceof XdCumulativeFlowReport) {
            Object object9 = data;
            if (object9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.agile.cumulative.CumulativeFlowReportDataJson");
            }
            reportDataBean = new CumulativeFlowBean((XdCumulativeFlowReport)report, (CumulativeFlowReportDataJson)object9);
        } else if (xdReport instanceof XdTimeReport) {
            String string = ByUserGrouping.INSTANCE.getId();
            TimeReportDataService timeReportDataService = this.timeReportsDataService;
            if (timeReportDataService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeReportsDataService");
            }
            boolean perUser = Intrinsics.areEqual((Object)string, (Object)timeReportDataService.findGrouping((XdTimeReport)report));
            XdTimeReport xdTimeReport = (XdTimeReport)report;
            TimeReportDataService timeReportDataService2 = this.timeReportsDataService;
            if (timeReportDataService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeReportsDataService");
            }
            Object object10 = data;
            if (object10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.reports.impl.time.LoggedWorkJson");
            }
            reportDataBean = new TimeReportDataBean(xdTimeReport, timeReportDataService2.newDataView((XdTimeReport)report, (LoggedWorkJson)object10), perUser);
        } else {
            reportDataBean = null;
        }
        return reportDataBean;
    }
}

