/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.reports;

import java.util.Locale;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.core.dates.DateFormats;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.reports.BeansKt;
import jetbrains.youtrack.reports.impl.XdReport;
import jetbrains.youtrack.rest.group.UserGroupRef;
import jetbrains.youtrack.rest.reports.ReportWithDataBean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

@XmlRootElement(name="report")
@XmlType(name="ReportBean")
@XmlSeeAlso(value={ReportWithDataBean.class})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0016\u0010\u0019\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0016\u0010\u001b\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\bR\u0016\u0010!\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\bR\u0018\u0010#\u001a\u0004\u0018\u00010$8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Ljetbrains/youtrack/rest/reports/ReportBean;", "", "report", "Ljetbrains/youtrack/reports/impl/XdReport;", "(Ljetbrains/youtrack/reports/impl/XdReport;)V", "id", "", "getId", "()Ljava/lang/String;", "invalidationInterval", "", "getInvalidationInterval", "()J", "lastCalculated", "getLastCalculated", "name", "getName", "own", "", "getOwn", "()Z", "owner", "getOwner", "ownerLogin", "getOwnerLogin", "pinned", "getPinned", "progress", "", "getProgress", "()I", "state", "getState", "type", "getType", "visibleTo", "Ljetbrains/youtrack/rest/group/UserGroupRef;", "getVisibleTo", "()Ljetbrains/youtrack/rest/group/UserGroupRef;", "youtrack-old-rest"})
public class ReportBean {
    @XmlAttribute(name="id")
    @NotNull
    private final String id;
    @XmlAttribute(name="name")
    @Nullable
    private final String name;
    @XmlAttribute(name="type")
    @NotNull
    private final String type;
    @XmlAttribute(name="own")
    private final boolean own;
    @XmlAttribute(name="owner")
    @NotNull
    private final String owner;
    @XmlAttribute(name="pinned")
    private final boolean pinned;
    @XmlAttribute(name="ownerLogin")
    @Nullable
    private final String ownerLogin;
    @XmlAttribute(name="visibleTo")
    @Nullable
    private final UserGroupRef visibleTo;
    @XmlAttribute(name="invalidationInterval")
    private final long invalidationInterval;
    @XmlAttribute(name="state")
    @Nullable
    private final String state;
    @XmlAttribute(name="lastCalculated")
    @NotNull
    private final String lastCalculated;
    @XmlAttribute(name="progress")
    private final int progress;

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final boolean getOwn() {
        return this.own;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    public final boolean getPinned() {
        return this.pinned;
    }

    @Nullable
    public final String getOwnerLogin() {
        return this.ownerLogin;
    }

    @Nullable
    public final UserGroupRef getVisibleTo() {
        return this.visibleTo;
    }

    public final long getInvalidationInterval() {
        return this.invalidationInterval;
    }

    @Nullable
    public final String getState() {
        return this.state;
    }

    @NotNull
    public final String getLastCalculated() {
        return this.lastCalculated;
    }

    public final int getProgress() {
        return this.progress;
    }

    public ReportBean(@NotNull XdReport<? extends Object> report) {
        UserGroupRef userGroupRef;
        Intrinsics.checkParameterIsNotNull(report, (String)"report");
        this.id = report.getXdId();
        this.name = report.getName();
        this.type = report.getType();
        this.own = Intrinsics.areEqual((Object)report.getOwner(), (Object)jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser());
        this.owner = report.getOwner().getVisibleName();
        this.pinned = report.isPinned(jetbrains.charisma.persistent.BeansKt.getXdLoggedInUser());
        this.ownerLogin = report.getOwner().getLogin();
        ReportBean reportBean = this;
        XdUserGroup xdUserGroup = report.getVisibleTo();
        if (xdUserGroup != null) {
            XdUserGroup xdUserGroup2 = xdUserGroup;
            ReportBean reportBean2 = reportBean;
            XdUserGroup it = xdUserGroup2;
            boolean bl = false;
            UserGroupRef userGroupRef2 = new UserGroupRef(it);
            reportBean = reportBean2;
            userGroupRef = userGroupRef2;
        } else {
            userGroupRef = null;
        }
        reportBean.visibleTo = userGroupRef;
        this.invalidationInterval = report.getInvalidationInterval();
        this.state = report.getState().getName();
        this.progress = BeansKt.getReportsCalculationService().progressOf(report);
        Long l = report.getLastCalculated();
        GeneralUserProfile generalUserProfile = jetbrains.charisma.persistent.BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        DateTime dateTime = DateTimeOperations.convert((Long)l, (DateTimeZone)generalUserProfile.getTimeZone());
        String string = DateTimeOperations.print((DateTime)dateTime, (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("optimal"), (Locale)jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().getLocale());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DateTimeOperations.print\u2026imal\"), localizer.locale)");
        this.lastCalculated = string;
    }
}

