/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.rest.RestUtil;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.user.PasswordGenerator;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.persistent.security.XdUserRole;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.group.AdminGroupResourceKt;
import jetbrains.youtrack.rest.group.UserGroupRef;
import jetbrains.youtrack.rest.role.RolesRestUtilKt;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import jetbrains.youtrack.rest.user.beans.UserBean;
import jetbrains.youtrack.rest.user.beans.UserRef;
import jetbrains.youtrack.rest.user.beans.UserRole;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Path(value="/admin/user")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007JB\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\b2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0007J6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0002JP\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\b\u0001\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0087\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J6\u0010 \u001a\u00020\u001b2\b\b\u0001\u0010\n\u001a\u00020\b2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\bH\u0007J\u001c\u0010!\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\""}, d2={"Ljetbrains/youtrack/rest/user/AdminUserResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "addUserToGroup", "Ljavax/ws/rs/core/Response;", "user", "Ljetbrains/youtrack/persistent/XdUser;", "group", "", "createUser", "login", "fullName", "email", "jabber", "password", "find", "Lkotlin/sequences/Sequence;", "role", "project", "permission", "get", "", "Ljetbrains/youtrack/rest/user/beans/UserRef;", "start", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/List;", "getByLogin", "Ljetbrains/youtrack/rest/user/beans/UserBean;", "getLoginRole", "Ljetbrains/youtrack/rest/user/beans/UserRole;", "getUserGroups", "Ljetbrains/youtrack/rest/group/UserGroupRef;", "post", "removeUserFromGroup", "youtrack-old-rest"})
public final class AdminUserResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<UserRef> get(@QueryParam(value="group") @Nullable String group, @QueryParam(value="role") @Nullable String role2, @QueryParam(value="project") @Nullable String project, @QueryParam(value="permission") @Nullable String permission, @QueryParam(value="start") @Nullable Integer start) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USER, null, 2, null);
        Sequence<XdUser> sequence2 = $receiver$iv = this.find(group, role2, project, permission);
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                XdUser it = (XdUser)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getLogin());
                it = (XdUser)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = it.getLogin();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        Integer n = start;
        List users = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)SequencesKt.sortedWith(sequence2, (Comparator)comparator), (int)(n != null ? n : 0)), (int)10));
        sequence2 = $receiver$iv = (Iterable)users;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdUser xdUser = (XdUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserRef userRef = new UserRef((XdUser)it);
            collection.add(userRef);
        }
        return (List)destination$iv$iv;
    }

    @GET
    @Path(value="/{login}")
    @NotNull
    public final UserBean getByLogin(@Transformer(value="userByLogin") @PathParam(value="login") @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USER, null, 2, null);
        UserRestUtilKt.assertHasPermission$default(Permission.READ_NOT_OWN_PROFILE, null, 2, null);
        UserRestUtilKt.assertHasPermission$default(Permission.READ_PROFILE, null, 2, null);
        return new UserBean(user2);
    }

    @PUT
    @Path(value="/{login}")
    @NotNull
    public final Response createUser(@PathParam(value="login") @NotNull String login, @QueryParam(value="fullName") @Nullable String fullName, @QueryParam(value="email") @Nullable String email, @QueryParam(value="jabber") @Nullable String jabber, @QueryParam(value="password") @Nullable String password) {
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission(Permission.CREATE_USER, null);
        XdUser user2 = XdUser.Companion.new((Function1)new Function1<XdUser, Unit>(login, password, fullName, email, jabber){
            final /* synthetic */ String $login;
            final /* synthetic */ String $password;
            final /* synthetic */ String $fullName;
            final /* synthetic */ String $email;
            final /* synthetic */ String $jabber;

            public final void invoke(@NotNull XdUser $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                $receiver.setLogin(this.$login);
                String string = this.$password;
                if (string == null) {
                    String string2 = PasswordGenerator.generate();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PasswordGenerator.generate()");
                }
                $receiver.setPassword(string);
                String string3 = this.$fullName;
                if (string3 == null) {
                    string3 = this.$login;
                }
                $receiver.setFullName(string3);
                $receiver.setEmail(this.$email);
                $receiver.setJabberAccountName(this.$jabber);
            }
            {
                this.$login = string;
                this.$password = string2;
                this.$fullName = string3;
                this.$email = string4;
                this.$jabber = string5;
                super(1);
            }
        });
        user2.fixLogin();
        RestUtil.waitForPermissionCacheRecalculation();
        return ResponseUtilKt.created(UserRestUtilKt.getUserUrl(user2.getLogin()));
    }

    @POST
    @NotNull
    public final UserBean post(@QueryParam(value="login") @NotNull String login, @QueryParam(value="fullName") @Nullable String fullName, @QueryParam(value="email") @Nullable String email, @QueryParam(value="jabber") @Nullable String jabber) {
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        IsLoggedInSecurityConstraint.check();
        XdUser xdUser = XdUser.Companion.findUser(login);
        if (xdUser == null) {
            xdUser = XdUser.Companion.new((Function1)new Function1<XdUser, Unit>(login, email, fullName){
                final /* synthetic */ String $login;
                final /* synthetic */ String $email;
                final /* synthetic */ String $fullName;

                public final void invoke(@NotNull XdUser $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    $receiver.setLogin(this.$login);
                    $receiver.setEmail(this.$email);
                    String string = PasswordGenerator.generate();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PasswordGenerator.generate()");
                    $receiver.setPassword(string);
                    String string2 = this.$fullName;
                    if (string2 == null) {
                        string2 = this.$login;
                    }
                    $receiver.setFullName(string2);
                }
                {
                    this.$login = string;
                    this.$email = string2;
                    this.$fullName = string3;
                    super(1);
                }
            });
        }
        XdUser user2 = xdUser;
        CharSequence charSequence = fullName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            user2.setFullName(fullName);
        }
        if (!((charSequence = (CharSequence)email) == null || charSequence.length() == 0)) {
            user2.setEmail(email);
        }
        if (!((charSequence = (CharSequence)jabber) == null || charSequence.length() == 0)) {
            user2.setJabberAccountName(jabber);
        }
        LegacySupportKt.flush();
        return new UserBean(user2);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{login}/group")
    @NotNull
    public final List<UserGroupRef> getUserGroups(@Transformer(value="userByLogin") @PathParam(value="login") @NotNull XdUser user2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USER, null, 2, null);
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USERGROUP, null, 2, null);
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.plus((Collection)XdQueryKt.toList((XdQuery)((XdQuery)user2.getGroups())), (Object)BeansKt.getXdAllUsersGroup());
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdUserGroup xdUserGroup = (XdUserGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserGroupRef userGroupRef = new UserGroupRef((XdUserGroup)it);
            collection.add(userGroupRef);
        }
        return (List)destination$iv$iv;
    }

    @POST
    @Path(value="/{login}/group/{group}")
    @NotNull
    public final Response addUserToGroup(@Transformer(value="userByLogin") @PathParam(value="login") @NotNull XdUser user2, @PathParam(value="group") @NotNull String group) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission(Permission.UPDATE_USER, null);
        UserRestUtilKt.assertHasPermission(Permission.READ_USERGROUP, null);
        XdUserGroup ug = AdminGroupResourceKt.getGroupByName(group);
        BeansKt.getSecurity().addUserToUserGroup(user2.getEntity(), ug.getEntity());
        RestUtil.waitForPermissionCacheRecalculation();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @DELETE
    @Path(value="/{login}/group/{group}")
    @NotNull
    public final Response removeUserFromGroup(@Transformer(value="userByLogin") @PathParam(value="login") @NotNull XdUser user2, @PathParam(value="group") @NotNull String group) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_USER, null, 2, null);
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USERGROUP, null, 2, null);
        XdUserGroup ug = AdminGroupResourceKt.getGroupByName(group);
        BeansKt.getSecurity().removeUserFromUserGroup(user2.getEntity(), ug.getEntity());
        RestUtil.waitForPermissionCacheRecalculation();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/{login}/role")
    @NotNull
    public final List<UserRole> getLoginRole(@Transformer(value="userByLogin") @PathParam(value="login") @NotNull XdUser user2) {
        void $receiver$iv$iv;
        Iterable<XdUserRole> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.READ_USER, null, 2, null);
        UserRestUtilKt.assertHasPermission$default(Permission.READ_ROLE, null, 2, null);
        Iterable<XdUserRole> iterable = $receiver$iv = UserRestUtilKt.getUserRolesLegacy(user2);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdUserRole xdUserRole = (XdUserRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UserRole userRole = new UserRole(it.getRole().getName(), XdQueryKt.toList((XdQuery)((XdQuery)it.getProjects())));
            collection.add(userRole);
        }
        return (List)destination$iv$iv;
    }

    private final Sequence<XdUser> find(String group, String role2, String project, String permission) {
        XdProject xdProject;
        CharSequence charSequence = group;
        XdUserGroup userGroup2 = !(charSequence == null || charSequence.length() == 0) ? AdminGroupResourceKt.getGroupByName(group) : null;
        CharSequence charSequence2 = role2;
        XdRole userRole = !(charSequence2 == null || charSequence2.length() == 0) ? RolesRestUtilKt.getRoleByName(role2) : null;
        CharSequence charSequence3 = project;
        if (!(charSequence3 == null || charSequence3.length() == 0)) {
            xdProject = XdProject.Companion.findByKey(project);
            if (xdProject == null) {
                Intrinsics.throwNpe();
            }
        } else {
            xdProject = null;
        }
        XdProject userProject = xdProject;
        CharSequence charSequence4 = permission;
        Permission userPermission = !(charSequence4 == null || charSequence4.length() == 0) ? Permission.valueOf((String)permission) : null;
        return UserRestUtilKt.getFilteredUsers(userGroup2, userRole, userProject, userPermission);
    }
}

