/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.persistent.security.XdRole;
import jetbrains.youtrack.persistent.security.XdUserRole;
import jetbrains.youtrack.rest.ResponseUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.url.UrlUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a4\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0006\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"updatableByGroupName", "", "visibleForGroupName", "assertCanReadProfile", "", "targetUser", "Ljetbrains/youtrack/persistent/XdUser;", "assertHasPermission", "permission", "Ljetbrains/youtrack/core/security/Permission;", "project", "Ljetbrains/youtrack/persistent/XdProject;", "getFilteredUsers", "Lkotlin/sequences/Sequence;", "group", "Ljetbrains/youtrack/persistent/XdUserGroup;", "role", "Ljetbrains/youtrack/persistent/security/XdRole;", "getShareGroup", "parameterName", "name", "getUserRolesLegacy", "", "Ljetbrains/youtrack/persistent/security/XdUserRole;", "user", "getUserUrl", "Lwebr/framework/url/UrlUtil$Url;", "userLogin", "youtrack-old-rest"})
public final class UserRestUtilKt {
    @NotNull
    public static final String visibleForGroupName = "visibleForGroup";
    @NotNull
    public static final String updatableByGroupName = "updatableByGroup";

    public static final void assertCanReadProfile(@NotNull XdUser targetUser) {
        Intrinsics.checkParameterIsNotNull((Object)targetUser, (String)"targetUser");
        if (!jetbrains.charisma.service.BeansKt.getUserProfileService().isProfileAccessible(Operation.READ, targetUser)) {
            throw (Throwable)new ForbiddenException("User not found or you have no permission to read user.");
        }
    }

    public static final void assertHasPermission(@NotNull Permission permission, @Nullable XdProject project) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (project == null) {
            if (!BeansKt.getXdLoggedInUser().hasPermission(permission)) {
                throw (Throwable)new ForbiddenException("You have no permission to " + permission.getLowercasedHumanizedName() + '.');
            }
        } else {
            if (project.getArchived() && !BeansKt.getXdLoggedInUser().hasPermission(Permission.ADMIN_UPDATE_APP)) {
                throw (Throwable)new ForbiddenException("Project " + project.getShortName() + " is archived.");
            }
            if (!BeansKt.getXdLoggedInUser().hasPermissionInProject(permission, new XdProject[]{project})) {
                throw (Throwable)new ForbiddenException("In project " + project.getShortName() + " you have no permission to " + permission.getLowercasedHumanizedName() + '.');
            }
        }
    }

    public static /* synthetic */ void assertHasPermission$default(Permission permission, XdProject xdProject, int n, Object object) {
        if ((n & 2) != 0) {
            xdProject = null;
        }
        UserRestUtilKt.assertHasPermission(permission, xdProject);
    }

    @Nullable
    public static final XdUserGroup getShareGroup(@NotNull String parameterName, @Nullable String name) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
        if (name != null && (charSequence = (CharSequence)name).length() > 0) {
            UserRestUtilKt.assertHasPermission$default(Permission.SHARE_WATCH_FOLDER, null, 2, null);
            XdUserGroup group = XdUserGroup.Companion.find(name);
            ResponseUtilKt.assertExist(parameterName, group, name, true);
            return group;
        }
        return null;
    }

    @NotNull
    public static final Sequence<XdUser> getFilteredUsers(@Nullable XdUserGroup group, @Nullable XdRole role2, @Nullable XdProject project, @Nullable Permission permission) {
        if (role2 != null && permission != null && !role2.hasPermission(permission)) {
            return SequencesKt.emptySequence();
        }
        XdUserGroup xdUserGroup = group;
        if (xdUserGroup == null || (xdUserGroup = xdUserGroup.getAggregatedUsers()) == null) {
            xdUserGroup = XdUser.Companion.getAllUsers();
        }
        Sequence users = XdQueryKt.asSequence((XdQuery)xdUserGroup);
        if (role2 != null) {
            return project != null ? SequencesKt.filter((Sequence)users, (Function1)((Function1)new Function1<XdUser, Boolean>(role2, project){
                final /* synthetic */ XdRole $role;
                final /* synthetic */ XdProject $project;

                public final boolean invoke(@NotNull XdUser it) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Iterable<XdUserRole> $receiver$iv = UserRestUtilKt.getUserRolesLegacy(it);
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<XdUserRole> iterator = $receiver$iv.iterator();
                            while (iterator.hasNext()) {
                                XdUserRole element$iv;
                                XdUserRole r = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!(Intrinsics.areEqual((Object)r.getRole(), (Object)this.$role) && XdQueryKt.contains((XdQuery)((XdQuery)r.getProjects()), (XdEntity)((XdEntity)this.$project)))) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
                {
                    this.$role = xdRole;
                    this.$project = xdProject;
                    super(1);
                }
            })) : SequencesKt.filter((Sequence)users, (Function1)((Function1)new Function1<XdUser, Boolean>(role2){
                final /* synthetic */ XdRole $role;

                public final boolean invoke(@NotNull XdUser it) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Iterable<XdUserRole> $receiver$iv = UserRestUtilKt.getUserRolesLegacy(it);
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<XdUserRole> iterator = $receiver$iv.iterator();
                            while (iterator.hasNext()) {
                                XdUserRole element$iv;
                                XdUserRole r = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)r.getRole(), (Object)this.$role)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
                {
                    this.$role = xdRole;
                    super(1);
                }
            }));
        }
        return users;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<XdUserRole> getUserRolesLegacy(@NotNull XdUser user2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable((XdQuery)((XdQuery)user2.getGroups()));
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdUserGroup it = (XdUserGroup)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = XdQueryKt.asIterable((XdQuery)it.getUserRoles());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List groupRoles = (List)destination$iv$iv;
        iterable = $receiver$iv = (Iterable)CollectionsKt.plus((Iterable)XdQueryKt.asIterable((XdQuery)((XdQuery)user2.getUserRoles())), (Iterable)groupRoles);
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                XdUserRole it = (XdUserRole)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getRole().getName());
                it = (XdUserRole)b;
                Comparable comparable2 = comparable;
                bl = false;
                String string = it.getRole().getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    @NotNull
    public static final UrlUtil.Url getUserUrl(@NotNull String userLogin) {
        Intrinsics.checkParameterIsNotNull((Object)userLogin, (String)"userLogin");
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"admin", "user"}).addPathElements(new String[]{userLogin}).addQueryParameters(new QueryParameter[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"UrlUtil.getRestPathUri(\"\u2026gin).addQueryParameters()");
        return url;
    }
}

