/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.charisma.smartui.persistent.UserSearchRequest;
import jetbrains.charisma.smartui.watchFolder.SavedQueryImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.BadRequestException;
import jetbrains.mps.webr.rpc.rest.provider.exception.RESTAlreadyExistsException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdSavedQuery;
import jetbrains.youtrack.persistent.XdWatchFolder;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import jetbrains.youtrack.rest.user.UserSearchResource$assertNotExists$1;
import jetbrains.youtrack.rest.user.UserSearchResource$get$1;
import jetbrains.youtrack.rest.user.beans.SavedSearch;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Path(value="/user/search")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\r2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002JB\u0010\u0013\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0007J>\u0010\u0018\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00062\b\b\u0001\u0010\u0019\u001a\u00020\u00062\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0017\u001a\u00020\u0006H\u0007\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/rest/user/UserSearchResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "assertNotExists", "", "name", "", "deleteSavedQuery", "Ljavax/ws/rs/core/Response;", "savedQuery", "Ljetbrains/youtrack/persistent/XdSavedQuery;", "get", "", "Ljetbrains/youtrack/rest/user/beans/SavedSearch;", "getQueries", "Lkotlinx/dnq/query/XdQuery;", "getSavedQuery", "getUrl", "Lwebr/framework/url/UrlUtil$Url;", "postSavedQuery", "newName", "visibleForGroup", "updatableByGroup", "q", "putSavedQuery", "projectShortName", "youtrack-old-rest"})
public final class UserSearchResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<SavedSearch> get() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        IsLoggedInSecurityConstraint.check();
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable((XdQuery)XdQueryKt.sortedBy$default(this.getQueries(), (KProperty1)((KProperty1)UserSearchResource$get$1.INSTANCE), (boolean)false, (int)2, null));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdSavedQuery xdSavedQuery = (XdSavedQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SavedSearch savedSearch = new SavedSearch((XdSavedQuery)it);
            collection.add(savedSearch);
        }
        return (List)var3_3;
    }

    @GET
    @Path(value="/{savedQuery}")
    @NotNull
    public final SavedSearch getSavedQuery(@Transformer(value="searchName") @PathParam(value="savedQuery") @NotNull XdSavedQuery savedQuery) {
        Intrinsics.checkParameterIsNotNull((Object)savedQuery, (String)"savedQuery");
        IsLoggedInSecurityConstraint.check();
        return new SavedSearch(savedQuery);
    }

    @PUT
    @Path(value="/{savedQuery}")
    @NotNull
    public final Response putSavedQuery(@PathParam(value="savedQuery") @NotNull String savedQuery, @QueryParam(value="projectShortName") @NotNull String projectShortName, @QueryParam(value="visibleForGroup") @Nullable String visibleForGroup, @QueryParam(value="updatableByGroup") @Nullable String updatableByGroup, @QueryParam(value="q") @NotNull String q2) {
        Intrinsics.checkParameterIsNotNull((Object)savedQuery, (String)"savedQuery");
        Intrinsics.checkParameterIsNotNull((Object)projectShortName, (String)"projectShortName");
        Intrinsics.checkParameterIsNotNull((Object)q2, (String)"q");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.CREATE_WATCH_FOLDER, null, 2, null);
        this.assertNotExists(savedQuery);
        ResponseUtilKt.isRequired("query", q2);
        UserSearchRequest request = jetbrains.charisma.service.BeansKt.getUserProfileService().getSearchRequest(BeansKt.getXdLoggedInUser());
        XdProject project = XdProject.Companion.findByKey(projectShortName);
        Entity entity = request.save(savedQuery, (project != null ? "project: " + projectShortName + ' ' : "") + q2);
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"request.save(savedQuery,\u2026ShortName \" else \"\") + q)");
        XdWatchFolder savedSearch = (XdWatchFolder)XdExtensionsKt.toXd((Entity)entity);
        savedSearch.shareWith(UserRestUtilKt.getShareGroup("visibleForGroup", visibleForGroup));
        savedSearch.shareUpdateWith(UserRestUtilKt.getShareGroup("updatableByGroup", updatableByGroup));
        return ResponseUtilKt.created(this.getUrl(savedQuery));
    }

    @POST
    @Path(value="/{savedQuery}")
    @NotNull
    public final Response postSavedQuery(@Transformer(value="searchName") @PathParam(value="savedQuery") @NotNull XdSavedQuery savedQuery, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="visibleForGroup") @Nullable String visibleForGroup, @QueryParam(value="updatableByGroup") @Nullable String updatableByGroup, @QueryParam(value="q") @Nullable String q2) {
        CharSequence charSequence;
        CharSequence charSequence2;
        Intrinsics.checkParameterIsNotNull((Object)savedQuery, (String)"savedQuery");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_WATCH_FOLDER, null, 2, null);
        if (q2 == null || (charSequence2 = (CharSequence)q2).length() == 0) {
            throw (Throwable)new BadRequestException("Search request is empty.");
        }
        savedQuery.setQuery(q2);
        String oldName = savedQuery.getName();
        if (newName != null && (charSequence = (CharSequence)newName).length() > 0 && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            this.assertNotExists(newName);
            savedQuery.setName(newName);
        }
        if (visibleForGroup != null) {
            savedQuery.shareWith(UserRestUtilKt.getShareGroup("visibleForGroup", visibleForGroup));
        }
        if (updatableByGroup != null) {
            savedQuery.shareUpdateWith(UserRestUtilKt.getShareGroup("updatableByGroup", updatableByGroup));
        }
        return ResponseUtilKt.updated(this.getUrl(savedQuery.getName()), oldName, newName);
    }

    @DELETE
    @Path(value="/{savedQuery}")
    @NotNull
    public final Response deleteSavedQuery(@Transformer(value="searchName") @PathParam(value="savedQuery") @NotNull XdSavedQuery savedQuery) {
        Intrinsics.checkParameterIsNotNull((Object)savedQuery, (String)"savedQuery");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.DELETE_WATCH_FOLDER, null, 2, null);
        return ResponseUtilKt.deleted$default((XdEntity)savedQuery, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void assertNotExists(String name) {
        void $receiver$iv;
        NodeBase nodeBase;
        KProperty1 kProperty1 = (KProperty1)UserSearchResource$assertNotExists$1.INSTANCE;
        XdQuery<XdSavedQuery> xdQuery = this.getQueries();
        if (XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query(xdQuery, (NodeBase)(nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdSavedQuery.class)), (Comparable)((Comparable)((Object)name))))))) {
            throw (Throwable)new RESTAlreadyExistsException("Search request", name);
        }
    }

    private final UrlUtil.Url getUrl(String name) {
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"user", "search"}).addPathElements(new String[]{name}).addQueryParameters(new QueryParameter[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"UrlUtil.getRestPathUri(\"\u2026ame).addQueryParameters()");
        return url;
    }

    private final XdQuery<XdSavedQuery> getQueries() {
        return XdQueryKt.asQuery((Iterable)SavedQueryImpl.getOwn((Entity)((Entity)BeansKt.getLoggedInUser())), (XdEntityType)((XdEntityType)XdSavedQuery.Companion));
    }
}

