/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.rest.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.rest.IsLoggedInSecurityConstraint;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.provider.exception.RESTAlreadyExistsException;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.core.watchFolder.RuleType;
import jetbrains.youtrack.persistent.XdIssueTag;
import jetbrains.youtrack.rest.ResponseUtilKt;
import jetbrains.youtrack.rest.user.UserRestUtilKt;
import jetbrains.youtrack.rest.user.beans.Tag;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Path(value="/user/tag")
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@Transactional
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u0012\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0002JG\u0010\u0012\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J;\u0010\u0019\u001a\u00020\b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/rest/user/UserTagResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "assertNotExist", "", "tagName", "", "deleteTag", "Ljavax/ws/rs/core/Response;", "tag", "Ljetbrains/youtrack/persistent/XdIssueTag;", "get", "", "Ljetbrains/youtrack/rest/user/beans/Tag;", "getTag", "getUrl", "Lwebr/framework/url/UrlUtil$Url;", "name", "postTag", "newName", "visibleForGroup", "updatableByGroup", "untagOnResolve", "", "(Ljetbrains/youtrack/persistent/XdIssueTag;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "putTagName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)Ljavax/ws/rs/core/Response;", "youtrack-old-rest"})
public final class UserTagResource
implements Resource {
    /*
     * WARNING - void declaration
     */
    @GET
    @NotNull
    public final List<Tag> get() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        IsLoggedInSecurityConstraint.check();
        Iterable iterable = $receiver$iv = XdQueryKt.asIterable((XdQuery)jetbrains.charisma.service.BeansKt.getWatchFolderService().findTags(BeansKt.getXdLoggedInUser()));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            XdIssueTag xdIssueTag = (XdIssueTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Tag tag = new Tag((XdIssueTag)it);
            collection.add(tag);
        }
        return (List)var3_3;
    }

    @GET
    @Path(value="/{tag}")
    @NotNull
    public final Tag getTag(@Transformer(value="tagName") @PathParam(value="tag") @NotNull XdIssueTag tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IsLoggedInSecurityConstraint.check();
        return new Tag(tag);
    }

    @PUT
    @Path(value="/{tagName}")
    @NotNull
    public final Response putTagName(@PathParam(value="tagName") @NotNull String tagName, @QueryParam(value="visibleForGroup") @Nullable String visibleForGroup, @QueryParam(value="updatableByGroup") @Nullable String updatableByGroup, @QueryParam(value="untagOnResolve") @Nullable Boolean untagOnResolve) {
        Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.CREATE_WATCH_FOLDER, null, 2, null);
        this.assertNotExist(tagName);
        XdIssueTag xdIssueTag = XdIssueTag.Companion.findOrCreate(BeansKt.getXdLoggedInUser(), tagName);
        if (xdIssueTag == null) {
            Intrinsics.throwNpe();
        }
        XdIssueTag tag = xdIssueTag;
        tag.shareWith(UserRestUtilKt.getShareGroup("visibleForGroup", visibleForGroup));
        tag.shareUpdateWith(UserRestUtilKt.getShareGroup("updatableByGroup", updatableByGroup));
        Boolean bl = untagOnResolve;
        tag.setWatched(BeansKt.getXdLoggedInUser(), RuleType.UNTAG_ON_RESOLVE, bl != null ? bl : false);
        return ResponseUtilKt.created(this.getUrl(tagName));
    }

    @POST
    @Path(value="/{tag}")
    @NotNull
    public final Response postTag(@Transformer(value="tagName") @PathParam(value="tag") @NotNull XdIssueTag tag, @QueryParam(value="newName") @Nullable String newName, @QueryParam(value="visibleForGroup") @Nullable String visibleForGroup, @QueryParam(value="updatableByGroup") @Nullable String updatableByGroup, @QueryParam(value="untagOnResolve") @Nullable Boolean untagOnResolve) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.UPDATE_WATCH_FOLDER, null, 2, null);
        String oldName = tag.getName();
        if (newName != null && (charSequence = (CharSequence)newName).length() > 0 && Intrinsics.areEqual((Object)newName, (Object)oldName) ^ true) {
            this.assertNotExist(newName);
            tag.setName(newName);
        }
        if (visibleForGroup != null) {
            tag.shareWith(UserRestUtilKt.getShareGroup("visibleForGroup", visibleForGroup));
        }
        if (updatableByGroup != null) {
            tag.shareUpdateWith(UserRestUtilKt.getShareGroup("updatableByGroup", updatableByGroup));
        }
        if (untagOnResolve != null) {
            tag.setWatched(tag.getOwner(), RuleType.UNTAG_ON_RESOLVE, untagOnResolve.booleanValue());
        }
        return ResponseUtilKt.updated(this.getUrl(tag.getName()), oldName, newName);
    }

    @DELETE
    @Path(value="/{tag}")
    @NotNull
    public final Response deleteTag(@Transformer(value="tagName") @PathParam(value="tag") @NotNull XdIssueTag tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IsLoggedInSecurityConstraint.check();
        UserRestUtilKt.assertHasPermission$default(Permission.DELETE_WATCH_FOLDER, null, 2, null);
        return ResponseUtilKt.deleted$default((XdEntity)tag, false, 2, null);
    }

    private final void assertNotExist(String tagName) {
        if (XdIssueTag.Companion.find(BeansKt.getXdLoggedInUser(), tagName) != null) {
            throw (Throwable)new RESTAlreadyExistsException("Tag", tagName);
        }
    }

    private final UrlUtil.Url getUrl(String name) {
        UrlUtil.Url url = UrlUtil.getRestPathUri((String[])new String[]{"user", "tag"});
        String[] stringArray = new String[1];
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = string;
        UrlUtil.Url url2 = url.addPathElements(stringArray).addQueryParameters(new QueryParameter[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"UrlUtil.getRestPathUri(\"\u2026e!!).addQueryParameters()");
        return url2;
    }
}

