/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.InvalidAuthorizationHeaderException;
import com.intellij.hub.auth.InvalidPermanentTokenException;
import com.intellij.hub.auth.InvalidTokenDataException;
import com.intellij.hub.auth.InvalidTokenScopeException;
import com.intellij.hub.auth.InvalidTokenSignatureException;
import com.intellij.hub.auth.InvalidTokenUserException;
import com.intellij.hub.auth.OAuthException;
import com.intellij.hub.auth.TokenExpiredException;
import com.intellij.hub.auth.UnknownTokenClientException;
import com.intellij.hub.auth.oauth2.error.VerifyTokenErrorCode;
import com.intellij.hub.core.Error;
import java.util.Arrays;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public abstract class InvalidTokenException
extends OAuthException {
    private final VerifyTokenErrorCode code;
    private final String description;

    protected InvalidTokenException(VerifyTokenErrorCode code) {
        this(code, code.getDescription());
    }

    protected InvalidTokenException(VerifyTokenErrorCode code, String description) {
        super(description);
        this.code = code;
        this.description = description;
    }

    protected InvalidTokenException(VerifyTokenErrorCode code, Throwable cause) {
        this(code, code.getDescription(), cause);
    }

    protected InvalidTokenException(VerifyTokenErrorCode code, String description, Throwable cause) {
        super(description, cause);
        this.code = code;
        this.description = description;
    }

    public VerifyTokenErrorCode getCode() {
        return this.code;
    }

    @Override
    public Error getOAuthError() {
        String description;
        String devDescription = description = this.description != null ? this.description : this.code.getDescription();
        Throwable cause = this.getCause();
        if (cause != null && cause != this) {
            devDescription = description + ": " + cause.getMessage();
        }
        return this.code.createError(description, devDescription, null);
    }

    public static InvalidTokenException malformedBasicToken(int decodedParts) {
        return new InvalidTokenDataException(VerifyTokenErrorCode.BASIC_TOKEN_MALFORMED, "Unable to decode basic token. Number of decoded parts: " + decodedParts);
    }

    public static InvalidTokenException malformedOAuthToken() {
        return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_MALFORMED);
    }

    public static InvalidTokenException malformedTokenVersion(NumberFormatException e) {
        return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_VERSION_MALFORMED, (Throwable)e);
    }

    public static InvalidTokenException malformedTokenSignature() {
        return new InvalidTokenSignatureException(VerifyTokenErrorCode.TOKEN_SIGNATURE_MALFORMED);
    }

    public static InvalidTokenException malformedTokenSignature(Exception e) {
        return new InvalidTokenSignatureException(VerifyTokenErrorCode.TOKEN_SIGNATURE_MALFORMED, (Throwable)e);
    }

    public static InvalidTokenException invalidTokenSignature() {
        return new InvalidTokenSignatureException(VerifyTokenErrorCode.TOKEN_SIGNATURE_INVALID);
    }

    public static InvalidTokenException malformedTokenData() {
        return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_DATA_MALFORMED);
    }

    public static InvalidTokenException malformedTokenExpiration(NumberFormatException e) {
        return new InvalidTokenDataException(VerifyTokenErrorCode.TOKEN_EXPIRATION_MALFORMED, (Throwable)e);
    }

    public static InvalidTokenException invalidTokenScope(String requiredScope, String[] allowedScopes) {
        return new InvalidTokenScopeException(VerifyTokenErrorCode.TOKEN_SCOPE_INVALID, "Token is granted for " + Arrays.toString(allowedScopes) + " and can't be used for " + requiredScope);
    }

    public static InvalidTokenException malformedTokenScope() {
        return new InvalidTokenScopeException(VerifyTokenErrorCode.TOKEN_SCOPE_MALFORMED);
    }

    public static InvalidTokenException unknownClient(String id) {
        return new UnknownTokenClientException(VerifyTokenErrorCode.TOKEN_CLIENT_INVALID, "Client " + id + " is unknown", id);
    }

    @NotNull
    public static InvalidTokenException userWasDeleted(@NotNull String userID) {
        return new InvalidTokenUserException(VerifyTokenErrorCode.TOKEN_USER_DELETED, "User [" + userID + "] who owned the access token was deleted");
    }

    public static InvalidTokenException notVerifiedEmail() {
        return new InvalidPermanentTokenException(VerifyTokenErrorCode.TOKEN_OWNER_EMAIL_IS_NOT_VERIFIED);
    }

    public static InvalidTokenException notAcceptedEndUserAgreement() {
        return new InvalidPermanentTokenException(VerifyTokenErrorCode.TOKEN_OWNER_HAS_NOT_ACCEPTED_EUA);
    }

    public static InvalidTokenException invalidPermanentToken() {
        return new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_INVALID);
    }

    @NotNull
    public static InvalidTokenException invalidPermanentTokenUsername(@NotNull String tokenUsername, @NotNull String actualUsername) {
        return new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_USERNAME_INVALID, "Token is granted to " + actualUsername + " but used for " + tokenUsername);
    }

    @NotNull
    public static InvalidTokenException invalidPermanentTokenName(@NotNull String tokenName, @NotNull String actualName) {
        return new InvalidPermanentTokenException(VerifyTokenErrorCode.PERMANENT_TOKEN_NAME_INVALID, "Token name is " + actualName + " but it is used with a name " + tokenName);
    }

    @NotNull
    public static InvalidTokenException malformedPermanentToken() {
        return new InvalidTokenDataException(VerifyTokenErrorCode.PERMANENT_TOKEN_MALFORMED);
    }

    @NotNull
    public static InvalidTokenException malformedPermanentTokenUsername(@NotNull Exception cause) {
        return new InvalidTokenDataException(VerifyTokenErrorCode.PERMANENT_TOKEN_USERNAME_MALFORMED, (Throwable)cause);
    }

    @NotNull
    public static InvalidTokenException malformedPermanentTokenName(@NotNull Exception cause) {
        return new InvalidTokenDataException(VerifyTokenErrorCode.PERMANENT_TOKEN_NAME_MALFORMED, (Throwable)cause);
    }

    public static InvalidTokenException expired(Date checkedAt, Date grantedTill) {
        return new TokenExpiredException(VerifyTokenErrorCode.TOKEN_EXPIRED, "Token has expired. It was granted till " + grantedTill + " and was checked at " + checkedAt, checkedAt, grantedTill);
    }

    public static InvalidTokenException invalidAuthHeaderType() {
        return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.AUTH_HEADER_TYPE_UNKNOWN);
    }

    public static InvalidTokenException bearerAuthHeaderTypeExpected() {
        return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.BEARER_EXPECTED);
    }

    public static InvalidTokenException basicAuthHeaderTypeExpected() {
        return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.BASIC_EXPECTED);
    }

    public static InvalidTokenException basicAuthDisabled() {
        return new InvalidAuthorizationHeaderException(VerifyTokenErrorCode.BASIC_DISABLED);
    }
}

