/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.basic;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidAuthorizationHeaderException;
import com.intellij.hub.auth.InvalidTokenException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;

public final class BasicAuthToken
implements AuthToken {
    private static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private static final String SEMICOLON = ":";
    private final String username;
    private final String password;

    public BasicAuthToken(@NotNull String username, @NotNull String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    @NotNull
    public String encode() {
        return DatatypeConverter.printBase64Binary((byte[])(this.username + SEMICOLON + this.password).getBytes(DEFAULT_CHARSET));
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    @Override
    @NotNull
    public String getType() {
        return "Basic";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuthToken that = (BasicAuthToken)o;
        return this.password.equals(that.password) && this.username.equals(that.username);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    @NotNull
    public static BasicAuthToken decode(@NotNull String token) throws InvalidTokenException {
        String decodedB64Token = new String(DatatypeConverter.parseBase64Binary((String)token), DEFAULT_CHARSET);
        String[] parts = decodedB64Token.split(Pattern.quote(SEMICOLON));
        if (parts.length == 1) {
            return new BasicAuthToken(parts[0], "");
        }
        if (parts.length == 2) {
            return new BasicAuthToken(parts[0], parts[1]);
        }
        throw InvalidTokenException.malformedBasicToken(parts.length);
    }

    @NotNull
    public static BasicAuthToken decodeHeader(@NotNull String header) throws InvalidTokenException {
        if (!BasicAuthToken.isBasic(header)) {
            throw InvalidAuthorizationHeaderException.basicAuthHeaderTypeExpected();
        }
        return BasicAuthToken.decode(header.substring("Basic ".length()));
    }

    @NotNull
    public static String encodeHeader(@NotNull BasicAuthToken token) {
        return "Basic " + token.encode();
    }

    public static boolean isBasic(String header) {
        return header != null && header.length() > 0 && header.startsWith("Basic ");
    }
}

