/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.consumer;

import com.intellij.hub.auth.OAuthException;
import com.intellij.hub.core.Error;
import java.net.URI;
import org.jetbrains.annotations.Nullable;

public class OAuth2TokenLoadException
extends OAuthException
implements Error {
    private final String error;
    private final String description;
    private final String url;
    private final int statusCode;

    public OAuth2TokenLoadException(String error, int statusCode, String description, String url) {
        this(error, statusCode, description, url, null);
    }

    public OAuth2TokenLoadException(String error, int statusCode, String description, String url, Throwable cause) {
        super("Can't load token: " + error + (description != null && description.length() > 0 ? " (" + description + ")" : ""), cause);
        this.error = error;
        this.description = description;
        this.url = url;
        this.statusCode = statusCode;
    }

    public OAuth2TokenLoadException(Error error) {
        this(error.getError(), error.getStatusCode(), error.getMessage(), error.getURI() != null ? error.getURI().toASCIIString() : null);
    }

    @Override
    public String getError() {
        return this.error;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public URI getURI() {
        return this.url != null ? URI.create(this.url) : null;
    }

    @Override
    @Nullable
    public String getDeveloperMessage() {
        return null;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Error getOAuthError() {
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public String getField() {
        return null;
    }
}

