/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.error;

import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuthError
implements Error {
    private final int statusCode;
    @NotNull
    private final String errorCode;
    @Nullable
    private final URI uri;
    @Nullable
    private final String description;
    @Nullable
    private final String devDescription;

    private OAuthError(String errorCode, int statusCode, String description, String devDescription, URI uri) {
        this.errorCode = errorCode;
        this.statusCode = statusCode;
        this.description = description;
        this.devDescription = devDescription;
        this.uri = uri;
    }

    public OAuthError(OAuthErrorCode code, String description, String devDescription, URI uri) {
        this(code.getASCIICode(), code.getStatusCode(), description == null || description.length() == 0 ? code.getDescription() : description, devDescription == null || devDescription.length() == 0 ? code.getDescription() : devDescription, uri);
    }

    public OAuthError(OAuthErrorCode code, String description, URI uri) {
        this(code, description, null, uri);
    }

    @Override
    @NotNull
    public String getError() {
        return this.errorCode;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.description;
    }

    @Override
    @Nullable
    public String getDeveloperMessage() {
        return this.devDescription;
    }

    @Override
    @Nullable
    public URI getURI() {
        return this.uri;
    }

    @Override
    @Nullable
    public String getField() {
        return null;
    }

    public String toString() {
        StringBuilder res = new StringBuilder(this.getError());
        if (this.description != null) {
            res.append(":").append(this.description);
        }
        return res.toString();
    }
}

