/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.provider.verifier;

import com.intellij.hub.auth.InvalidTokenSignatureException;
import com.intellij.hub.auth.TokenVerification;
import com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource;
import com.intellij.hub.auth.oauth2.provider.verifier.TokenVerifier;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import org.jetbrains.annotations.NotNull;

public class SHA1withDSAVerifier
implements TokenVerifier {
    public static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    @NotNull
    private final DSAPublicKeySource publicKeySource;

    public SHA1withDSAVerifier(@NotNull DSAPublicKeySource publicKey) {
        this.publicKeySource = publicKey;
    }

    @Override
    public void verify(@NotNull AccessToken token) throws InvalidTokenSignatureException {
        TokenVerification.verifySignature(token, this.publicKeySource);
    }
}

