/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidTokenException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentToken
implements AuthToken {
    private final String username;
    private final String name;
    private final String secret;
    private static final Pattern TOKEN_PATTERN = Pattern.compile("perm:([^.]+)\\.([^.]+)\\.(.+)");

    public PermanentToken(@NotNull String username, @NotNull String name, @NotNull String secret) {
        this.username = username;
        this.secret = secret;
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getName() {
        return this.name;
    }

    public String getSecret() {
        return this.secret;
    }

    @Override
    @NotNull
    public String getType() {
        return "Bearer";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PermanentToken)) {
            return false;
        }
        PermanentToken that = (PermanentToken)o;
        return Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getSecret(), that.getSecret());
    }

    public int hashCode() {
        return Objects.hash(this.getUsername(), this.getSecret());
    }

    public String toString() {
        return "perm{" + this.username + "}.{" + this.name + "}";
    }

    @Override
    @NotNull
    public String encode() {
        String usernameBase64 = DatatypeConverter.printBase64Binary((byte[])this.username.getBytes());
        String nameBase64 = DatatypeConverter.printBase64Binary((byte[])this.name.getBytes());
        return "perm:" + usernameBase64 + "." + nameBase64 + "." + this.getSecret();
    }

    @NotNull
    public static PermanentToken decode(@NotNull String data) {
        String name;
        String username;
        Matcher matcher = TOKEN_PATTERN.matcher(data);
        if (!matcher.matches()) {
            throw InvalidTokenException.malformedPermanentToken();
        }
        try {
            username = new String(DatatypeConverter.parseBase64Binary((String)matcher.group(1)), Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            throw InvalidTokenException.malformedPermanentTokenUsername(e);
        }
        try {
            name = new String(DatatypeConverter.parseBase64Binary((String)matcher.group(2)), Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            throw InvalidTokenException.malformedPermanentTokenName(e);
        }
        String secret = matcher.group(3);
        return new PermanentToken(username, name, secret);
    }

    @NotNull
    public static String encodeHeader(@NotNull PermanentToken token) {
        return "Bearer " + token.encode();
    }

    public static boolean isPermanentTokenHeader(@Nullable String header) {
        return header != null && header.startsWith("Bearer ") && TOKEN_PATTERN.matcher(header.substring("Bearer ".length())).matches();
    }

    @NotNull
    public static PermanentToken decodeHeader(@NotNull String header) throws InvalidTokenException {
        if (!PermanentToken.isPermanentTokenHeader(header)) {
            throw InvalidTokenException.bearerAuthHeaderTypeExpected();
        }
        return PermanentToken.decode(header.substring("Bearer ".length()));
    }
}

