/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.InvalidTokenException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ScopeUtil {
    public static final String SCOPE_DELIMITER = " ";

    @NotNull
    public static String encodeScope(@NotNull String[] scope2) {
        if (scope2.length <= 0) {
            throw new IllegalArgumentException("Scope can't be empty array");
        }
        StringBuilder builder = new StringBuilder();
        boolean isEmpty = true;
        for (int i = 0; i < scope2.length; ++i) {
            if (!isEmpty) {
                builder.append(SCOPE_DELIMITER);
            }
            builder.append(ScopeUtil.encode(scope2[i]));
            isEmpty = false;
        }
        return builder.toString();
    }

    @NotNull
    public static String[] decodeScope(@NotNull String scope2) {
        String[] parts = scope2.split(Pattern.quote(SCOPE_DELIMITER));
        if (parts.length <= 0) {
            throw InvalidTokenException.malformedTokenScope();
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ScopeUtil.decode(parts[i]);
        }
        return parts;
    }

    public static String encode(String scopeItem) {
        try {
            return URLEncoder.encode(scopeItem, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decode(String scopeItem) {
        try {
            return URLDecoder.decode(scopeItem, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

