/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;

public class URIHelper {
    private static final String API_PATH = "api";
    private static final String SLASH = "/";
    private static final ResourceBundle DOCUMENTATION_PROPERTIES = ResourceBundle.getBundle("com.intellij.hub.core.Documentation");

    @NotNull
    public static URI toApiUri(@NotNull URI given) {
        String lastPart;
        URI result = given;
        String path = given.getPath();
        path = path == null ? "" : path;
        String[] splitted = path.split(SLASH);
        String string = lastPart = splitted.length > 0 ? splitted[splitted.length - 1] : "";
        if (lastPart == null || lastPart.length() == 0 || !lastPart.equalsIgnoreCase(API_PATH)) {
            StringBuilder builder = new StringBuilder(SLASH);
            for (int i = 1; i < splitted.length; ++i) {
                builder.append(splitted[i]).append(SLASH);
            }
            try {
                result = new URI(given.getScheme(), given.getAuthority(), builder.toString() + API_PATH, given.getQuery(), given.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    @NotNull
    public static String getHubDocsURI() {
        return DOCUMENTATION_PROPERTIES.getString("hub.documentation.url").replace("@doc.version.suffix@", "");
    }

    @NotNull
    public static String getHubDocsRestURI() {
        return DOCUMENTATION_PROPERTIES.getString("hub.documentation.rest.url").replace("@doc.version.suffix@", "");
    }

    @NotNull
    public static String getHubDocsOAuthErrorURI(@NotNull String docPrefix, @NotNull String code) {
        String errorURLFormat = DOCUMENTATION_PROPERTIES.getString("hub.documentation.oauth.error.url").replace("@doc.version.suffix@", "");
        return String.format(errorURLFormat, docPrefix, code);
    }
}

