/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.jira.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.NamedItem;
import jetbrains.jetpass.auth.module.jira.rest.client.api.JiraUserDetails;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.AuthmoduleJSON;
import jetbrains.jetpass.rest.dto.AuthorityHolderJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EmailJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jiradetails")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=JiradetailsJSON.class)
public class JiradetailsJSON
extends DetailsJSON
implements JiraUserDetails {
    @XmlElement(name="login")
    private String login;
    @XmlElement(name="fullName")
    private String fullName;
    @XmlElement(name="changePasswordUrl")
    private String changePasswordUrl;

    public JiradetailsJSON() {
    }

    public JiradetailsJSON(@NotNull JiraUserDetails that) {
        NamedItem ref;
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        if (that.getEmail() != null) {
            this.setEmail(new EmailJSON(that.getEmail()));
        }
        if (that.getAuthModule() != null) {
            ref = new AuthmoduleJSON();
            ((AuthmoduleJSON)ref).setId(that.getAuthModule().getId());
            this.setAuthModule((AuthmoduleJSON)ref);
        }
        this.setAuthModuleName(that.getAuthModuleName());
        if (that.getUser() != null) {
            ref = new UserJSON();
            ((AuthorityHolderJSON)ref).setId(that.getUser().getId());
            this.setUser((UserJSON)ref);
        }
        this.setLastAccessTime(that.getLastAccessTime());
        this.setLastAccessAddress(that.getLastAccessAddress());
        this.setLastAccessUserAgent(that.getLastAccessUserAgent());
        this.setLogin(that.getLogin());
        this.setFullName(that.getFullName());
        this.setChangePasswordUrl(that.getChangePasswordUrl());
    }

    @Override
    @Nullable
    public String getLogin() {
        return this.login;
    }

    @Override
    @Nullable
    public String getFullName() {
        return this.fullName;
    }

    @Override
    @Nullable
    public String getChangePasswordUrl() {
        return this.changePasswordUrl;
    }

    @XmlTransient
    public void setLogin(@Nullable String login2) {
        this.login = login2;
    }

    @XmlTransient
    public void setFullName(@Nullable String fullName) {
        this.fullName = fullName;
    }

    @XmlTransient
    public void setChangePasswordUrl(@Nullable String changePasswordUrl) {
        this.changePasswordUrl = changePasswordUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JiraUserDetails)) {
            return false;
        }
        JiraUserDetails that = (JiraUserDetails)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static JiradetailsJSON wrap(@NotNull JiraUserDetails that) {
        if (that instanceof JiradetailsJSON) {
            return (JiradetailsJSON)that;
        }
        return new JiradetailsJSON(that);
    }
}

