/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import com.intellij.hub.auth.request.Header;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import jetbrains.jetpass.client.BaseField;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseClient {
    protected final WebTarget resource;
    @Nullable
    protected final TokenHolder container;

    protected BaseClient(@NotNull WebTarget resource) {
        this(resource, null);
    }

    protected BaseClient(@NotNull WebTarget resource, @Nullable TokenHolder container) {
        this(resource, container, false);
    }

    protected BaseClient(@NotNull WebTarget resource, @Nullable TokenHolder container, boolean chuncked) {
        this.resource = resource;
        this.container = container;
        if (chuncked) {
            this.resource.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        }
    }

    protected WebTarget path(@NotNull String id) {
        return this.resource.path(id);
    }

    protected WebTarget apply(@Nullable FieldPartial partial, @Nullable BaseFilter filter2) {
        WebTarget resource = this.resource;
        if (filter2 != null) {
            resource = filter2.apply(resource);
            if (filter2.isTotalRequested()) {
                FieldPartial<BaseField> fieldPartial = partial = partial != null ? partial.union(FieldPartial.TOTAL_PARTIAL) : FieldPartial.TOTAL_PARTIAL;
            }
        }
        if (partial != null) {
            resource = FieldPartial.apply(resource, partial);
        }
        return resource;
    }

    protected WebTarget apply(@Nullable FieldPartial partial) {
        return this.apply(partial, null);
    }

    protected Invocation.Builder prepare(@NotNull WebTarget resource) {
        Invocation.Builder builder = resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (this.container != null) {
            Header auth = this.container.getHeader();
            builder.header(auth.getName(), (Object)auth.getValue());
        }
        return builder;
    }

    public static String wrapObject(Object object) {
        return UriComponent.encodeTemplateNames((String)String.valueOf(object));
    }
}

